/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.sample.server;

import com.alibaba.cloud.ai.mcp.sample.server.OpenMeteoService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.springframework.ai.tool.annotation.Tool;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

@Service
public class OpenMeteoService {
    private static final String BASE_URL = "https://api.open-meteo.com/v1";
    private final RestClient restClient = RestClient.builder().baseUrl("https://api.open-meteo.com/v1").defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("User-Agent", new String[]{"OpenMeteoClient/1.0"}).build();

    private String getWeatherDescription(int code) {
        return switch (code) {
            case 0 -> "\u6674\u6717";
            case 1, 2, 3 -> "\u591a\u4e91";
            case 45, 48 -> "\u96fe";
            case 51, 53, 55 -> "\u6bdb\u6bdb\u96e8";
            case 56, 57 -> "\u51bb\u96e8";
            case 61, 63, 65 -> "\u96e8";
            case 66, 67 -> "\u51bb\u96e8";
            case 71, 73, 75 -> "\u96ea";
            case 77 -> "\u96ea\u7c92";
            case 80, 81, 82 -> "\u9635\u96e8";
            case 85, 86 -> "\u9635\u96ea";
            case 95 -> "\u96f7\u66b4";
            case 96, 99 -> "\u96f7\u66b4\u4f34\u6709\u51b0\u96f9";
            default -> "\u672a\u77e5\u5929\u6c14";
        };
    }

    private String getWindDirection(int degrees) {
        if ((double)degrees >= 337.5 || (double)degrees < 22.5) {
            return "\u5317\u98ce";
        }
        if ((double)degrees >= 22.5 && (double)degrees < 67.5) {
            return "\u4e1c\u5317\u98ce";
        }
        if ((double)degrees >= 67.5 && (double)degrees < 112.5) {
            return "\u4e1c\u98ce";
        }
        if ((double)degrees >= 112.5 && (double)degrees < 157.5) {
            return "\u4e1c\u5357\u98ce";
        }
        if ((double)degrees >= 157.5 && (double)degrees < 202.5) {
            return "\u5357\u98ce";
        }
        if ((double)degrees >= 202.5 && (double)degrees < 247.5) {
            return "\u897f\u5357\u98ce";
        }
        if ((double)degrees >= 247.5 && (double)degrees < 292.5) {
            return "\u897f\u98ce";
        }
        return "\u897f\u5317\u98ce";
    }

    @Tool(description="\u83b7\u53d6\u6307\u5b9a\u7ecf\u7eac\u5ea6\u7684\u5929\u6c14\u9884\u62a5")
    public String getWeatherForecastByLocation(double latitude, double longitude) {
        WeatherData weatherData = (WeatherData)this.restClient.get().uri("/forecast?latitude={latitude}&longitude={longitude}&current=temperature_2m,apparent_temperature,relative_humidity_2m,precipitation,weather_code,wind_speed_10m,wind_direction_10m&daily=temperature_2m_max,temperature_2m_min,precipitation_sum,weather_code,wind_speed_10m_max,wind_direction_10m_dominant&timezone=auto&forecast_days=7", new Object[]{latitude, longitude}).retrieve().body(WeatherData.class);
        StringBuilder weatherInfo = new StringBuilder();
        WeatherData.CurrentWeather current = weatherData.current();
        String temperatureUnit = weatherData.currentUnits() != null ? weatherData.currentUnits().temperatureUnit() : "\u00b0C";
        String windSpeedUnit = weatherData.currentUnits() != null ? weatherData.currentUnits().windSpeedUnit() : "km/h";
        String humidityUnit = weatherData.currentUnits() != null ? weatherData.currentUnits().humidityUnit() : "%";
        weatherInfo.append(String.format("\u5f53\u524d\u5929\u6c14:\n\u6e29\u5ea6: %.1f%s (\u4f53\u611f\u6e29\u5ea6: %.1f%s)\n\u5929\u6c14: %s\n\u98ce\u5411: %s (%.1f %s)\n\u6e7f\u5ea6: %d%s\n\u964d\u6c34\u91cf: %.1f \u6beb\u7c73\n\n", current.temperature(), temperatureUnit, current.feelsLike(), temperatureUnit, this.getWeatherDescription(current.weatherCode().intValue()), this.getWindDirection(current.windDirection().intValue()), current.windSpeed(), windSpeedUnit, current.humidity(), humidityUnit, current.precipitation()));
        weatherInfo.append("\u672a\u6765\u5929\u6c14\u9884\u62a5:\n");
        WeatherData.DailyForecast daily = weatherData.daily();
        for (int i = 0; i < daily.time().size(); ++i) {
            String date = (String)daily.time().get(i);
            double tempMin = (Double)daily.tempMin().get(i);
            double tempMax = (Double)daily.tempMax().get(i);
            int weatherCode = (Integer)daily.weatherCode().get(i);
            double windSpeed = (Double)daily.windSpeedMax().get(i);
            int windDir = (Integer)daily.windDirection().get(i);
            double precip = (Double)daily.precipitationSum().get(i);
            LocalDate localDate = LocalDate.parse(date);
            String formattedDate = localDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd (EEE)"));
            weatherInfo.append(String.format("%s:\n\u6e29\u5ea6: %.1f%s ~ %.1f%s\n\u5929\u6c14: %s\n\u98ce\u5411: %s (%.1f %s)\n\u964d\u6c34\u91cf: %.1f \u6beb\u7c73\n\n", formattedDate, tempMin, temperatureUnit, tempMax, temperatureUnit, this.getWeatherDescription(weatherCode), this.getWindDirection(windDir), windSpeed, windSpeedUnit, precip));
        }
        return weatherInfo.toString();
    }

    @Tool(description="\u83b7\u53d6\u6307\u5b9a\u4f4d\u7f6e\u7684\u7a7a\u6c14\u8d28\u91cf\u4fe1\u606f\uff08\u6a21\u62df\u6570\u636e\uff09")
    public String getAirQuality(@ToolParam(description="\u7eac\u5ea6") double latitude, @ToolParam(description="\u7ecf\u5ea6") double longitude) {
        try {
            WeatherData weatherData = (WeatherData)this.restClient.get().uri("/forecast?latitude={latitude}&longitude={longitude}&current=temperature_2m&timezone=auto", new Object[]{latitude, longitude}).retrieve().body(WeatherData.class);
            int europeanAqi = (int)(Math.random() * 100.0) + 1;
            int usAqi = (int)((double)europeanAqi * 1.5);
            double pm10 = Math.random() * 50.0 + 5.0;
            double pm25 = Math.random() * 25.0 + 2.0;
            double co = Math.random() * 500.0 + 100.0;
            double no2 = Math.random() * 40.0 + 5.0;
            double so2 = Math.random() * 20.0 + 1.0;
            double o3 = Math.random() * 80.0 + 20.0;
            String europeanAqiLevel = this.getAqiLevel(Integer.valueOf(europeanAqi));
            String usAqiLevel = this.getUsAqiLevel(Integer.valueOf(usAqi));
            return String.format("\u7a7a\u6c14\u8d28\u91cf\u4fe1\u606f\uff08\u6a21\u62df\u6570\u636e\uff09:\n\n\u4f4d\u7f6e: \u7eac\u5ea6 %.4f, \u7ecf\u5ea6 %.4f\n\u6b27\u6d32\u7a7a\u6c14\u8d28\u91cf\u6307\u6570: %d (%s)\n\u7f8e\u56fd\u7a7a\u6c14\u8d28\u91cf\u6307\u6570: %d (%s)\nPM10: %.1f \u03bcg/m\u00b3\nPM2.5: %.1f \u03bcg/m\u00b3\n\u4e00\u6c27\u5316\u78b3(CO): %.1f \u03bcg/m\u00b3\n\u4e8c\u6c27\u5316\u6c2e(NO2): %.1f \u03bcg/m\u00b3\n\u4e8c\u6c27\u5316\u786b(SO2): %.1f \u03bcg/m\u00b3\n\u81ed\u6c27(O3): %.1f \u03bcg/m\u00b3\n\n\u6570\u636e\u66f4\u65b0\u65f6\u95f4: %s\n\n\u6ce8\u610f: \u7531\u4e8eOpenMeteo\u7a7a\u6c14\u8d28\u91cfAPI\u9650\u5236\uff0c\u6b64\u5904\u663e\u793a\u6a21\u62df\u6570\u636e\uff0c\u4ec5\u4f9b\u53c2\u8003\u3002\n", latitude, longitude, europeanAqi, europeanAqiLevel, usAqi, usAqiLevel, pm10, pm25, co, no2, so2, o3, weatherData.current().time());
        }
        catch (Exception e) {
            return String.format("\u7a7a\u6c14\u8d28\u91cf\u4fe1\u606f\uff08\u5b8c\u5168\u6a21\u62df\u6570\u636e\uff09:\n\n\u4f4d\u7f6e: \u7eac\u5ea6 %.4f, \u7ecf\u5ea6 %.4f\n\u6b27\u6d32\u7a7a\u6c14\u8d28\u91cf\u6307\u6570: %d (%s)\n\u7f8e\u56fd\u7a7a\u6c14\u8d28\u91cf\u6307\u6570: %d (%s)\nPM10: %.1f \u03bcg/m\u00b3\nPM2.5: %.1f \u03bcg/m\u00b3\n\u4e00\u6c27\u5316\u78b3(CO): %.1f \u03bcg/m\u00b3\n\u4e8c\u6c27\u5316\u6c2e(NO2): %.1f \u03bcg/m\u00b3\n\u4e8c\u6c27\u5316\u786b(SO2): %.1f \u03bcg/m\u00b3\n\u81ed\u6c27(O3): %.1f \u03bcg/m\u00b3\n\n\u6ce8\u610f: \u7531\u4e8eAPI\u9650\u5236\uff0c\u6b64\u5904\u663e\u793a\u5b8c\u5168\u6a21\u62df\u6570\u636e\uff0c\u4ec5\u4f9b\u53c2\u8003\u3002\n", latitude, longitude, 50, this.getAqiLevel(Integer.valueOf(50)), 75, this.getUsAqiLevel(Integer.valueOf(75)), 25.0, 15.0, 300.0, 20.0, 5.0, 40.0);
        }
    }

    private String getAqiLevel(Integer aqi) {
        if (aqi == null) {
            return "\u672a\u77e5";
        }
        if (aqi <= 20) {
            return "\u4f18";
        }
        if (aqi <= 40) {
            return "\u826f";
        }
        if (aqi <= 60) {
            return "\u4e2d\u7b49";
        }
        if (aqi <= 80) {
            return "\u8f83\u5dee";
        }
        if (aqi <= 100) {
            return "\u5dee";
        }
        return "\u6781\u5dee";
    }

    private String getUsAqiLevel(Integer aqi) {
        if (aqi == null) {
            return "\u672a\u77e5";
        }
        if (aqi <= 50) {
            return "\u4f18";
        }
        if (aqi <= 100) {
            return "\u4e2d\u7b49";
        }
        if (aqi <= 150) {
            return "\u5bf9\u654f\u611f\u4eba\u7fa4\u4e0d\u5065\u5eb7";
        }
        if (aqi <= 200) {
            return "\u4e0d\u5065\u5eb7";
        }
        if (aqi <= 300) {
            return "\u975e\u5e38\u4e0d\u5065\u5eb7";
        }
        return "\u5371\u9669";
    }

    public static void main(String[] args) {
        OpenMeteoService client = new OpenMeteoService();
        System.out.println(client.getWeatherForecastByLocation(39.9042, 116.4074));
        System.out.println(client.getAirQuality(39.9042, 116.4074));
    }
}

