#include "stdafx.h"
#include "MD5.h"
#include "MD5_KEYVAL.h"

//---------------------------------------------
//	MD5 added methods
//---------------------------------------------

// Generate 128 bits (16 bytes) MD5 key value using the input string
bool MD5::MD5_EncodeKey(char* lpszInputStr, char* lpszOutputKeyVal)
{
	unsigned int inputlen = strlen((char*)lpszInputStr);

	update((unsigned char*)lpszInputStr, inputlen);

	finalize();

	for (int i = 0; i < 16; i++)
	{
		lpszOutputKeyVal[i] = digest[i];
	}

	init();

	return true;
}

// Generate 128 bits (16 bytes) MD5 key value using the input string and key index (0~65535)
bool MD5::MD5_EncodeKeyVal(char* lpszInputStr, char* lpszOutputKeyVal, int iKeyIndex)
{
	if ((iKeyIndex < 0) || (iKeyIndex >= MAX_KEY_INDEX))
	{
		return false;
	}

	unsigned int inputlen = strlen((char*)lpszInputStr);

	setmagicnum(iKeyIndex);

	update((unsigned char*)lpszInputStr, inputlen);

	finalize();

	for (int i = 0; i < 16; i++)
	{
		lpszOutputKeyVal[i] = digest[i];
	}

	init();

	return true;
}

// Generate 128 x 2 bits (32 bytes) MD5 string key value using the input string and key index (0~255)
bool MD5::MD5_EncodeString(char* lpszInputStr, char* lpszOutputStr, int iKeyIndex)
{
	if ((iKeyIndex < 0) || (iKeyIndex >= MAX_KEY_INDEX))
	{
		return false;
	}

	unsigned int inputlen = strlen((char*)lpszInputStr);

	setmagicnum(iKeyIndex);

	update((unsigned char*)lpszInputStr, inputlen);

	finalize();

	strcpy_s(lpszOutputStr, 33, hex_digest());

	init();

	return true;
}

// Authenticate key value by inputting string and MD5 key value (true: correct / false: incorrect)
bool MD5::MD5_CheckValue(char* lpszInputStr, char* szKeyVal)
{
	char szBUF[16] = { 0 };

	MD5_EncodeKey(lpszInputStr, szBUF);

	for (int i = 0; i < 16; i++)
	{
		if (szKeyVal[i] != szBUF[i])
		{
			return false;
		}
	}

	return true;
}

// Authenticate key value by inputting string, MD5 key value and key index (0~255) (true: correct / false: incorrect)
bool MD5::MD5_CheckValue(char* lpszInputStr, char* szKeyVal, int iKeyIndex)
{
	char szBUF[16] = { 0 };

	MD5_EncodeKeyVal(lpszInputStr, szBUF, iKeyIndex);

	for (int i = 0; i < 16; i++)
	{
		if (szKeyVal[i] != szBUF[i])
		{
			return false;
		}
	}

	return true;
}

void MD5::setmagicnum(int keyindex)
{
	if ((keyindex < 0) || (keyindex >= MAX_KEY_INDEX))
	{
		return;
	}

	// Load magic initialization constants.
	state[0] = MD5_KEYVAL[keyindex * 4 + 0];
	state[1] = MD5_KEYVAL[keyindex * 4 + 1];
	state[2] = MD5_KEYVAL[keyindex * 4 + 2];
	state[3] = MD5_KEYVAL[keyindex * 4 + 3];
}

//---------------------------------------------
//	MD5 existing methods
//---------------------------------------------

// MD5 simple initialization method
MD5::MD5()
{
	init();
}

// MD5 block update operation. Continues an MD5 message-digest
// operation, processing another message block, and updating the
// context.
void MD5::update(uint1* input, uint4 input_length)
{
	uint4 input_index, buffer_index;

	uint4 buffer_space; // how much space is left in buffer

	if (finalized)
	{
		// so we can't update!
		std::cerr << "MD5::update:  Can't update a finalized digest!" << std::endl;

		return;
	}

	// Compute number of bytes mod 64
	buffer_index = (unsigned int)((count[0] >> 3) & 0x3F);

	// Update number of bits
	if ((count[0] += ((uint4)input_length << 3)) < ((uint4)input_length << 3))
	{
		count[1]++;
	}

	count[1] += ((uint4)input_length >> 29);

	buffer_space = 64 - buffer_index; // how much space is left in buffer

	// Transform as many times as possible.
	if (input_length >= buffer_space)
	{
		// ie. we have enough to fill the buffer
		// fill the rest of the buffer and transform
		memcpy(buffer + buffer_index, input, buffer_space);

		transform(buffer);

		// now, transform each 64-byte piece of the input, bypassing the buffer
		for (input_index = buffer_space; input_index + 63 < input_length; input_index += 64)
		{
			transform(input + input_index);
		}

		buffer_index = 0; // so we can buffer remaining
	}
	else
	{
		input_index = 0; // so we can buffer the whole input
	}

	// and here we do the buffering:
	memcpy(buffer + buffer_index, input + input_index, input_length - input_index);
}

// MD5 update for files.
// Like above, except that it works on files (and uses above as a primitive.)
void MD5::update(FILE* file)
{
	unsigned char buffer[1024];

	int len;

	while (len = fread(buffer, 1, 1024, file))
	{
		update(buffer, len);
	}

	fclose(file);
}

// MD5 update for istreams.
// Like update for files; see above.
void MD5::update(std::istream& stream)
{
	unsigned char buffer[1024];

	int len;

	while (stream.good())
	{
		stream.read((char*)buffer, 1024); // note that return value of read is unusable.

		len = (int)stream.gcount();

		update(buffer, len);
	}
}

// MD5 update for ifstreams.
// Like update for files; see above.
void MD5::update(std::ifstream& stream)
{
	unsigned char buffer[1024];

	int len;

	while (stream.good())
	{
		stream.read((char*)buffer, 1024); // note that return value of read is unusable.

		len = (int)stream.gcount();

		update(buffer, len);
	}
}

// MD5 finalization. Ends an MD5 message-digest operation, writing the
// the message digest and zeroizing the context.
void MD5::finalize()
{
	unsigned char bits[8];

	unsigned int index, padLen;

	static uint1 PADDING[64] =
	{
		0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};

	if (finalized)
	{
		std::cerr << "MD5::finalize:  Already finalized this digest!" << std::endl;

		return;
	}

	// Save number of bits
	encode(bits, count, 8);

	// Pad out to 56 mod 64.
	index = (uint4)((count[0] >> 3) & 0x3f);

	padLen = (index < 56) ? (56 - index) : (120 - index);

	update(PADDING, padLen);

	// Append length (before padding)
	update(bits, 8);

	// Store state in digest
	encode(digest, state, 16);

	// Zeroize sensitive information
	memset(buffer, 0, sizeof(*buffer));

	finalized = 1;
}

MD5::MD5(FILE* file)
{
	init();  // must be called be all constructors

	update(file);

	finalize();
}

MD5::MD5(std::istream& stream)
{
	init();  // must called by all constructors

	update(stream);

	finalize();
}

MD5::MD5(std::ifstream& stream)
{
	init();  // must called by all constructors

	update(stream);

	finalize();
}

unsigned char* MD5::raw_digest()
{
	if (!finalized)
	{
		std::cerr << "MD5::raw_digest:  Can't get digest if you haven't " << "finalized the digest!" << std::endl;

		return ((unsigned char*)"");
	}

	memcpy((uint1*)m_cRaw_digest, digest, 16);

	return m_cRaw_digest;
}

char* MD5::hex_digest()
{
	int i;

	if (!finalized)
	{
		std::cerr << "MD5::hex_digest:  Can't get digest if you haven't " << "finalized the digest!" << std::endl;

		return "";
	}

	for (i = 0; i < 16; i++)
	{
		wsprintf(m_cHex_digest + i * 2, "%02x", digest[i]);
	}

	m_cHex_digest[32] = '\0';

	return m_cHex_digest;
}

std::ostream& operator<<(std::ostream& stream, MD5 context)
{
	stream << context.hex_digest();

	return stream;
}

// PRIVATE METHODS:

void MD5::init()
{
	finalized = 0; // we just started!

	// Nothing counted, so count=0
	count[0] = 0;
	count[1] = 0;

	// Load magic initialization constants.
	state[0] = 0x67452301;
	state[1] = 0xEFCDAB89;
	state[2] = 0x98BADCFE;
	state[3] = 0x10325476;
}

// MD5 basic transformation. Transforms state based on block.
void MD5::transform(uint1 block[64])
{
	uint4 a = state[0], b = state[1], c = state[2], d = state[3], x[16];

	decode(x, block, 64);

	assert(!finalized); // not just a user error, since the method is private

	/* Round 1 */
	FF(a, b, c, d, x[0], S11, 0xD76AA478); /* 1 */
	FF(d, a, b, c, x[1], S12, 0xE8C7B756); /* 2 */
	FF(c, d, a, b, x[2], S13, 0x242070DB); /* 3 */
	FF(b, c, d, a, x[3], S14, 0xC1BDCEEE); /* 4 */
	FF(a, b, c, d, x[4], S11, 0xF57C0FAF); /* 5 */
	FF(d, a, b, c, x[5], S12, 0x4787C62A); /* 6 */
	FF(c, d, a, b, x[6], S13, 0xA8304613); /* 7 */
	FF(b, c, d, a, x[7], S14, 0xFD469501); /* 8 */
	FF(a, b, c, d, x[8], S11, 0x698098D8); /* 9 */
	FF(d, a, b, c, x[9], S12, 0x8B44F7AF); /* 10 */
	FF(c, d, a, b, x[10], S13, 0xFFFF5BB1); /* 11 */
	FF(b, c, d, a, x[11], S14, 0x895CD7BE); /* 12 */
	FF(a, b, c, d, x[12], S11, 0x6B901122); /* 13 */
	FF(d, a, b, c, x[13], S12, 0xFD987193); /* 14 */
	FF(c, d, a, b, x[14], S13, 0xA679438E); /* 15 */
	FF(b, c, d, a, x[15], S14, 0x49B40821); /* 16 */

	/* Round 2 */
	GG(a, b, c, d, x[1], S21, 0xF61E2562); /* 17 */
	GG(d, a, b, c, x[6], S22, 0xC040B340); /* 18 */
	GG(c, d, a, b, x[11], S23, 0x265E5A51); /* 19 */
	GG(b, c, d, a, x[0], S24, 0xE9B6C7AA); /* 20 */
	GG(a, b, c, d, x[5], S21, 0xD62F105D); /* 21 */
	GG(d, a, b, c, x[10], S22, 0x2441453); /* 22 */
	GG(c, d, a, b, x[15], S23, 0xD8A1E681); /* 23 */
	GG(b, c, d, a, x[4], S24, 0xE7D3FBC8); /* 24 */
	GG(a, b, c, d, x[9], S21, 0x21E1CDE6); /* 25 */
	GG(d, a, b, c, x[14], S22, 0xC33707D6); /* 26 */
	GG(c, d, a, b, x[3], S23, 0xF4D50D87); /* 27 */
	GG(b, c, d, a, x[8], S24, 0x455A14ED); /* 28 */
	GG(a, b, c, d, x[13], S21, 0xA9E3E905); /* 29 */
	GG(d, a, b, c, x[2], S22, 0xFCEFA3F8); /* 30 */
	GG(c, d, a, b, x[7], S23, 0x676F02D9); /* 31 */
	GG(b, c, d, a, x[12], S24, 0x8D2A4C8A); /* 32 */

	/* Round 3 */
	HH(a, b, c, d, x[5], S31, 0xFFFA3942); /* 33 */
	HH(d, a, b, c, x[8], S32, 0x8771F681); /* 34 */
	HH(c, d, a, b, x[11], S33, 0x6D9D6122); /* 35 */
	HH(b, c, d, a, x[14], S34, 0xFDE5380C); /* 36 */
	HH(a, b, c, d, x[1], S31, 0xA4BEEA44); /* 37 */
	HH(d, a, b, c, x[4], S32, 0x4BDECFA9); /* 38 */
	HH(c, d, a, b, x[7], S33, 0xF6BB4B60); /* 39 */
	HH(b, c, d, a, x[10], S34, 0xBEBFBC70); /* 40 */
	HH(a, b, c, d, x[13], S31, 0x289B7EC6); /* 41 */
	HH(d, a, b, c, x[0], S32, 0xEAA127FA); /* 42 */
	HH(c, d, a, b, x[3], S33, 0xD4EF3085); /* 43 */
	HH(b, c, d, a, x[6], S34, 0x4881D05); /* 44 */
	HH(a, b, c, d, x[9], S31, 0xD9D4D039); /* 45 */
	HH(d, a, b, c, x[12], S32, 0xE6DB99E5); /* 46 */
	HH(c, d, a, b, x[15], S33, 0x1FA27CF8); /* 47 */
	HH(b, c, d, a, x[2], S34, 0xC4AC5665); /* 48 */

	/* Round 4 */
	II(a, b, c, d, x[0], S41, 0xF4292244); /* 49 */
	II(d, a, b, c, x[7], S42, 0x432AFF97); /* 50 */
	II(c, d, a, b, x[14], S43, 0xAB9423A7); /* 51 */
	II(b, c, d, a, x[5], S44, 0xFC93A039); /* 52 */
	II(a, b, c, d, x[12], S41, 0x655B59C3); /* 53 */
	II(d, a, b, c, x[3], S42, 0x8F0CCC92); /* 54 */
	II(c, d, a, b, x[10], S43, 0xFFEFF47D); /* 55 */
	II(b, c, d, a, x[1], S44, 0x85845DD1); /* 56 */
	II(a, b, c, d, x[8], S41, 0x6FA87E4F); /* 57 */
	II(d, a, b, c, x[15], S42, 0xFE2CE6E0); /* 58 */
	II(c, d, a, b, x[6], S43, 0xA3014314); /* 59 */
	II(b, c, d, a, x[13], S44, 0x4E0811A1); /* 60 */
	II(a, b, c, d, x[4], S41, 0xF7537E82); /* 61 */
	II(d, a, b, c, x[11], S42, 0xBD3AF235); /* 62 */
	II(c, d, a, b, x[2], S43, 0x2AD7D2BB); /* 63 */
	II(b, c, d, a, x[9], S44, 0xEB86D391); /* 64 */

	state[0] += a;
	state[1] += b;
	state[2] += c;
	state[3] += d;

	// Zeroize sensitive information.
	memset((uint1*)x, 0, sizeof(x));
}

// Encodes input (UINT4) into output (unsigned char). Assumes len is
// a multiple of 4.
void MD5::encode(uint1* output, uint4* input, uint4 len)
{
	unsigned int i, j;

	for (i = 0, j = 0; j < len; i++, j += 4)
	{
		output[j] = (uint1)(input[i] & 0xff);

		output[j + 1] = (uint1)((input[i] >> 8) & 0xff);

		output[j + 2] = (uint1)((input[i] >> 16) & 0xff);

		output[j + 3] = (uint1)((input[i] >> 24) & 0xff);
	}
}

// Decodes input (unsigned char) into output (UINT4). Assumes len is
// a multiple of 4.
void MD5::decode(uint4* output, uint1* input, uint4 len)
{
	unsigned int i, j;

	for (i = 0, j = 0; j < len; i++, j += 4)
	{
		output[i] = ((uint4)input[j]) | (((uint4)input[j + 1]) << 8) | (((uint4)input[j + 2]) << 16) | (((uint4)input[j + 3]) << 24);
	}
}

// Note: Replace "for loop" with standard memcpy if possible.
void MD5::memcpy(uint1* output, uint1* input, uint4 len)
{
	unsigned int i;

	for (i = 0; i < len; i++)
	{
		output[i] = input[i];
	}
}

// Note: Replace "for loop" with standard memset if possible.
void MD5::memset(uint1* output, uint1 value, uint4 len)
{
	unsigned int i;

	for (i = 0; i < len; i++)
	{
		output[i] = value;
	}
}

// ROTATE_LEFT rotates x left n bits.
inline unsigned int MD5::rotate_left(uint4 x, uint4 n)
{
	return (x << n) | (x >> (32 - n));
}

// F, G, H and I are basic MD5 functions.
inline unsigned int MD5::F(uint4 x, uint4 y, uint4 z)
{
	return (x & y) | (~x & z);
}

inline unsigned int MD5::G(uint4 x, uint4 y, uint4 z)
{
	return (x & z) | (y & ~z);
}

inline unsigned int MD5::H(uint4 x, uint4 y, uint4 z)
{
	return x ^ y ^ z;
}

inline unsigned int MD5::I(uint4 x, uint4 y, uint4 z)
{
	return y ^ (x | ~z);
}

// FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
// Rotation is separate from addition to prevent recomputation.
inline void MD5::FF(uint4& a, uint4 b, uint4 c, uint4 d, uint4 x, uint4  s, uint4 ac)
{
	a += F(b, c, d) + x + ac;

	a = rotate_left(a, s) + b;
}

inline void MD5::GG(uint4& a, uint4 b, uint4 c, uint4 d, uint4 x, uint4 s, uint4 ac)
{
	a += G(b, c, d) + x + ac;

	a = rotate_left(a, s) + b;
}

inline void MD5::HH(uint4& a, uint4 b, uint4 c, uint4 d, uint4 x, uint4 s, uint4 ac)
{
	a += H(b, c, d) + x + ac;

	a = rotate_left(a, s) + b;
}

inline void MD5::II(uint4& a, uint4 b, uint4 c, uint4 d, uint4 x, uint4 s, uint4 ac)
{
	a += I(b, c, d) + x + ac;

	a = rotate_left(a, s) + b;
}