#pragma once

class CCRC32
{
public:

	CCRC32();

	virtual ~CCRC32();

	void Initialize();

	bool FileCRC(const char* sFileName, unsigned long* ulOutCRC);

	bool FileCRC(const char* sFileName, unsigned long* ulOutCRC, unsigned long ulBufferSize);

	unsigned long FullCRC(const unsigned char* sData, unsigned long ulDataLength);

	void FullCRC(const unsigned char* sData, unsigned long ulLength, unsigned long* ulOutCRC);

	void PartialCRC(unsigned long* ulCRC, const unsigned char* sData, unsigned long ulDataLength);

private:

	unsigned long Reflect(unsigned long ulReflect, const char cChar);

	unsigned long ulTable[256]; // CRC lookup table array.
};