/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.series;

import java.util.Arrays;
import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;

public abstract class AxesChartSeriesNumericalNoErrorBars
extends MarkerSeries {
    double[] xDataAll;
    double[] yDataAll;
    double[] extraValuesAll;
    double[] xData;
    double[] yData;
    double[] extraValues;

    public AxesChartSeriesNumericalNoErrorBars(String name, double[] xData, double[] yData, double[] extraValues, Series.DataType xAxisDataType) {
        super(name, xAxisDataType);
        this.xDataAll = xData;
        this.yDataAll = yData;
        this.extraValuesAll = extraValues;
        this.xData = xData;
        this.yData = yData;
        this.extraValues = extraValues;
        this.calculateMinMax();
    }

    public void replaceData(double[] newXData, double[] newYData, double[] newExtraValues) {
        if (newExtraValues != null && newExtraValues.length != newYData.length) {
            throw new IllegalArgumentException("error bars and Y-Axis sizes are not the same!!!");
        }
        if (newXData.length != newYData.length) {
            throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
        }
        this.xDataAll = newXData;
        this.yDataAll = newYData;
        this.extraValuesAll = newExtraValues;
        this.xData = newXData;
        this.yData = newYData;
        this.extraValues = newExtraValues;
        this.calculateMinMax();
    }

    public void filterXByIndex(int startIndex, int endIndex) {
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.yDataAll.length, endIndex);
        this.xData = Arrays.copyOfRange(this.xDataAll, startIndex, endIndex);
        this.yData = Arrays.copyOfRange(this.yDataAll, startIndex, endIndex);
        if (this.extraValuesAll != null) {
            this.extraValues = Arrays.copyOfRange(this.extraValuesAll, startIndex, endIndex);
        }
        this.calculateMinMax();
    }

    public boolean filterXByValue(double minValue, double maxValue) {
        boolean extra;
        int length = this.xDataAll.length;
        boolean[] filterResult = new boolean[length];
        int remainingDataCount = 0;
        for (int i = 0; i < length; ++i) {
            boolean result2;
            double val = this.xDataAll[i];
            filterResult[i] = result2 = val >= minValue && val <= maxValue;
            if (!result2) continue;
            ++remainingDataCount;
        }
        if (remainingDataCount == length) {
            return false;
        }
        this.xData = new double[remainingDataCount];
        this.yData = new double[remainingDataCount];
        boolean bl = extra = this.extraValuesAll != null;
        if (extra) {
            this.extraValues = new double[remainingDataCount];
        }
        int ind = 0;
        for (int i = 0; i < length; ++i) {
            if (!filterResult[i]) continue;
            this.xData[ind] = this.xDataAll[i];
            this.yData[ind] = this.yDataAll[i];
            if (extra) {
                this.extraValues[ind] = this.extraValuesAll[i];
            }
            ++ind;
        }
        this.calculateMinMax();
        return true;
    }

    public void resetFilter() {
        this.xData = this.xDataAll;
        this.yData = this.yDataAll;
        this.extraValues = this.extraValuesAll;
        this.calculateMinMax();
    }

    double[] findMinMax(double[] data) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (double dataPoint : data) {
            if (Double.isNaN(dataPoint)) continue;
            if (dataPoint < min) {
                min = dataPoint;
            }
            if (!(dataPoint > max)) continue;
            max = dataPoint;
        }
        return new double[]{min, max};
    }

    @Override
    protected void calculateMinMax() {
        double[] xMinMax = this.findMinMax(this.xData);
        this.xMin = xMinMax[0];
        this.xMax = xMinMax[1];
        double[] yMinMax = this.extraValues == null ? this.findMinMax(this.yData) : this.findMinMaxWithErrorBars(this.yData, this.extraValues);
        this.yMin = yMinMax[0];
        this.yMax = yMinMax[1];
    }

    private double[] findMinMaxWithErrorBars(double[] data, double[] errorBars) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < data.length; ++i) {
            double d2 = data[i];
            double eb = errorBars[i];
            if (d2 - eb < min) {
                min = d2 - eb;
            }
            if (!(d2 + eb > max)) continue;
            max = d2 + eb;
        }
        return new double[]{min, max};
    }

    public boolean isAllXData() {
        return this.xData.length == this.xDataAll.length;
    }

    public double[] getXData() {
        return this.xData;
    }

    public double[] getYData() {
        return this.yData;
    }

    public double[] getExtraValues() {
        return this.extraValues;
    }
}

