/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.event.EventListenerList;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.style.Styler;

public class ChartButton
extends MouseAdapter
implements ChartPart {
    private final Chart chart;
    private final Styler styler;
    private Rectangle bounds;
    protected String text;
    boolean visible = true;
    private ActionEvent action;
    private final EventListenerList listenerList = new EventListenerList();
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    private Shape buttonRect;

    public ChartButton(XYChart xyChart, XChartPanel<XYChart> xChartPanel, String text) {
        this.text = text;
        this.chart = xyChart;
        this.styler = this.chart.getStyler();
        xChartPanel.addMouseListener(this);
        xChartPanel.addMouseMotionListener(this);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (!this.visible) {
            return;
        }
        if (this.buttonRect == null) {
            return;
        }
        if (this.buttonRect.contains(e2.getX(), e2.getY())) {
            this.fireActionPerformed();
        }
    }

    private void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (this.action == null) {
                this.action = new ActionEvent(this, 1001, this.text);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(this.action);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        if (!this.visible) {
            return;
        }
        this.bounds = g.getClipBounds();
        double boundsWidth = this.bounds.getWidth();
        if (boundsWidth < 30.0) {
            return;
        }
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.styler.getChartButtonFontColor());
        g.setFont(this.styler.getChartButtonFont());
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = new TextLayout(this.text, this.styler.getChartButtonFont(), frc);
        Shape shape = tl.getOutline(null);
        Rectangle2D textBounds = shape.getBounds2D();
        this.calculatePosition(textBounds);
        double textHeight = textBounds.getHeight();
        double textWidth = textBounds.getWidth();
        this.buttonRect = new Rectangle2D.Double(this.xOffset, this.yOffset, textWidth + (double)(this.styler.getChartButtonMargin() * 2), textHeight + (double)(this.styler.getChartButtonMargin() * 2));
        g.setColor(this.styler.getChartButtonBackgroundColor());
        g.fill(this.buttonRect);
        g.setStroke(SOLID_STROKE);
        g.setColor(this.styler.getChartButtonBorderColor());
        g.draw(this.buttonRect);
        double startx = this.xOffset + (double)this.styler.getChartButtonMargin();
        double starty = this.yOffset + (double)this.styler.getChartButtonMargin();
        g.setColor(this.styler.getChartButtonFontColor());
        AffineTransform orig = g.getTransform();
        AffineTransform at = new AffineTransform();
        at.translate(startx, starty + textHeight);
        g.transform(at);
        g.fill(shape);
        g.setTransform(orig);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private void calculatePosition(Rectangle2D textBounds) {
        double textHeight = textBounds.getHeight();
        double textWidth = textBounds.getWidth();
        double widthAdjustment = textWidth + (double)(this.styler.getChartButtonMargin() * 3);
        double heightAdjustment = textHeight + (double)(this.styler.getChartButtonMargin() * 3);
        double boundsWidth = this.bounds.getWidth();
        double boundsHeight = this.bounds.getHeight();
        switch (this.styler.getChartButtonPosition()) {
            case InsideNW: {
                this.xOffset = this.bounds.getX() + (double)this.styler.getChartButtonMargin();
                this.yOffset = this.bounds.getY() + (double)this.styler.getChartButtonMargin();
                break;
            }
            case InsideNE: {
                this.xOffset = this.bounds.getX() + boundsWidth - widthAdjustment;
                this.yOffset = this.bounds.getY() + (double)this.styler.getChartButtonMargin();
                break;
            }
            case InsideSE: {
                this.xOffset = this.bounds.getX() + boundsWidth - widthAdjustment;
                this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                break;
            }
            case InsideSW: {
                this.xOffset = this.bounds.getX() + (double)this.styler.getChartButtonMargin();
                this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                break;
            }
            case InsideN: {
                this.xOffset = this.bounds.getX() + boundsWidth / 2.0 - textWidth / 2.0 - (double)this.styler.getChartButtonMargin();
                this.yOffset = this.bounds.getY() + (double)this.styler.getChartButtonMargin();
                break;
            }
            case InsideS: {
                this.xOffset = this.bounds.getX() + boundsWidth / 2.0 - textWidth / 2.0 - (double)this.styler.getChartButtonMargin();
                this.yOffset = this.bounds.getY() + boundsHeight - heightAdjustment;
                break;
            }
        }
    }

    void setText(String text) {
        this.text = text;
    }

    void setVisible(boolean visible) {
        this.visible = visible;
    }
}

