/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Histogram {
    private final Collection<? extends Number> originalData;
    private final int numBins;
    private final double min;
    private final double max;
    private List<Double> xAxisData;
    private List<Double> yAxisData;

    public Histogram(Collection<? extends Number> data, int numBins) {
        this.sanityCheck(data, numBins);
        this.numBins = numBins;
        this.originalData = data;
        Double tempMax = -1.7976931348623157E308;
        Double tempMin = Double.MAX_VALUE;
        for (Number number : data) {
            double value = number.doubleValue();
            if (value > tempMax) {
                tempMax = value;
            }
            if (!(value < tempMin)) continue;
            tempMin = value;
        }
        this.max = tempMax;
        this.min = tempMin;
        this.init();
    }

    public Histogram(Collection<? extends Number> data, int numBins, double min, double max) {
        this.sanityCheck(data, numBins);
        if (max < min) {
            throw new IllegalArgumentException("max cannot be less than min!!!");
        }
        this.numBins = numBins;
        this.originalData = data;
        this.min = min;
        this.max = max;
        this.init();
    }

    private void sanityCheck(Collection<? extends Number> data, int numBins) {
        if (data == null) {
            throw new IllegalArgumentException("Histogram data cannot be null!!!");
        }
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Histogram data cannot be empty!!!");
        }
        if (data.contains(null)) {
            throw new IllegalArgumentException("Histogram data cannot contain null!!!");
        }
        if (numBins <= 0) {
            throw new IllegalArgumentException("Histogram numBins cannot be less than or equal to 0!!!");
        }
    }

    private void init() {
        double[] tempYAxisData = new double[this.numBins];
        double binSize = (this.max - this.min) / (double)this.numBins;
        Iterator<? extends Number> itr = this.originalData.iterator();
        double doubleValue = 0.0;
        int bin = 0;
        while (itr.hasNext()) {
            doubleValue = itr.next().doubleValue();
            if (doubleValue < this.min || doubleValue > this.max) continue;
            bin = (int)((doubleValue - this.min) / binSize);
            if (bin < this.numBins) {
                int n = bin;
                tempYAxisData[n] = tempYAxisData[n] + 1.0;
                continue;
            }
            int n = bin - 1;
            tempYAxisData[n] = tempYAxisData[n] + 1.0;
        }
        this.yAxisData = new ArrayList<Double>(this.numBins);
        for (double d2 : tempYAxisData) {
            this.yAxisData.add(d2);
        }
        this.xAxisData = new ArrayList<Double>(this.numBins);
        for (int i = 0; i < this.numBins; ++i) {
            this.xAxisData.add((double)i * (this.max - this.min) / (double)this.numBins + this.min + binSize / 2.0);
        }
    }

    public List<Double> getxAxisData() {
        return this.xAxisData;
    }

    public List<Double> getyAxisData() {
        return this.yAxisData;
    }

    public Collection<? extends Number> getOriginalData() {
        return this.originalData;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

