/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDVectorFont;

final class GlyphCache {
    private static final Log LOG = LogFactory.getLog(GlyphCache.class);
    private final PDVectorFont font;
    private final Map<Integer, GeneralPath> cache = new HashMap<Integer, GeneralPath>();

    GlyphCache(PDVectorFont font) {
        this.font = font;
    }

    public GeneralPath getPathForCharacterCode(int code) {
        GeneralPath path2 = this.cache.get(code);
        if (path2 != null) {
            return path2;
        }
        try {
            if (!this.font.hasGlyph(code)) {
                String fontName = ((PDFontLike)((Object)this.font)).getName();
                if (this.font instanceof PDType0Font) {
                    int cid = ((PDType0Font)this.font).codeToCID(code);
                    String cidHex = String.format("%04x", cid);
                    LOG.warn((Object)("No glyph for code " + code + " (CID " + cidHex + ") in font " + fontName));
                } else if (this.font instanceof PDSimpleFont) {
                    PDSimpleFont simpleFont = (PDSimpleFont)((Object)this.font);
                    LOG.warn((Object)("No glyph for code " + code + " in " + this.font.getClass().getSimpleName() + " " + fontName + " (embedded or system font used: " + simpleFont.getFontBoxFont().getName() + ")"));
                    if (code == 10 && simpleFont.isStandard14()) {
                        path2 = new GeneralPath();
                        this.cache.put(code, path2);
                        return path2;
                    }
                } else {
                    LOG.warn((Object)("No glyph for code " + code + " in font " + fontName));
                }
            }
            path2 = this.font.getNormalizedPath(code);
            this.cache.put(code, path2);
            return path2;
        }
        catch (IOException e2) {
            String fontName = ((PDFontLike)((Object)this.font)).getName();
            LOG.error((Object)("Glyph rendering failed for code " + code + " in font " + fontName), (Throwable)e2);
            return new GeneralPath();
        }
    }
}

