/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;

public class PDAppearanceEntry
implements COSObjectable {
    private COSDictionary entry;

    private PDAppearanceEntry() {
    }

    public PDAppearanceEntry(COSDictionary entry) {
        this.entry = entry;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.entry;
    }

    public boolean isSubDictionary() {
        return !(this.entry instanceof COSStream);
    }

    public boolean isStream() {
        return this.entry instanceof COSStream;
    }

    public PDAppearanceStream getAppearanceStream() {
        if (!this.isStream()) {
            throw new IllegalStateException("This entry is not an appearance stream");
        }
        return new PDAppearanceStream((COSStream)this.entry);
    }

    public Map<COSName, PDAppearanceStream> getSubDictionary() {
        if (!this.isSubDictionary()) {
            throw new IllegalStateException("This entry is not an appearance subdictionary");
        }
        COSDictionary dict = this.entry;
        HashMap<COSName, PDAppearanceStream> map2 = new HashMap<COSName, PDAppearanceStream>();
        for (COSName name : dict.keySet()) {
            COSStream stream = dict.getCOSStream(name);
            if (stream == null) continue;
            map2.put(name, new PDAppearanceStream(stream));
        }
        return new COSDictionaryMap<COSName, PDAppearanceStream>(map2, dict);
    }
}

