/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.filespecification;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDEmbeddedFile
extends PDStream {
    public PDEmbeddedFile(PDDocument document) {
        super(document);
        this.getCOSObject().setItem(COSName.TYPE, (COSBase)COSName.EMBEDDED_FILE);
    }

    public PDEmbeddedFile(COSStream str) {
        super(str);
    }

    public PDEmbeddedFile(PDDocument doc, InputStream str) throws IOException {
        super(doc, str);
        this.getCOSObject().setItem(COSName.TYPE, (COSBase)COSName.EMBEDDED_FILE);
    }

    public PDEmbeddedFile(PDDocument doc, InputStream input, COSName filter2) throws IOException {
        super(doc, input, filter2);
        this.getCOSObject().setItem(COSName.TYPE, (COSBase)COSName.EMBEDDED_FILE);
    }

    public void setSubtype(String mimeType) {
        this.getCOSObject().setName(COSName.SUBTYPE, mimeType);
    }

    public String getSubtype() {
        return this.getCOSObject().getNameAsString(COSName.SUBTYPE);
    }

    public int getSize() {
        return this.getCOSObject().getEmbeddedInt(COSName.PARAMS, COSName.SIZE);
    }

    public void setSize(int size) {
        this.getCOSObject().setEmbeddedInt(COSName.PARAMS, COSName.SIZE, size);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getCOSObject().getEmbeddedDate(COSName.PARAMS, COSName.CREATION_DATE);
    }

    public void setCreationDate(Calendar creation) {
        this.getCOSObject().setEmbeddedDate(COSName.PARAMS, COSName.CREATION_DATE, creation);
    }

    public Calendar getModDate() throws IOException {
        return this.getCOSObject().getEmbeddedDate(COSName.PARAMS, COSName.MOD_DATE);
    }

    public void setModDate(Calendar mod) {
        this.getCOSObject().setEmbeddedDate(COSName.PARAMS, COSName.MOD_DATE, mod);
    }

    public String getCheckSum() {
        return this.getCOSObject().getEmbeddedString(COSName.PARAMS, COSName.CHECK_SUM);
    }

    public void setCheckSum(String checksum) {
        this.getCOSObject().setEmbeddedString(COSName.PARAMS, COSName.CHECK_SUM, checksum);
    }

    public String getMacSubtype() {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        return params != null ? params.getEmbeddedString(COSName.MAC, COSName.SUBTYPE) : null;
    }

    public void setMacSubtype(String macSubtype) {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        if (params == null && macSubtype != null) {
            params = new COSDictionary();
            this.getCOSObject().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString(COSName.MAC, COSName.SUBTYPE, macSubtype);
        }
    }

    public String getMacCreator() {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        return params != null ? params.getEmbeddedString(COSName.MAC, COSName.CREATOR) : null;
    }

    public void setMacCreator(String macCreator) {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        if (params == null && macCreator != null) {
            params = new COSDictionary();
            this.getCOSObject().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString(COSName.MAC, COSName.CREATOR, macCreator);
        }
    }

    public String getMacResFork() {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        return params != null ? params.getEmbeddedString(COSName.MAC, COSName.RES_FORK) : null;
    }

    public void setMacResFork(String macResFork) {
        COSDictionary params = this.getCOSObject().getCOSDictionary(COSName.PARAMS);
        if (params == null && macResFork != null) {
            params = new COSDictionary();
            this.getCOSObject().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString(COSName.MAC, COSName.RES_FORK, macResFork);
        }
    }
}

