/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

class EndstreamFilterStream {
    private boolean hasCR = false;
    private boolean hasLF = false;
    private int pos = 0;
    private boolean mustFilter = true;
    private long length = 0L;

    EndstreamFilterStream() {
    }

    public void filter(byte[] b2, int off, int len) {
        if (this.pos == 0 && len > 10) {
            this.mustFilter = false;
            for (int i = 0; i < 10; ++i) {
                if (b2[i] >= 9 && (b2[i] <= 10 || b2[i] >= 32 || b2[i] == 13)) continue;
                this.mustFilter = true;
                break;
            }
        }
        if (this.mustFilter) {
            if (this.hasCR) {
                this.hasCR = false;
                if (!this.hasLF && len == 1 && b2[off] == 10) {
                    return;
                }
                ++this.length;
            }
            if (this.hasLF) {
                ++this.length;
                this.hasLF = false;
            }
            if (len > 0) {
                if (b2[off + len - 1] == 13) {
                    this.hasCR = true;
                    --len;
                } else if (b2[off + len - 1] == 10) {
                    this.hasLF = true;
                    if (--len > 0 && b2[off + len - 1] == 13) {
                        this.hasCR = true;
                        --len;
                    }
                }
            }
        }
        this.length += (long)len;
        this.pos += len;
    }

    public long calculateLength() {
        if (this.hasCR && !this.hasLF) {
            ++this.length;
            ++this.pos;
        }
        this.hasCR = false;
        this.hasLF = false;
        return this.length;
    }
}

