/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class GsubWorkerForBengali
implements GsubWorker {
    private static final Log LOG = LogFactory.getLog(GsubWorkerForBengali.class);
    private static final String INIT_FEATURE = "init";
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("locl", "nukt", "akhn", "rphf", "blwf", "pstf", "half", "vatu", "cjct", "init", "pres", "abvs", "blws", "psts", "haln", "calt");
    private static final char[] BEFORE_HALF_CHARS = new char[]{'\u09bf', '\u09c7', '\u09c8'};
    private static final BeforeAndAfterSpanComponent[] BEFORE_AND_AFTER_SPAN_CHARS = new BeforeAndAfterSpanComponent[]{new BeforeAndAfterSpanComponent('\u09cb', '\u09c7', '\u09be'), new BeforeAndAfterSpanComponent('\u09cc', '\u09c7', '\u09d7')};
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;
    private final List<Integer> beforeHalfGlyphIds;
    private final Map<Integer, BeforeAndAfterSpanComponent> beforeAndAfterSpanGlyphIds;

    GsubWorkerForBengali(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
        this.beforeHalfGlyphIds = this.getBeforeHalfGlyphIds();
        this.beforeAndAfterSpanGlyphIds = this.getBeforeAndAfterSpanGlyphIds();
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> originalGlyphIds) {
        List<Integer> intermediateGlyphsFromGsub = originalGlyphIds;
        for (String feature : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(feature)) {
                LOG.debug((Object)("the feature " + feature + " was not found"));
                continue;
            }
            LOG.debug((Object)("applying the feature " + feature));
            ScriptFeature scriptFeature = this.gsubData.getFeature(feature);
            intermediateGlyphsFromGsub = this.applyGsubFeature(scriptFeature, intermediateGlyphsFromGsub);
        }
        return Collections.unmodifiableList(this.repositionGlyphs(intermediateGlyphsFromGsub));
    }

    private List<Integer> repositionGlyphs(List<Integer> originalGlyphIds) {
        List<Integer> glyphsRepositionedByBeforeHalf = this.repositionBeforeHalfGlyphIds(originalGlyphIds);
        return this.repositionBeforeAndAfterSpanGlyphIds(glyphsRepositionedByBeforeHalf);
    }

    private List<Integer> repositionBeforeHalfGlyphIds(List<Integer> originalGlyphIds) {
        ArrayList<Integer> repositionedGlyphIds = new ArrayList<Integer>(originalGlyphIds);
        for (int index = 1; index < originalGlyphIds.size(); ++index) {
            int glyphId = originalGlyphIds.get(index);
            if (!this.beforeHalfGlyphIds.contains(glyphId)) continue;
            int previousGlyphId = originalGlyphIds.get(index - 1);
            repositionedGlyphIds.set(index, previousGlyphId);
            repositionedGlyphIds.set(index - 1, glyphId);
        }
        return repositionedGlyphIds;
    }

    private List<Integer> repositionBeforeAndAfterSpanGlyphIds(List<Integer> originalGlyphIds) {
        ArrayList<Integer> repositionedGlyphIds = new ArrayList<Integer>(originalGlyphIds);
        for (int index = 1; index < originalGlyphIds.size(); ++index) {
            int glyphId = originalGlyphIds.get(index);
            BeforeAndAfterSpanComponent beforeAndAfterSpanComponent = this.beforeAndAfterSpanGlyphIds.get(glyphId);
            if (beforeAndAfterSpanComponent == null) continue;
            int previousGlyphId = originalGlyphIds.get(index - 1);
            repositionedGlyphIds.set(index, previousGlyphId);
            repositionedGlyphIds.set(index - 1, this.getGlyphId(beforeAndAfterSpanComponent.beforeComponentCharacter));
            repositionedGlyphIds.add(index + 1, this.getGlyphId(beforeAndAfterSpanComponent.afterComponentCharacter));
        }
        return repositionedGlyphIds;
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> originalGlyphs) {
        Set<List<Integer>> allGlyphIdsForSubstitution = scriptFeature.getAllGlyphIdsForSubstitution();
        if (allGlyphIdsForSubstitution.isEmpty()) {
            LOG.debug((Object)("getAllGlyphIdsForSubstitution() for " + scriptFeature.getName() + " is empty"));
            return originalGlyphs;
        }
        GlyphArraySplitterRegexImpl glyphArraySplitter = new GlyphArraySplitterRegexImpl(allGlyphIdsForSubstitution);
        List<List<Integer>> tokens = glyphArraySplitter.split(originalGlyphs);
        ArrayList<Integer> gsubProcessedGlyphs = new ArrayList<Integer>(tokens.size());
        tokens.forEach(chunk -> {
            if (scriptFeature.canReplaceGlyphs((List<Integer>)chunk)) {
                Integer glyphId = scriptFeature.getReplacementForGlyphs((List<Integer>)chunk);
                gsubProcessedGlyphs.add(glyphId);
            } else {
                gsubProcessedGlyphs.addAll((Collection<Integer>)chunk);
            }
        });
        LOG.debug((Object)("originalGlyphs: " + originalGlyphs + ", gsubProcessedGlyphs: " + gsubProcessedGlyphs));
        return gsubProcessedGlyphs;
    }

    private List<Integer> getBeforeHalfGlyphIds() {
        ArrayList<Integer> glyphIds = new ArrayList<Integer>(BEFORE_HALF_CHARS.length);
        for (char character : BEFORE_HALF_CHARS) {
            glyphIds.add(this.getGlyphId(character));
        }
        if (this.gsubData.isFeatureSupported(INIT_FEATURE)) {
            ScriptFeature feature = this.gsubData.getFeature(INIT_FEATURE);
            for (List<Integer> glyphCluster : feature.getAllGlyphIdsForSubstitution()) {
                glyphIds.add(feature.getReplacementForGlyphs(glyphCluster));
            }
        }
        return Collections.unmodifiableList(glyphIds);
    }

    private Integer getGlyphId(char character) {
        return this.cmapLookup.getGlyphId(character);
    }

    private Map<Integer, BeforeAndAfterSpanComponent> getBeforeAndAfterSpanGlyphIds() {
        HashMap<Integer, BeforeAndAfterSpanComponent> result2 = new HashMap<Integer, BeforeAndAfterSpanComponent>();
        for (BeforeAndAfterSpanComponent beforeAndAfterSpanComponent : BEFORE_AND_AFTER_SPAN_CHARS) {
            result2.put(this.getGlyphId(beforeAndAfterSpanComponent.originalCharacter), beforeAndAfterSpanComponent);
        }
        return Collections.unmodifiableMap(result2);
    }

    private static class BeforeAndAfterSpanComponent {
        private final char originalCharacter;
        private final char beforeComponentCharacter;
        private final char afterComponentCharacter;

        BeforeAndAfterSpanComponent(char originalCharacter, char beforeComponentCharacter, char afterComponentCharacter) {
            this.originalCharacter = originalCharacter;
            this.beforeComponentCharacter = beforeComponentCharacter;
            this.afterComponentCharacter = afterComponentCharacter;
        }
    }
}

