/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Lockable;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.FlowControlListener;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.flowcontrol.WindowCounter;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00a1\u00012\u00020\u00012\u00020\u0002:\b\u009e\u0001\u009f\u0001\u00a0\u0001\u00a1\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010V\u001a\u00020\u0011J\u0010\u0010W\u001a\u0004\u0018\u00010\u00122\u0006\u0010X\u001a\u00020\u0011J\u0017\u0010Y\u001a\u0004\u0018\u00010\u00122\u0006\u0010Z\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b[J\u0015\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020+H\u0000\u00a2\u0006\u0002\b_J$\u0010`\u001a\u00020\u00122\u0006\u0010a\u001a\u00020\u00112\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\bJ\u001c\u0010f\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\bJ&\u0010f\u001a\u00020\u00122\u0006\u0010a\u001a\u00020\u00112\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\bH\u0002J+\u0010g\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\b2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0002\bjJ(\u0010k\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\b2\b\u0010l\u001a\u0004\u0018\u00010m2\u0006\u0010n\u001a\u00020+J\u001d\u0010o\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010p\u001a\u00020qH\u0000\u00a2\u0006\u0002\brJ\u001d\u0010s\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010t\u001a\u00020qH\u0000\u00a2\u0006\u0002\buJ\u001d\u0010v\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010w\u001a\u00020+H\u0000\u00a2\u0006\u0002\bxJ\u001e\u0010y\u001a\u00020]2\u0006\u0010z\u001a\u00020\b2\u0006\u0010{\u001a\u00020\u00112\u0006\u0010|\u001a\u00020\u0011J\u0006\u0010}\u001a\u00020]J\u0006\u0010y\u001a\u00020]J\u0006\u0010~\u001a\u00020]J\u0006\u0010\u007f\u001a\u00020]J\u000f\u0010\u0080\u0001\u001a\u00020]2\u0006\u0010t\u001a\u00020qJ\t\u0010\u0081\u0001\u001a\u00020]H\u0016J-\u0010\u0081\u0001\u001a\u00020]2\u0007\u0010\u0082\u0001\u001a\u00020q2\u0007\u0010\u0083\u0001\u001a\u00020q2\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0000\u00a2\u0006\u0003\b\u0086\u0001J\u0015\u0010\u0087\u0001\u001a\u00020]2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0085\u0001H\u0002J\u0014\u0010\u0089\u0001\u001a\u00020]2\t\b\u0002\u0010\u008a\u0001\u001a\u00020\bH\u0007J\u0010\u0010\u008b\u0001\u001a\u00020]2\u0007\u0010\u008c\u0001\u001a\u000207J\u0010\u0010\u008d\u0001\u001a\u00020\b2\u0007\u0010\u008e\u0001\u001a\u00020+J\u000f\u0010\u008f\u0001\u001a\u00020]H\u0000\u00a2\u0006\u0003\b\u0090\u0001J\u0017\u0010\u0091\u0001\u001a\u00020\b2\u0006\u0010Z\u001a\u00020\u0011H\u0000\u00a2\u0006\u0003\b\u0092\u0001J%\u0010\u0093\u0001\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0003\b\u0094\u0001J.\u0010\u0095\u0001\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0007\u0010\u0096\u0001\u001a\u00020\bH\u0000\u00a2\u0006\u0003\b\u0097\u0001J2\u0010\u0098\u0001\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\u0006\u0010n\u001a\u00020\u00112\u0007\u0010\u0096\u0001\u001a\u00020\bH\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u001f\u0010\u009c\u0001\u001a\u00020]2\u0006\u0010Z\u001a\u00020\u00112\u0006\u0010p\u001a\u00020qH\u0000\u00a2\u0006\u0003\b\u009d\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u000e\u0010!\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u000203X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00109\"\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001e\u0010C\u001a\u00020+2\u0006\u0010B\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u001e\u0010F\u001a\u00020+2\u0006\u0010B\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010ER\u0014\u0010H\u001a\u00020IX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020M\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0015\u0010P\u001a\u00060QR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00110UX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a2\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "Lokhttp3/internal/concurrent/Lockable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "<init>", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "client", "", "getClient$okhttp", "()Z", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "streams", "", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "isShutdown", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "writerQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "pushQueue", "settingsListenerQueue", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "intervalPingsSent", "", "intervalPongsReceived", "degradedPingsSent", "degradedPongsReceived", "awaitPingsSent", "awaitPongsReceived", "degradedPongDeadlineNs", "flowControlListener", "Lokhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lokhttp3/internal/http2/FlowControlListener;", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "readBytes", "Lokhttp3/internal/http2/flowcontrol/WindowCounter;", "getReadBytes", "()Lokhttp3/internal/http2/flowcontrol/WindowCounter;", "value", "writeBytesTotal", "getWriteBytesTotal", "()J", "writeBytesMaximum", "getWriteBytesMaximum", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "currentPushRequests", "", "openStreamCount", "getStream", "id", "removeStream", "streamId", "removeStream$okhttp", "updateConnectionFlowControl", "", "read", "updateConnectionFlowControl$okhttp", "pushStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "newStream", "writeHeaders", "outFinished", "alternating", "writeHeaders$okhttp", "writeData", "buffer", "Lokio/Buffer;", "byteCount", "writeSynResetLater", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "writeSynResetLater$okhttp", "writeSynReset", "statusCode", "writeSynReset$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "awaitPong", "flush", "shutdown", "close", "connectionCode", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "start", "sendConnectionPreface", "setSettings", "settings", "isHealthy", "nowNs", "sendDegradedPingLater", "sendDegradedPingLater$okhttp", "pushedStream", "pushedStream$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushHeadersLater", "inFinished", "pushHeadersLater$okhttp", "pushDataLater", "source", "Lokio/BufferedSource;", "pushDataLater$okhttp", "pushResetLater", "pushResetLater$okhttp", "Builder", "ReaderRunnable", "Listener", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -UtilCommon.kt\nokhttp3/internal/_UtilCommonKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1054:1\n63#2:1055\n63#2:1056\n63#2:1057\n38#2:1058\n63#2:1059\n63#2:1061\n63#2:1062\n63#2:1063\n34#2:1064\n63#2:1065\n63#2:1066\n34#2:1067\n63#2:1068\n63#2:1069\n49#2,4:1070\n63#2:1079\n63#2:1101\n63#2:1102\n63#2:1103\n63#2:1104\n63#2:1105\n63#2:1106\n63#2:1109\n63#2:1115\n63#2:1121\n63#2:1125\n1#3:1060\n228#4,5:1074\n228#4,5:1085\n228#4,5:1091\n228#4,5:1096\n228#4,2:1107\n230#4,3:1110\n228#4,2:1113\n230#4,3:1116\n228#4,2:1119\n230#4,3:1122\n37#5:1080\n36#5,3:1081\n13472#6:1084\n13473#6:1090\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n179#1:1055\n181#1:1056\n184#1:1057\n188#1:1058\n195#1:1059\n247#1:1061\n248#1:1062\n318#1:1063\n326#1:1064\n399#1:1065\n410#1:1066\n412#1:1067\n429#1:1068\n431#1:1069\n457#1:1070,4\n464#1:1079\n524#1:1101\n525#1:1102\n536#1:1103\n562#1:1104\n926#1:1105\n157#1:1106\n938#1:1109\n956#1:1115\n983#1:1121\n997#1:1125\n459#1:1074,5\n472#1:1085,5\n478#1:1091,5\n483#1:1096,5\n935#1:1107,2\n935#1:1110,3\n953#1:1113,2\n953#1:1116,3\n979#1:1119,2\n979#1:1122,3\n466#1:1080\n466#1:1081,3\n471#1:1084\n471#1:1090\n*E\n"})
public final class Http2Connection
implements Closeable,
Lockable {
    @NotNull
    public static final Companion Companion;
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final TaskQueue writerQueue;
    @NotNull
    private final TaskQueue pushQueue;
    @NotNull
    private final TaskQueue settingsListenerQueue;
    @NotNull
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    @NotNull
    private final FlowControlListener flowControlListener;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private Settings peerSettings;
    @NotNull
    private final WindowCounter readBytes;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final Socket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    @NotNull
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    @NotNull
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(@NotNull Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$okhttp();
        this.flowControlListener = builder.getFlowControlListener$okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        boolean bl = false;
        if (builder.getClient$okhttp()) {
            void $this$okHttpSettings_u24lambda_u240;
            $this$okHttpSettings_u24lambda_u240.set(4, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.readBytes = new WindowCounter(0);
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(builder.getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.getSource$okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(builder.getPingIntervalMillis$okhttp());
            this.writerQueue.schedule(this.connectionName + " ping", pingIntervalNanos, () -> Http2Connection._init_$lambda$2(this, pingIntervalNanos));
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    @NotNull
    public final FlowControlListener getFlowControlListener$okhttp() {
        return this.flowControlListener;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "<set-?>");
        this.peerSettings = settings;
    }

    @NotNull
    public final WindowCounter getReadBytes() {
        return this.readBytes;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int openStreamCount() {
        int n;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            n = this.streams.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Http2Stream getStream(int id) {
        Http2Stream http2Stream;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            http2Stream = this.streams.get(id);
        }
        return http2Stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Http2Stream removeStream$okhttp(int streamId) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Http2Stream stream = this.streams.remove(streamId);
            Lockable $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
            ((Object)$this$notifyAll$iv).notifyAll();
            Http2Stream http2Stream = stream;
            return http2Stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateConnectionFlowControl$okhttp(long read) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            WindowCounter.update$default(this.readBytes, read, 0L, 2, null);
            long readBytesToAcknowledge = this.readBytes.getUnacknowledged();
            if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
                this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
                WindowCounter.update$default(this.readBytes, 0L, readBytesToAcknowledge, 1, null);
            }
            this.flowControlListener.receivingConnectionWindowChanged(this.readBytes);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final Http2Stream pushStream(int associatedStreamId, @NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        if (!(!this.client)) {
            boolean bl = false;
            String string = "Client cannot push requests.";
            throw new IllegalStateException(string.toString());
        }
        return this.newStream(associatedStreamId, requestHeaders, out);
    }

    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean outFinished = !out;
        boolean inFinished = false;
        boolean flushHeaders = false;
        Http2Stream stream = null;
        int streamId = 0;
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, inFinished, null);
                boolean bl3 = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (associatedStreamId == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                if (!(!this.client)) {
                    boolean bl4 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(string.toString());
                }
                this.writer.pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    public final void writeHeaders$okhttp(int streamId, boolean outFinished, @NotNull List<Header> alternating) throws IOException {
        Intrinsics.checkNotNullParameter(alternating, "alternating");
        this.writer.headers(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int streamId, boolean outFinished, @Nullable Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = 0L;
        byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite = 0;
            Lockable $this$withLock$iv = this;
            boolean $i$f$withLock = false;
            Lockable lockable = $this$withLock$iv;
            synchronized (lockable) {
                boolean bl = false;
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Lockable $this$wait$iv = this;
                        boolean $i$f$wait = false;
                        Intrinsics.checkNotNull($this$wait$iv, "null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min(toWrite, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    public final void writeSynResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] writeSynReset", 0L, false, () -> Http2Connection.writeSynResetLater$lambda$12(this, streamId, errorCode), 6, null);
    }

    public final void writeSynReset$okhttp(int streamId, @NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)statusCode, "statusCode");
        this.writer.rstStream(streamId, statusCode);
    }

    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] windowUpdate", 0L, false, () -> Http2Connection.writeWindowUpdateLater$lambda$13(this, streamId, unacknowledgedBytesRead), 6, null);
    }

    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            this.writer.ping(reply, payload1, payload2);
        }
        catch (IOException e2) {
            this.failConnection(e2);
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePing() throws InterruptedException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            long l = this.awaitPingsSent;
            this.awaitPingsSent = l + 1L;
            long l2 = l;
        }
        this.writePing(false, 3, 1330343787);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitPong() throws InterruptedException {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            while (this.awaitPongsReceived < this.awaitPingsSent) {
                Lockable $this$wait$iv = this;
                boolean $i$f$wait = false;
                Intrinsics.checkNotNull($this$wait$iv, "null cannot be cast to non-null type java.lang.Object");
                ((Object)$this$wait$iv).wait();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)statusCode, "statusCode");
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.goAway(lastGoodStreamId.element, statusCode, _UtilCommonKt.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$okhttp(@NotNull ErrorCode connectionCode, @NotNull ErrorCode streamCode, @Nullable IOException cause) {
        Intrinsics.checkNotNullParameter((Object)connectionCode, "connectionCode");
        Intrinsics.checkNotNullParameter((Object)streamCode, "streamCode");
        Lockable $this$assertLockNotHeld$iv = this;
        boolean $i$f$assertLockNotHeld = false;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertLockNotHeld$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertLockNotHeld$iv));
        }
        boolean $i$f$ignoreIoExceptions = false;
        try {
            boolean bl = false;
            this.shutdown(connectionCode);
        }
        catch (IOException iOException) {
        }
        Http2Stream[] streamsToClose = null;
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (!this.streams.isEmpty()) {
                Collection<Http2Stream> $this$toTypedArray$iv = this.streams.values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsToClose = thisCollection$iv.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream element$iv;
                Http2Stream stream = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                boolean $i$f$ignoreIoExceptions2 = false;
                try {
                    boolean bl2 = false;
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
        boolean $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl = false;
            this.writer.close();
        }
        catch (IOException iOException) {
        }
        $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl = false;
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    private final void failConnection(IOException e2) {
        this.close$okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, e2);
    }

    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        TaskQueue.execute$default(this.taskRunner.newQueue(), this.connectionName, 0L, false, this.readerRunnable, 6, null);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        http2Connection.start(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Lockable $this$withLock$iv = this.writer;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            Lockable $this$withLock$iv2 = this;
            boolean $i$f$withLock2 = false;
            Lockable lockable2 = $this$withLock$iv2;
            synchronized (lockable2) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
                Unit unit = Unit.INSTANCE;
            }
            this.writer.settings(settings);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isHealthy(long nowNs) {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!this.isShutdown) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.degradedPongsReceived >= this.degradedPingsSent || nowNs < this.degradedPongDeadlineNs) break block6;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendDegradedPingLater$okhttp() {
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + (long)1000000000;
            Unit unit = Unit.INSTANCE;
        }
        TaskQueue.execute$default(this.writerQueue, this.connectionName + " ping", 0L, false, () -> Http2Connection.sendDegradedPingLater$lambda$28(this), 6, null);
    }

    public final boolean pushedStream$okhttp(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushRequestLater$okhttp(int streamId, @NotNull List<Header> requestHeaders) {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        Lockable $this$withLock$iv = this;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            boolean bl2 = this.currentPushRequests.add(streamId);
        }
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onRequest", 0L, false, () -> Http2Connection.pushRequestLater$lambda$32(this, streamId, requestHeaders), 6, null);
    }

    public final void pushHeadersLater$okhttp(int streamId, @NotNull List<Header> requestHeaders, boolean inFinished) {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onHeaders", 0L, false, () -> Http2Connection.pushHeadersLater$lambda$35(this, streamId, requestHeaders, inFinished), 6, null);
    }

    public final void pushDataLater$okhttp(int streamId, @NotNull BufferedSource source2, int byteCount, boolean inFinished) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        Buffer buffer = new Buffer();
        source2.require(byteCount);
        source2.read(buffer, byteCount);
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onData", 0L, false, () -> Http2Connection.pushDataLater$lambda$38(this, streamId, buffer, byteCount, inFinished), 6, null);
    }

    public final void pushResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onReset", 0L, false, () -> Http2Connection.pushResetLater$lambda$40(this, streamId, errorCode), 6, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long _init_$lambda$2(Http2Connection this$0, long $pingIntervalNanos) {
        boolean bl;
        Lockable $this$withLock$iv = this$0;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl2;
            boolean bl3 = false;
            if (this$0.intervalPongsReceived < this$0.intervalPingsSent) {
                bl2 = true;
            } else {
                long l = this$0.intervalPingsSent;
                this$0.intervalPingsSent = l + 1L;
                bl2 = false;
            }
            bl = bl2;
        }
        boolean failDueToMissingPong = bl;
        if (failDueToMissingPong) {
            this$0.failConnection(null);
            return -1L;
        }
        this$0.writePing(false, 1, 0);
        return $pingIntervalNanos;
    }

    private static final Unit writeSynResetLater$lambda$12(Http2Connection this$0, int $streamId, ErrorCode $errorCode) {
        try {
            this$0.writeSynReset$okhttp($streamId, $errorCode);
        }
        catch (IOException e2) {
            this$0.failConnection(e2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeWindowUpdateLater$lambda$13(Http2Connection this$0, int $streamId, long $unacknowledgedBytesRead) {
        try {
            this$0.writer.windowUpdate($streamId, $unacknowledgedBytesRead);
        }
        catch (IOException e2) {
            this$0.failConnection(e2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendDegradedPingLater$lambda$28(Http2Connection this$0) {
        this$0.writePing(false, 2, 0);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushRequestLater$lambda$32(Http2Connection this$0, int $streamId, List $requestHeaders) {
        block5: {
            boolean cancel = this$0.pushObserver.onRequest($streamId, $requestHeaders);
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                if (!cancel) break block5;
                this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushHeadersLater$lambda$35(Http2Connection this$0, int $streamId, List $requestHeaders, boolean $inFinished) {
        block6: {
            boolean cancel = this$0.pushObserver.onHeaders($streamId, $requestHeaders, $inFinished);
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                if (cancel) {
                    this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                }
                if (!cancel && !$inFinished) break block6;
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushDataLater$lambda$38(Http2Connection this$0, int $streamId, Buffer $buffer, int $byteCount, boolean $inFinished) {
        block6: {
            boolean $i$f$ignoreIoExceptions = false;
            try {
                boolean bl = false;
                boolean cancel = this$0.pushObserver.onData($streamId, $buffer, $byteCount, $inFinished);
                if (cancel) {
                    this$0.writer.rstStream($streamId, ErrorCode.CANCEL);
                }
                if (!cancel && !$inFinished) break block6;
                Lockable $this$withLock$iv = this$0;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl2 = false;
                    this$0.currentPushRequests.remove($streamId);
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (IOException iOException) {
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit pushResetLater$lambda$40(Http2Connection this$0, int $streamId, ErrorCode $errorCode) {
        this$0.pushObserver.onReset($streamId, $errorCode);
        Lockable $this$withLock$iv = this$0;
        boolean $i$f$withLock = false;
        Lockable lockable = $this$withLock$iv;
        synchronized (lockable) {
            boolean bl = false;
            this$0.currentPushRequests.remove($streamId);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    static {
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2441 = settings = new Settings();
        boolean bl = false;
        $this$DEFAULT_SETTINGS_u24lambda_u2441.set(4, 65535);
        $this$DEFAULT_SETTINGS_u24lambda_u2441.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010>\u001a\u00020\u00152\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!H\u0007J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u000e\u00108\u001a\u00020\u00002\u0006\u00108\u001a\u000209J\u0006\u0010?\u001a\u00020@R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006A"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "<init>", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "flowControlListener", "Lokhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lokhttp3/internal/http2/FlowControlListener;", "setFlowControlListener$okhttp", "(Lokhttp3/internal/http2/FlowControlListener;)V", "peerName", "build", "Lokhttp3/internal/http2/Http2Connection;", "okhttp"})
    public static final class Builder {
        private boolean client;
        @NotNull
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;
        @NotNull
        private FlowControlListener flowControlListener;

        public Builder(boolean client, @NotNull TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            this.client = client;
            this.taskRunner = taskRunner;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
            this.flowControlListener = FlowControlListener.None.INSTANCE;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final void setClient$okhttp(boolean bl) {
            this.client = bl;
        }

        @NotNull
        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        @NotNull
        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            return null;
        }

        public final void setSocket$okhttp(@NotNull Socket socket) {
            Intrinsics.checkNotNullParameter(socket, "<set-?>");
            this.socket = socket;
        }

        @NotNull
        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("connectionName");
            return null;
        }

        public final void setConnectionName$okhttp(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.connectionName = string;
        }

        @NotNull
        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException("source");
            return null;
        }

        public final void setSource$okhttp(@NotNull BufferedSource bufferedSource) {
            Intrinsics.checkNotNullParameter(bufferedSource, "<set-?>");
            this.source = bufferedSource;
        }

        @NotNull
        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException("sink");
            return null;
        }

        public final void setSink$okhttp(@NotNull BufferedSink bufferedSink) {
            Intrinsics.checkNotNullParameter(bufferedSink, "<set-?>");
            this.sink = bufferedSink;
        }

        @NotNull
        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final void setListener$okhttp(@NotNull Listener listener) {
            Intrinsics.checkNotNullParameter(listener, "<set-?>");
            this.listener = listener;
        }

        @NotNull
        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
            Intrinsics.checkNotNullParameter(pushObserver, "<set-?>");
            this.pushObserver = pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        @NotNull
        public final FlowControlListener getFlowControlListener$okhttp() {
            return this.flowControlListener;
        }

        public final void setFlowControlListener$okhttp(@NotNull FlowControlListener flowControlListener) {
            Intrinsics.checkNotNullParameter(flowControlListener, "<set-?>");
            this.flowControlListener = flowControlListener;
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) throws IOException {
            Builder builder;
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(peerName, "peerName");
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(sink2, "sink");
            Builder $this$socket_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$socket_u24lambda_u240.setSocket$okhttp(socket);
            $this$socket_u24lambda_u240.setConnectionName$okhttp($this$socket_u24lambda_u240.client ? _UtilJvmKt.okHttpName + ' ' + peerName : "MockWebServer " + peerName);
            $this$socket_u24lambda_u240.setSource$okhttp(source2);
            $this$socket_u24lambda_u240.setSink$okhttp(sink2);
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = _UtilJvmKt.peerName(socket);
            }
            if ((n & 4) != 0) {
                bufferedSource = Okio.buffer(Okio.source(socket));
            }
            if ((n & 8) != 0) {
                bufferedSink = Okio.buffer(Okio.sink(socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter(listener, "listener");
            Builder $this$listener_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$listener_u24lambda_u241.listener = listener;
            return builder;
        }

        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            Builder builder;
            Intrinsics.checkNotNullParameter(pushObserver, "pushObserver");
            Builder $this$pushObserver_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$pushObserver_u24lambda_u242.pushObserver = pushObserver;
            return builder;
        }

        @NotNull
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            Builder builder;
            Builder $this$pingIntervalMillis_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$pingIntervalMillis_u24lambda_u243.pingIntervalMillis = pingIntervalMillis;
            return builder;
        }

        @NotNull
        public final Builder flowControlListener(@NotNull FlowControlListener flowControlListener) {
            Builder builder;
            Intrinsics.checkNotNullParameter(flowControlListener, "flowControlListener");
            Builder $this$flowControlListener_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$flowControlListener_u24lambda_u244.flowControlListener = flowControlListener;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source2) throws IOException {
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(peerName, "peerName");
            Intrinsics.checkNotNullParameter(source2, "source");
            return Builder.socket$default(this, socket, peerName, source2, null, 8, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName) throws IOException {
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(peerName, "peerName");
            return Builder.socket$default(this, socket, peerName, null, null, 12, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket) throws IOException {
            Intrinsics.checkNotNullParameter(socket, "socket");
            return Builder.socket$default(this, socket, null, null, null, 14, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "<init>", "()V", "OKHTTP_CLIENT_WINDOW_SIZE", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "INTERVAL_PING", "DEGRADED_PING", "AWAIT_PING", "DEGRADED_PONG_TIMEOUT_NS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "<init>", "()V", "onStream", "", "stream", "Lokhttp3/internal/http2/Http2Stream;", "onSettings", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "Companion", "okhttp"})
    public static abstract class Listener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            public void onStream(Http2Stream stream) throws IOException {
                Intrinsics.checkNotNullParameter(stream, "stream");
                stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        public void onSettings(@NotNull Http2Connection connection, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter(connection, "connection");
            Intrinsics.checkNotNullParameter(settings, "settings");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "<init>", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u0096\u0002J(\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J.\u0010\u0013\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u0003H\u0016J \u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000fH\u0016J \u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J(\u0010+\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\rH\u0016J&\u0010/\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J8\u00102\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u0002042\u0006\u00107\u001a\u00020\u000f2\u0006\u00108\u001a\u00020*H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00069"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "<init>", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "invoke", "data", "inFinished", "", "streamId", "", "source", "Lokio/BufferedSource;", "length", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "rstStream", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "settings", "clearPrevious", "Lokhttp3/internal/http2/Settings;", "applyAndAckSettings", "ackSettings", "ping", "ack", "payload1", "payload2", "goAway", "lastGoodStreamId", "debugData", "Lokio/ByteString;", "windowUpdate", "windowSizeIncrement", "", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "alternateService", "origin", "", "protocol", "host", "port", "maxAge", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 Lockable.kt\nokhttp3/internal/concurrent/LockableKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 -UtilCommon.kt\nokhttp3/internal/_UtilCommonKt\n*L\n1#1,1054:1\n63#2:1055\n63#2:1056\n63#2:1057\n63#2:1062\n63#2:1063\n38#2:1064\n63#2:1065\n63#2:1070\n38#2:1071\n63#2:1072\n37#3:1058\n36#3,3:1059\n37#3:1066\n36#3,3:1067\n228#4,5:1073\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n690#1:1055\n769#1:1056\n770#1:1057\n804#1:1062\n821#1:1063\n831#1:1064\n857#1:1065\n876#1:1070\n878#1:1071\n883#1:1072\n787#1:1058\n787#1:1059,3\n858#1:1066\n858#1:1067,3\n715#1:1073,5\n*E\n"})
    public final class ReaderRunnable
    implements Http2Reader.Handler,
    Function0<Unit> {
        @NotNull
        private final Http2Reader reader;

        public ReaderRunnable(Http2Reader reader) {
            Intrinsics.checkNotNullParameter(reader, "reader");
            this.reader = reader;
        }

        @NotNull
        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e2) {
                errorException = e2;
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                _UtilCommonKt.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, @NotNull BufferedSource source2, int length) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushDataLater$okhttp(streamId, source2, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$okhttp(length);
                source2.skip(length);
                return;
            }
            dataStream.receiveData(source2, length);
            if (inFinished) {
                dataStream.receiveHeaders(Headers.EMPTY, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, @NotNull List<Header> headerBlock) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Stream stream = null;
            Lockable lockable = Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var9_9 = $this$withLock$iv;
            synchronized (var9_9) {
                boolean bl = false;
                stream = http2Connection.getStream(streamId);
                if (stream == null) {
                    if (http2Connection.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers = _UtilJvmKt.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection, false, inFinished, headers);
                    http2Connection.setLastGoodStreamId$okhttp(streamId);
                    Integer n = streamId;
                    http2Connection.getStreams$okhttp().put(n, newStream);
                    TaskQueue.execute$default(http2Connection.taskRunner.newQueue(), http2Connection.getConnectionName$okhttp() + '[' + streamId + "] onStream", 0L, false, () -> ReaderRunnable.headers$lambda$2$lambda$1(http2Connection, newStream), 6, null);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            stream.receiveHeaders(_UtilJvmKt.toHeaders(headerBlock), inFinished);
        }

        @Override
        public void rstStream(int streamId, @NotNull ErrorCode errorCode) {
            block1: {
                Http2Stream rstStream;
                Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
                if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                    Http2Connection.this.pushResetLater$okhttp(streamId, errorCode);
                    return;
                }
                Http2Stream http2Stream = rstStream = Http2Connection.this.removeStream$okhttp(streamId);
                if (http2Stream == null) break block1;
                http2Stream.receiveRstStream(errorCode);
            }
        }

        @Override
        public void settings(boolean clearPrevious, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            TaskQueue.execute$default(Http2Connection.this.writerQueue, Http2Connection.this.getConnectionName$okhttp() + " applyAndAckSettings", 0L, false, () -> ReaderRunnable.settings$lambda$3(this, clearPrevious, settings), 6, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void applyAndAckSettings(boolean clearPrevious, @NotNull Settings settings) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter(settings, "settings");
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray = (Http2Stream[])Http2Connection.this.getWriter();
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var8_10 = $this$withLock$iv;
            synchronized (var8_10) {
                boolean bl = false;
                Lockable $this$withLock$iv2 = http2Connection;
                boolean $i$f$withLock2 = false;
                Lockable lockable = $this$withLock$iv2;
                synchronized (lockable) {
                    Http2Stream[] http2StreamArray2;
                    Settings settings2;
                    boolean bl2 = false;
                    Settings previousPeerSettings = http2Connection.getPeerSettings();
                    Ref.ObjectRef objectRef = newPeerSettings;
                    if (clearPrevious) {
                        settings2 = settings;
                    } else {
                        void $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244;
                        Settings settings3;
                        Settings settings4 = settings3 = new Settings();
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl3 = false;
                        $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(previousPeerSettings);
                        $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(settings);
                        objectRef = objectRef2;
                        settings2 = settings3;
                    }
                    objectRef.element = settings2;
                    long peerInitialWindowSize = ((Settings)newPeerSettings.element).getInitialWindowSize();
                    delta = peerInitialWindowSize - (long)previousPeerSettings.getInitialWindowSize();
                    if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                        http2StreamArray2 = null;
                    } else {
                        Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                        boolean $i$f$toTypedArray = false;
                        Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                        http2StreamArray2 = thisCollection$iv.toArray(new Http2Stream[0]);
                    }
                    streamsToNotify = http2StreamArray2;
                    http2Connection.setPeerSettings((Settings)newPeerSettings.element);
                    TaskQueue.execute$default(http2Connection.settingsListenerQueue, http2Connection.getConnectionName$okhttp() + " onSettings", 0L, false, () -> ReaderRunnable.applyAndAckSettings$lambda$7$lambda$6$lambda$5(http2Connection, newPeerSettings), 6, null);
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    http2Connection.getWriter().applyAndAckSettings((Settings)newPeerSettings.element);
                }
                catch (IOException e2) {
                    http2Connection.failConnection(e2);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (streamsToNotify != null) {
                for (Http2Stream stream : streamsToNotify) {
                    Lockable $this$withLock$iv3 = stream;
                    boolean $i$f$withLock3 = false;
                    Lockable lockable = $this$withLock$iv3;
                    synchronized (lockable) {
                        boolean bl = false;
                        stream.addBytesToWriteWindow(delta);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (ack) {
                void $this$withLock$iv;
                Lockable lockable = Http2Connection.this;
                Http2Connection http2Connection = Http2Connection.this;
                boolean $i$f$withLock = false;
                void var7_7 = $this$withLock$iv;
                synchronized (var7_7) {
                    Object object;
                    boolean bl = false;
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection.intervalPongsReceived;
                            http2Connection.intervalPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 2: {
                            long l = http2Connection.degradedPongsReceived;
                            http2Connection.degradedPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 3: {
                            long l = http2Connection.awaitPongsReceived;
                            http2Connection.awaitPongsReceived = l + 1L;
                            Lockable $this$notifyAll$iv = http2Connection;
                            boolean $i$f$notifyAll = false;
                            Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                            ((Object)$this$notifyAll$iv).notifyAll();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            object = Unit.INSTANCE;
                        }
                    }
                    Unit unit = object;
                }
            } else {
                TaskQueue.execute$default(Http2Connection.this.writerQueue, Http2Connection.this.getConnectionName$okhttp() + " ping", 0L, false, () -> ReaderRunnable.ping$lambda$10(Http2Connection.this, payload1, payload2), 6, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull ByteString debugData) {
            void $this$withLock$iv;
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            Intrinsics.checkNotNullParameter(debugData, "debugData");
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] streamsCopy = null;
            Http2Stream[] http2StreamArray = (Http2Stream[])Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            boolean $i$f$withLock = false;
            void var8_9 = $this$withLock$iv;
            synchronized (var8_9) {
                boolean bl = false;
                Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                streamsCopy = thisCollection$iv.toArray(new Http2Stream[0]);
                http2Connection.isShutdown = true;
                Unit unit = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : streamsCopy) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                void $this$withLock$iv;
                Lockable lockable = Http2Connection.this;
                Http2Connection http2Connection = Http2Connection.this;
                boolean $i$f$withLock = false;
                void var7_9 = $this$withLock$iv;
                synchronized (var7_9) {
                    boolean bl = false;
                    http2Connection.writeBytesMaximum = http2Connection.getWriteBytesMaximum() + windowSizeIncrement;
                    Lockable $this$notifyAll$iv = http2Connection;
                    boolean $i$f$notifyAll = false;
                    Intrinsics.checkNotNull($this$notifyAll$iv, "null cannot be cast to non-null type java.lang.Object");
                    ((Object)$this$notifyAll$iv).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                Lockable $this$withLock$iv = stream;
                boolean $i$f$withLock = false;
                Lockable lockable = $this$withLock$iv;
                synchronized (lockable) {
                    boolean bl = false;
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
            Http2Connection.this.pushRequestLater$okhttp(promisedStreamId, requestHeaders);
        }

        @Override
        public void alternateService(int streamId, @NotNull String origin, @NotNull ByteString protocol, @NotNull String host, int port, long maxAge) {
            Intrinsics.checkNotNullParameter(origin, "origin");
            Intrinsics.checkNotNullParameter(protocol, "protocol");
            Intrinsics.checkNotNullParameter(host, "host");
        }

        private static final Unit headers$lambda$2$lambda$1(Http2Connection this$0, Http2Stream $newStream) {
            try {
                this$0.getListener$okhttp().onStream($newStream);
            }
            catch (IOException e2) {
                Platform.Companion.get().log("Http2Connection.Listener failure for " + this$0.getConnectionName$okhttp(), 4, e2);
                boolean $i$f$ignoreIoExceptions = false;
                try {
                    boolean bl = false;
                    $newStream.close(ErrorCode.PROTOCOL_ERROR, e2);
                }
                catch (IOException iOException) {
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit settings$lambda$3(ReaderRunnable this$0, boolean $clearPrevious, Settings $settings) {
            this$0.applyAndAckSettings($clearPrevious, $settings);
            return Unit.INSTANCE;
        }

        private static final Unit applyAndAckSettings$lambda$7$lambda$6$lambda$5(Http2Connection this$0, Ref.ObjectRef $newPeerSettings) {
            this$0.getListener$okhttp().onSettings(this$0, (Settings)$newPeerSettings.element);
            return Unit.INSTANCE;
        }

        private static final Unit ping$lambda$10(Http2Connection this$0, int $payload1, int $payload2) {
            this$0.writePing(true, $payload1, $payload2);
            return Unit.INSTANCE;
        }
    }
}

