/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.render.shader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ccbluex.liquidbounce.utils.client.ClientUtils;
import net.ccbluex.liquidbounce.utils.client.MinecraftInstance;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H&J\b\u0010\u0013\u001a\u00020\u0010H&J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001d\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0019\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0003R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/ccbluex/liquidbounce/utils/render/shader/Shader;", "Lnet/ccbluex/liquidbounce/utils/client/MinecraftInstance;", "fragmentShader", "", "<init>", "(Ljava/lang/String;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "value", "", "programId", "getProgramId", "()I", "uniformsMap", "", "startShader", "", "stopShader", "setupUniforms", "updateUniforms", "createShader", "shaderSource", "shaderType", "getLogInfo", "kotlin.jvm.PlatformType", "i", "(I)Ljava/lang/String;", "setUniform", "uniformName", "location", "setupUniform", "getUniform", "FDPClient"})
public abstract class Shader
implements MinecraftInstance {
    private int programId;
    @NotNull
    private final Map<String, Integer> uniformsMap;

    public final int getProgramId() {
        return this.programId;
    }

    public Shader(@NotNull String fragmentShader) {
        Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
        this.uniformsMap = new LinkedHashMap();
        int vertexShaderID = 0;
        int fragmentShaderID = 0;
        try {
            InputStream vertexStream = this.getClass().getResourceAsStream("/assets/minecraft/fdpclient/shader/vertex.vert");
            String string = IOUtils.toString((InputStream)vertexStream);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            vertexShaderID = this.createShader(string, 35633);
            IOUtils.closeQuietly((InputStream)vertexStream);
            InputStream fragmentStream = this.getClass().getResourceAsStream("/assets/minecraft/fdpclient/shader/fragment/" + fragmentShader);
            String string2 = IOUtils.toString((InputStream)fragmentStream);
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            fragmentShaderID = this.createShader(string2, 35632);
            IOUtils.closeQuietly((InputStream)fragmentStream);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        if (vertexShaderID == 0 || fragmentShaderID == 0) {
            return;
        }
        this.programId = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.programId == 0) {
            return;
        }
        ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)vertexShaderID);
        ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)fragmentShaderID);
        ARBShaderObjects.glLinkProgramARB((int)this.programId);
        ARBShaderObjects.glValidateProgramARB((int)this.programId);
        ClientUtils.INSTANCE.getLOGGER().info("[Shader] Successfully loaded: " + fragmentShader);
    }

    public Shader(@NotNull File fragmentShader) throws IOException {
        Intrinsics.checkNotNullParameter(fragmentShader, "fragmentShader");
        this.uniformsMap = new LinkedHashMap();
        int vertexShaderID = 0;
        int fragmentShaderID = 0;
        InputStream vertexStream = this.getClass().getResourceAsStream("/assets/minecraft/fdpclient/shader/vertex.vert");
        String string = IOUtils.toString((InputStream)vertexStream);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        vertexShaderID = this.createShader(string, 35633);
        IOUtils.closeQuietly((InputStream)vertexStream);
        InputStream fragmentStream = Files.newInputStream(fragmentShader.toPath(), new OpenOption[0]);
        String string2 = IOUtils.toString((InputStream)fragmentStream);
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        fragmentShaderID = this.createShader(string2, 35632);
        IOUtils.closeQuietly((InputStream)fragmentStream);
        if (vertexShaderID == 0 || fragmentShaderID == 0) {
            return;
        }
        this.programId = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.programId == 0) {
            return;
        }
        ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)vertexShaderID);
        ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)fragmentShaderID);
        ARBShaderObjects.glLinkProgramARB((int)this.programId);
        ARBShaderObjects.glValidateProgramARB((int)this.programId);
        ClientUtils.INSTANCE.getLOGGER().info("[Shader] Successfully loaded: " + fragmentShader.getName());
    }

    public void startShader() {
        GL11.glPushMatrix();
        GL20.glUseProgram((int)this.programId);
        if (this.uniformsMap.isEmpty()) {
            this.setupUniforms();
        }
        this.updateUniforms();
    }

    public void stopShader() {
        GL20.glUseProgram((int)0);
        GL11.glPopMatrix();
    }

    public abstract void setupUniforms();

    public abstract void updateUniforms();

    private final int createShader(String shaderSource, int shaderType) {
        int n;
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)shaderSource);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + this.getLogInfo(shader));
            }
            n = shader;
        }
        catch (Exception e2) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw e2;
        }
        return n;
    }

    private final String getLogInfo(int i) {
        return ARBShaderObjects.glGetInfoLogARB((int)i, (int)ARBShaderObjects.glGetObjectParameteriARB((int)i, (int)35716));
    }

    public final void setUniform(@NotNull String uniformName, int location) {
        Intrinsics.checkNotNullParameter(uniformName, "uniformName");
        Integer n = location;
        this.uniformsMap.put(uniformName, n);
    }

    public final void setupUniform(@NotNull String uniformName) {
        Intrinsics.checkNotNullParameter(uniformName, "uniformName");
        this.setUniform(uniformName, GL20.glGetUniformLocation((int)this.programId, (CharSequence)uniformName));
    }

    public final int getUniform(@NotNull String uniformName) {
        Intrinsics.checkNotNullParameter(uniformName, "uniformName");
        Integer n = this.uniformsMap.get(uniformName);
        Intrinsics.checkNotNull(n);
        return ((Number)n).intValue();
    }

    @Override
    @NotNull
    public Minecraft getMc() {
        return MinecraftInstance.DefaultImpls.getMc(this);
    }
}

