/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.utils.client;

import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.utils.extensions.TextExtensionsKt;
import net.ccbluex.liquidbounce.utils.render.ColorUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u001a\u0010%\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010'\u001a\u00020\u000bJ\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u000bJ\u0010\u0010*\u001a\u00020\u001b2\b\b\u0002\u0010&\u001a\u00020\u000bJ\u0016\u0010+\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bJ\u0016\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u000bR$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001f\u00a8\u0006."}, d2={"Lnet/ccbluex/liquidbounce/utils/client/ClientThemesUtils;", "", "<init>", "()V", "value", "", "ClientColorMode", "getClientColorMode", "()Ljava/lang/String;", "setClientColorMode", "(Ljava/lang/String;)V", "", "ThemeFadeSpeed", "getThemeFadeSpeed", "()I", "setThemeFadeSpeed", "(I)V", "updown", "", "getUpdown", "()Z", "setUpdown", "(Z)V", "BackgroundMode", "getBackgroundMode", "setBackgroundMode", "customBgColor", "Ljava/awt/Color;", "getCustomBgColor", "()Ljava/awt/Color;", "setCustomBgColor", "(Ljava/awt/Color;)V", "neverLoseBgColor", "getNeverLoseBgColor", "setNeverLoseBgColor", "parseHexColor", "hexString", "getBackgroundColor", "index", "alpha", "setColor", "type", "getColor", "getColorWithAlpha", "getColorFromName", "name", "FDPClient"})
public final class ClientThemesUtils {
    @NotNull
    public static final ClientThemesUtils INSTANCE = new ClientThemesUtils();
    @NotNull
    private static String ClientColorMode = "MoonPurple";
    private static int ThemeFadeSpeed = 7;
    private static boolean updown;
    @NotNull
    private static String BackgroundMode;
    @NotNull
    private static Color customBgColor;
    @NotNull
    private static Color neverLoseBgColor;

    private ClientThemesUtils() {
    }

    @NotNull
    public final String getClientColorMode() {
        return ClientColorMode;
    }

    public final void setClientColorMode(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        ClientColorMode = string;
    }

    public final int getThemeFadeSpeed() {
        return ThemeFadeSpeed;
    }

    public final void setThemeFadeSpeed(int value) {
        ThemeFadeSpeed = RangesKt.coerceIn(value, 1, 10);
    }

    public final boolean getUpdown() {
        return updown;
    }

    public final void setUpdown(boolean bl) {
        updown = bl;
    }

    @NotNull
    public final String getBackgroundMode() {
        return BackgroundMode;
    }

    public final void setBackgroundMode(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        BackgroundMode = string;
    }

    @NotNull
    public final Color getCustomBgColor() {
        return customBgColor;
    }

    public final void setCustomBgColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        customBgColor = color;
    }

    @NotNull
    public final Color getNeverLoseBgColor() {
        return neverLoseBgColor;
    }

    public final void setNeverLoseBgColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        neverLoseBgColor = color;
    }

    private final Color parseHexColor(String hexString) {
        Color color;
        String raw = StringsKt.replace$default(hexString, "#", "", false, 4, null);
        try {
            Color color2;
            long colorLong = Long.parseLong(raw, CharsKt.checkRadix(16));
            switch (raw.length()) {
                case 6: {
                    color2 = new Color((int)colorLong & 0xFFFFFF);
                    break;
                }
                case 8: {
                    color2 = new Color((int)(colorLong & 0xFFFFFFFFL), true);
                    break;
                }
                default: {
                    color2 = new Color(-1);
                }
            }
            color = color2;
        }
        catch (NumberFormatException e2) {
            color = new Color(-1);
        }
        return color;
    }

    @NotNull
    public final Color getBackgroundColor(int index, int alpha) {
        Color color;
        String string = BackgroundMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String m = string;
        if (StringsKt.startsWith$default(m, "#", false, 2, null)) {
            return TextExtensionsKt.setAlpha(this.parseHexColor(m), alpha);
        }
        switch (m) {
            case "dark": {
                color = new Color(21, 21, 21, alpha);
                break;
            }
            case "synced": {
                Color color2 = this.getColorWithAlpha(index, alpha).darker().darker();
                color = color2;
                Intrinsics.checkNotNullExpressionValue(color2, "darker(...)");
                break;
            }
            case "custom": {
                color = TextExtensionsKt.setAlpha(customBgColor, alpha);
                break;
            }
            case "neverlose": {
                color = TextExtensionsKt.setAlpha(neverLoseBgColor, alpha);
                break;
            }
            case "none": {
                color = new Color(0, 0, 0, 0);
                break;
            }
            default: {
                color = new Color(21, 21, 21, alpha);
            }
        }
        return color;
    }

    public static /* synthetic */ Color getBackgroundColor$default(ClientThemesUtils clientThemesUtils, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 255;
        }
        return clientThemesUtils.getBackgroundColor(n, n2);
    }

    @NotNull
    public final Color setColor(@NotNull String type, int alpha) {
        Color color;
        Intrinsics.checkNotNullParameter(type, "type");
        String string = ClientColorMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String mode = string;
        if (StringsKt.startsWith$default(mode, "#", false, 2, null)) {
            return TextExtensionsKt.setAlpha(this.parseHexColor(mode), alpha);
        }
        switch (mode) {
            case "zywl": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(215, 171, 168, alpha);
                    break;
                }
                color = new Color(206, 58, 98, alpha);
                break;
            }
            case "water": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(108, 170, 207, alpha);
                    break;
                }
                color = new Color(35, 69, 148, alpha);
                break;
            }
            case "magic": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 180, 255, alpha);
                    break;
                }
                color = new Color(192, 67, 255, alpha);
                break;
            }
            case "darknight": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(203, 200, 204, alpha);
                    break;
                }
                color = new Color(93, 95, 95, alpha);
                break;
            }
            case "sun": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(252, 205, 44, alpha);
                    break;
                }
                color = new Color(255, 143, 0, alpha);
                break;
            }
            case "flower": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(182, 140, 195, alpha);
                    break;
                }
                color = new Color(184, 85, 199, alpha);
                break;
            }
            case "tree": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(76, 255, 102, alpha);
                    break;
                }
                color = new Color(18, 155, 38, alpha);
                break;
            }
            case "loyoi": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 131, 124, alpha);
                    break;
                }
                color = new Color(255, 131, 0, alpha);
                break;
            }
            case "fdp": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(100, 255, 255, alpha);
                    break;
                }
                color = new Color(255, 100, 255, alpha);
                break;
            }
            case "may": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 255, 255, alpha);
                    break;
                }
                color = new Color(255, 80, 255, alpha);
                break;
            }
            case "mint": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(85, 255, 255, alpha);
                    break;
                }
                color = new Color(85, 255, 140, alpha);
                break;
            }
            case "cero": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(170, 255, 170, alpha);
                    break;
                }
                color = new Color(170, 0, 170, alpha);
                break;
            }
            case "azure": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(0, 180, 255, alpha);
                    break;
                }
                color = new Color(0, 90, 255, alpha);
                break;
            }
            case "pumpkin": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(241, 166, 98, alpha);
                    break;
                }
                color = new Color(255, 216, 169, alpha);
                break;
            }
            case "polarized": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(173, 239, 209, alpha);
                    break;
                }
                color = new Color(0, 32, 64, alpha);
                break;
            }
            case "sundae": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(206, 74, 126, alpha);
                    break;
                }
                color = new Color(28, 28, 27, alpha);
                break;
            }
            case "terminal": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(15, 155, 15, alpha);
                    break;
                }
                color = new Color(25, 30, 25, alpha);
                break;
            }
            case "coral": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(244, 168, 150, alpha);
                    break;
                }
                color = new Color(52, 133, 151, alpha);
                break;
            }
            case "fire": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 45, 30, alpha);
                    break;
                }
                color = new Color(255, 123, 15, alpha);
                break;
            }
            case "aqua": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(80, 255, 255, alpha);
                    break;
                }
                color = new Color(80, 190, 255, alpha);
                break;
            }
            case "peony": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 120, 255, alpha);
                    break;
                }
                color = new Color(255, 190, 255, alpha);
                break;
            }
            case "vergren": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(170, 255, 169, alpha);
                    break;
                }
                color = new Color(17, 255, 189, alpha);
                break;
            }
            case "eveningsunshine": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(185, 43, 39, alpha);
                    break;
                }
                color = new Color(21, 101, 192, alpha);
                break;
            }
            case "lightorange": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(255, 183, 94, alpha);
                    break;
                }
                color = new Color(237, 143, 3, alpha);
                break;
            }
            case "reef": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(0, 210, 255, alpha);
                    break;
                }
                color = new Color(58, 123, 213, alpha);
                break;
            }
            case "amin": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(142, 45, 226, alpha);
                    break;
                }
                color = new Color(74, 0, 224, alpha);
                break;
            }
            case "magics": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(89, 193, 115, alpha);
                    break;
                }
                color = new Color(93, 38, 193, alpha);
                break;
            }
            case "mangopulp": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(240, 152, 25, alpha);
                    break;
                }
                color = new Color(237, 222, 93, alpha);
                break;
            }
            case "moonpurple": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(78, 84, 200, alpha);
                    break;
                }
                color = new Color(143, 148, 251, alpha);
                break;
            }
            case "aqualicious": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(80, 201, 195, alpha);
                    break;
                }
                color = new Color(150, 222, 218, alpha);
                break;
            }
            case "stripe": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(31, 162, 255, alpha);
                    break;
                }
                color = new Color(166, 255, 203, alpha);
                break;
            }
            case "shifter": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(188, 78, 156, alpha);
                    break;
                }
                color = new Color(248, 7, 89, alpha);
                break;
            }
            case "quepal": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(17, 153, 142, alpha);
                    break;
                }
                color = new Color(56, 239, 125, alpha);
                break;
            }
            case "orca": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(68, 160, 141, alpha);
                    break;
                }
                color = new Color(9, 54, 55, alpha);
                break;
            }
            case "sublimevivid": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(252, 70, 107, alpha);
                    break;
                }
                color = new Color(63, 94, 251, alpha);
                break;
            }
            case "moonasteroid": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(15, 32, 39, alpha);
                    break;
                }
                color = new Color(44, 83, 100, alpha);
                break;
            }
            case "summerdog": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(168, 255, 120, alpha);
                    break;
                }
                color = new Color(120, 255, 214, alpha);
                break;
            }
            case "pinkflavour": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(128, 0, 128, alpha);
                    break;
                }
                color = new Color(255, 192, 203, alpha);
                break;
            }
            case "sincityred": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(237, 33, 58, alpha);
                    break;
                }
                color = new Color(147, 41, 30, alpha);
                break;
            }
            case "timber": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(252, 0, 255, alpha);
                    break;
                }
                color = new Color(0, 219, 222, alpha);
                break;
            }
            case "pinotnoir": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(75, 108, 183, alpha);
                    break;
                }
                color = new Color(24, 40, 72, alpha);
                break;
            }
            case "dirtyfog": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(185, 147, 214, alpha);
                    break;
                }
                color = new Color(140, 166, 219, alpha);
                break;
            }
            case "piglet": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(238, 156, 167, alpha);
                    break;
                }
                color = new Color(255, 221, 225, alpha);
                break;
            }
            case "littleleaf": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(118, 184, 82, alpha);
                    break;
                }
                color = new Color(141, 194, 111, alpha);
                break;
            }
            case "nelson": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(242, 112, 156, alpha);
                    break;
                }
                color = new Color(255, 148, 114, alpha);
                break;
            }
            case "turquoiseflow": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(19, 106, 138, alpha);
                    break;
                }
                color = new Color(38, 120, 113, alpha);
                break;
            }
            case "purplin": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(106, 48, 147, alpha);
                    break;
                }
                color = new Color(160, 68, 255, alpha);
                break;
            }
            case "martini": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(253, 252, 71, alpha);
                    break;
                }
                color = new Color(36, 254, 65, alpha);
                break;
            }
            case "soundcloud": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(254, 140, 0, alpha);
                    break;
                }
                color = new Color(248, 54, 0, alpha);
                break;
            }
            case "inbox": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(69, 127, 202, alpha);
                    break;
                }
                color = new Color(86, 145, 200, alpha);
                break;
            }
            case "amethyst": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(157, 80, 187, alpha);
                    break;
                }
                color = new Color(110, 72, 170, alpha);
                break;
            }
            case "blush": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(178, 69, 146, alpha);
                    break;
                }
                color = new Color(241, 95, 121, alpha);
                break;
            }
            case "mocharose": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = new Color(245, 194, 231, alpha);
                    break;
                }
                color = new Color(243, 139, 168, alpha);
                break;
            }
            case "astolfo": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(0, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                    break;
                }
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(90, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                break;
            }
            case "rainbow": {
                if (Intrinsics.areEqual(type, "start")) {
                    color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(0, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                    break;
                }
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(90, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                break;
            }
            default: {
                color = new Color(-1);
            }
        }
        return color;
    }

    @NotNull
    public final Color getColor(int index) {
        String string = ClientColorMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String mode = string;
        double fadeVal = (double)ThemeFadeSpeed / 5.0 * (double)(updown ? 1 : -1);
        if (StringsKt.startsWith$default(mode, "#", false, 2, null)) {
            return this.parseHexColor(mode);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("zywl", new Pair<Color, Color>(new Color(206, 58, 98), new Color(215, 171, 168))), TuplesKt.to("water", new Pair<Color, Color>(new Color(35, 69, 148), new Color(108, 170, 207))), TuplesKt.to("magic", new Pair<Color, Color>(new Color(255, 180, 255), new Color(181, 139, 194))), TuplesKt.to("tree", new Pair<Color, Color>(new Color(18, 155, 38), new Color(76, 255, 102))), TuplesKt.to("darknight", new Pair<Color, Color>(new Color(93, 95, 95), new Color(203, 200, 204))), TuplesKt.to("sun", new Pair<Color, Color>(new Color(255, 143, 0), new Color(252, 205, 44))), TuplesKt.to("flower", new Pair<Color, Color>(new Color(184, 85, 199), new Color(182, 140, 195))), TuplesKt.to("loyoi", new Pair<Color, Color>(new Color(255, 131, 0), new Color(255, 131, 124))), TuplesKt.to("fdp", new Pair<Color, Color>(new Color(255, 100, 255), new Color(100, 255, 255))), TuplesKt.to("may", new Pair<Color, Color>(new Color(255, 80, 255), new Color(255, 255, 255))), TuplesKt.to("mint", new Pair<Color, Color>(new Color(85, 255, 140), new Color(85, 255, 255))), TuplesKt.to("cero", new Pair<Color, Color>(new Color(170, 0, 170), new Color(170, 255, 170))), TuplesKt.to("azure", new Pair<Color, Color>(new Color(0, 90, 255), new Color(0, 180, 255))), TuplesKt.to("pumpkin", new Pair<Color, Color>(new Color(255, 216, 169), new Color(241, 166, 98))), TuplesKt.to("polarized", new Pair<Color, Color>(new Color(0, 32, 64), new Color(173, 239, 209))), TuplesKt.to("sundae", new Pair<Color, Color>(new Color(28, 28, 27), new Color(206, 74, 126))), TuplesKt.to("terminal", new Pair<Color, Color>(new Color(25, 30, 25), new Color(15, 155, 15))), TuplesKt.to("coral", new Pair<Color, Color>(new Color(52, 133, 151), new Color(244, 168, 150))), TuplesKt.to("fire", new Pair<Color, Color>(new Color(255, 45, 30), new Color(255, 123, 15))), TuplesKt.to("aqua", new Pair<Color, Color>(new Color(80, 255, 255), new Color(80, 190, 255))), TuplesKt.to("peony", new Pair<Color, Color>(new Color(255, 120, 255), new Color(255, 190, 255))), TuplesKt.to("vergren", new Pair<Color, Color>(new Color(170, 255, 169), new Color(17, 255, 189))), TuplesKt.to("eveningsunshine", new Pair<Color, Color>(new Color(185, 43, 39), new Color(21, 101, 192))), TuplesKt.to("lightorange", new Pair<Color, Color>(new Color(255, 183, 94), new Color(237, 143, 3))), TuplesKt.to("reef", new Pair<Color, Color>(new Color(0, 210, 255), new Color(58, 123, 213))), TuplesKt.to("amin", new Pair<Color, Color>(new Color(142, 45, 226), new Color(74, 0, 224))), TuplesKt.to("magics", new Pair<Color, Color>(new Color(89, 193, 115), new Color(93, 38, 193))), TuplesKt.to("mangopulp", new Pair<Color, Color>(new Color(240, 152, 25), new Color(237, 222, 93))), TuplesKt.to("moonpurple", new Pair<Color, Color>(new Color(78, 84, 200), new Color(143, 148, 251))), TuplesKt.to("aqualicious", new Pair<Color, Color>(new Color(80, 201, 195), new Color(150, 222, 218))), TuplesKt.to("stripe", new Pair<Color, Color>(new Color(31, 162, 255), new Color(166, 255, 203))), TuplesKt.to("shifter", new Pair<Color, Color>(new Color(188, 78, 156), new Color(248, 7, 89))), TuplesKt.to("quepal", new Pair<Color, Color>(new Color(17, 153, 142), new Color(56, 239, 125))), TuplesKt.to("orca", new Pair<Color, Color>(new Color(68, 160, 141), new Color(9, 54, 55))), TuplesKt.to("sublimevivid", new Pair<Color, Color>(new Color(252, 70, 107), new Color(63, 94, 251))), TuplesKt.to("moonasteroid", new Pair<Color, Color>(new Color(15, 32, 39), new Color(44, 83, 100))), TuplesKt.to("summerdog", new Pair<Color, Color>(new Color(168, 255, 120), new Color(120, 255, 214))), TuplesKt.to("pinkflavour", new Pair<Color, Color>(new Color(128, 0, 128), new Color(255, 192, 203))), TuplesKt.to("sincityred", new Pair<Color, Color>(new Color(237, 33, 58), new Color(147, 41, 30))), TuplesKt.to("timber", new Pair<Color, Color>(new Color(252, 0, 255), new Color(0, 219, 222))), TuplesKt.to("pinotnoir", new Pair<Color, Color>(new Color(75, 108, 183), new Color(24, 40, 72))), TuplesKt.to("dirtyfog", new Pair<Color, Color>(new Color(185, 147, 214), new Color(140, 166, 219))), TuplesKt.to("piglet", new Pair<Color, Color>(new Color(238, 156, 167), new Color(255, 221, 225))), TuplesKt.to("littleleaf", new Pair<Color, Color>(new Color(118, 184, 82), new Color(141, 194, 111))), TuplesKt.to("nelson", new Pair<Color, Color>(new Color(242, 112, 156), new Color(255, 148, 114))), TuplesKt.to("turquoiseflow", new Pair<Color, Color>(new Color(19, 106, 138), new Color(38, 120, 113))), TuplesKt.to("purplin", new Pair<Color, Color>(new Color(106, 48, 147), new Color(160, 68, 255))), TuplesKt.to("martini", new Pair<Color, Color>(new Color(253, 252, 71), new Color(36, 254, 65))), TuplesKt.to("soundcloud", new Pair<Color, Color>(new Color(254, 140, 0), new Color(248, 54, 0))), TuplesKt.to("inbox", new Pair<Color, Color>(new Color(69, 127, 202), new Color(86, 145, 200))), TuplesKt.to("amethyst", new Pair<Color, Color>(new Color(157, 80, 187), new Color(110, 72, 170))), TuplesKt.to("blush", new Pair<Color, Color>(new Color(178, 69, 146), new Color(241, 95, 121))), TuplesKt.to("mocharose", new Pair<Color, Color>(new Color(245, 194, 231), new Color(243, 139, 168))), TuplesKt.to("astolfo", new Pair<Color, Color>(ColorUtils.INSTANCE.skyRainbow(0, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), ColorUtils.INSTANCE.skyRainbow(90, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed))), TuplesKt.to("rainbow", new Pair<Color, Color>(ColorUtils.INSTANCE.skyRainbow(0, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), ColorUtils.INSTANCE.skyRainbow(90, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed)))};
        Map colorMap = MapsKt.mapOf(pairArray);
        Pair pair = (Pair)colorMap.get(mode);
        if (pair == null) {
            return new Color(-1);
        }
        Pair colorPair = pair;
        return ColorUtils.INSTANCE.mixColors((Color)colorPair.getFirst(), (Color)colorPair.getSecond(), fadeVal, index);
    }

    public static /* synthetic */ Color getColor$default(ClientThemesUtils clientThemesUtils, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return clientThemesUtils.getColor(n);
    }

    @NotNull
    public final Color getColorWithAlpha(int index, int alpha) {
        Color color;
        String string = ClientColorMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String mode = string;
        double fadeSpeed = (double)ThemeFadeSpeed / 5.0 * (double)(updown ? 1 : -1);
        if (StringsKt.startsWith$default(mode, "#", false, 2, null)) {
            return TextExtensionsKt.setAlpha(this.parseHexColor(mode), alpha);
        }
        switch (mode) {
            case "zywl": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(206, 58, 98), new Color(215, 171, 168), fadeSpeed, index), alpha);
                break;
            }
            case "water": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(35, 69, 148), new Color(108, 170, 207), fadeSpeed, index), alpha);
                break;
            }
            case "magic": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 180, 255), new Color(181, 139, 194), fadeSpeed, index), alpha);
                break;
            }
            case "tree": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(18, 155, 38), new Color(76, 255, 102), fadeSpeed, index), alpha);
                break;
            }
            case "darknight": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(93, 95, 95), new Color(203, 200, 204), fadeSpeed, index), alpha);
                break;
            }
            case "sun": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 143, 0), new Color(252, 205, 44), fadeSpeed, index), alpha);
                break;
            }
            case "flower": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(184, 85, 199), new Color(182, 140, 195), fadeSpeed, index), alpha);
                break;
            }
            case "loyoi": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 131, 0), new Color(255, 131, 124), fadeSpeed, index), alpha);
                break;
            }
            case "fdp": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 100, 255), new Color(100, 255, 255), fadeSpeed, index), alpha);
                break;
            }
            case "may": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 80, 255), new Color(255, 255, 255), fadeSpeed, index), alpha);
                break;
            }
            case "mint": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(85, 255, 180), new Color(85, 255, 255), fadeSpeed, index), alpha);
                break;
            }
            case "cero": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(170, 0, 170), new Color(170, 255, 170), fadeSpeed, index), alpha);
                break;
            }
            case "azure": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(0, 90, 255), new Color(0, 180, 255), fadeSpeed, index), alpha);
                break;
            }
            case "pumpkin": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 216, 169), new Color(241, 166, 98), fadeSpeed, index), alpha);
                break;
            }
            case "polarized": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(0, 32, 64), new Color(173, 239, 209), fadeSpeed, index), alpha);
                break;
            }
            case "sundae": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(28, 28, 27), new Color(206, 74, 126), fadeSpeed, index), alpha);
                break;
            }
            case "terminal": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(25, 30, 25), new Color(15, 155, 15), fadeSpeed, index), alpha);
                break;
            }
            case "coral": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(52, 133, 151), new Color(244, 168, 150), fadeSpeed, index), alpha);
                break;
            }
            case "fire": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 45, 30), new Color(255, 123, 15), fadeSpeed, index), alpha);
                break;
            }
            case "aqua": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(80, 255, 255), new Color(80, 190, 255), fadeSpeed, index), alpha);
                break;
            }
            case "peony": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 120, 255), new Color(255, 190, 255), fadeSpeed, index), alpha);
                break;
            }
            case "vergren": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(170, 255, 169), new Color(17, 255, 189), fadeSpeed, index), alpha);
                break;
            }
            case "eveningsunshine": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(185, 43, 39), new Color(21, 101, 192), fadeSpeed, index), alpha);
                break;
            }
            case "lightorange": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(255, 183, 94), new Color(237, 143, 3), fadeSpeed, index), alpha);
                break;
            }
            case "reef": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(0, 210, 255), new Color(58, 123, 213), fadeSpeed, index), alpha);
                break;
            }
            case "amin": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(142, 45, 226), new Color(74, 0, 224), fadeSpeed, index), alpha);
                break;
            }
            case "magics": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(89, 193, 115), new Color(93, 38, 193), fadeSpeed, index), alpha);
                break;
            }
            case "mangopulp": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(240, 152, 25), new Color(237, 222, 93), fadeSpeed, index), alpha);
                break;
            }
            case "moonpurple": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(78, 84, 200), new Color(143, 148, 251), fadeSpeed, index), alpha);
                break;
            }
            case "aqualicious": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(80, 201, 195), new Color(150, 222, 218), fadeSpeed, index), alpha);
                break;
            }
            case "stripe": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(31, 162, 255), new Color(166, 255, 203), fadeSpeed, index), alpha);
                break;
            }
            case "shifter": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(188, 78, 156), new Color(248, 7, 89), fadeSpeed, index), alpha);
                break;
            }
            case "quepal": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(17, 153, 142), new Color(56, 239, 125), fadeSpeed, index), alpha);
                break;
            }
            case "orca": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(68, 160, 141), new Color(9, 54, 55), fadeSpeed, index), alpha);
                break;
            }
            case "sublimevivid": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(252, 70, 107), new Color(63, 94, 251), fadeSpeed, index), alpha);
                break;
            }
            case "moonasteroid": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(15, 32, 39), new Color(44, 83, 100), fadeSpeed, index), alpha);
                break;
            }
            case "summerdog": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(168, 255, 120), new Color(120, 255, 214), fadeSpeed, index), alpha);
                break;
            }
            case "pinkflavour": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(128, 0, 128), new Color(255, 192, 203), fadeSpeed, index), alpha);
                break;
            }
            case "sincityred": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(237, 33, 58), new Color(147, 41, 30), fadeSpeed, index), alpha);
                break;
            }
            case "timber": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(252, 0, 255), new Color(0, 219, 222), fadeSpeed, index), alpha);
                break;
            }
            case "pinotnoir": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(75, 108, 183), new Color(24, 40, 72), fadeSpeed, index), alpha);
                break;
            }
            case "dirtyfog": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(185, 147, 214), new Color(140, 166, 219), fadeSpeed, index), alpha);
                break;
            }
            case "piglet": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(238, 156, 167), new Color(255, 221, 225), fadeSpeed, index), alpha);
                break;
            }
            case "littleleaf": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(118, 184, 82), new Color(141, 194, 111), fadeSpeed, index), alpha);
                break;
            }
            case "nelson": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(242, 112, 156), new Color(255, 148, 114), fadeSpeed, index), alpha);
                break;
            }
            case "turquoiseflow": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(19, 106, 138), new Color(38, 120, 113), fadeSpeed, index), alpha);
                break;
            }
            case "purplin": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(106, 48, 147), new Color(160, 68, 255), fadeSpeed, index), alpha);
                break;
            }
            case "martini": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(253, 252, 71), new Color(36, 254, 65), fadeSpeed, index), alpha);
                break;
            }
            case "soundcloud": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(254, 140, 0), new Color(248, 54, 0), fadeSpeed, index), alpha);
                break;
            }
            case "inbox": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(69, 127, 202), new Color(86, 145, 200), fadeSpeed, index), alpha);
                break;
            }
            case "amethyst": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(157, 80, 187), new Color(110, 72, 170), fadeSpeed, index), alpha);
                break;
            }
            case "blush": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(178, 69, 146), new Color(241, 95, 121), fadeSpeed, index), alpha);
                break;
            }
            case "mocharose": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.mixColors(new Color(245, 194, 231), new Color(243, 139, 168), fadeSpeed, index), alpha);
                break;
            }
            case "rainbow": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(0, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                break;
            }
            case "astolfo": {
                color = TextExtensionsKt.setAlpha(ColorUtils.INSTANCE.skyRainbow(0, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), alpha);
                break;
            }
            default: {
                color = new Color(-1);
            }
        }
        return color;
    }

    @NotNull
    public final Color getColorFromName(@NotNull String name, int index) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (StringsKt.startsWith$default(name, "#", false, 2, null)) {
            return this.parseHexColor(name);
        }
        double fadeVal = (double)ThemeFadeSpeed / 5.0 * (double)(updown ? 1 : -1);
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String lower = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to("zywl", new Pair<Color, Color>(new Color(206, 58, 98), new Color(215, 171, 168))), TuplesKt.to("water", new Pair<Color, Color>(new Color(35, 69, 148), new Color(108, 170, 207))), TuplesKt.to("magic", new Pair<Color, Color>(new Color(255, 180, 255), new Color(181, 139, 194))), TuplesKt.to("tree", new Pair<Color, Color>(new Color(18, 155, 38), new Color(76, 255, 102))), TuplesKt.to("darknight", new Pair<Color, Color>(new Color(93, 95, 95), new Color(203, 200, 204))), TuplesKt.to("sun", new Pair<Color, Color>(new Color(255, 143, 0), new Color(252, 205, 44))), TuplesKt.to("flower", new Pair<Color, Color>(new Color(184, 85, 199), new Color(182, 140, 195))), TuplesKt.to("loyoi", new Pair<Color, Color>(new Color(255, 131, 0), new Color(255, 131, 124))), TuplesKt.to("fdp", new Pair<Color, Color>(new Color(255, 100, 255), new Color(100, 255, 255))), TuplesKt.to("may", new Pair<Color, Color>(new Color(255, 80, 255), new Color(255, 255, 255))), TuplesKt.to("mint", new Pair<Color, Color>(new Color(85, 255, 140), new Color(85, 255, 255))), TuplesKt.to("cero", new Pair<Color, Color>(new Color(170, 0, 170), new Color(170, 255, 170))), TuplesKt.to("azure", new Pair<Color, Color>(new Color(0, 90, 255), new Color(0, 180, 255))), TuplesKt.to("pumpkin", new Pair<Color, Color>(new Color(255, 216, 169), new Color(241, 166, 98))), TuplesKt.to("polarized", new Pair<Color, Color>(new Color(0, 32, 64), new Color(173, 239, 209))), TuplesKt.to("sundae", new Pair<Color, Color>(new Color(28, 28, 27), new Color(206, 74, 126))), TuplesKt.to("terminal", new Pair<Color, Color>(new Color(25, 30, 25), new Color(15, 155, 15))), TuplesKt.to("coral", new Pair<Color, Color>(new Color(52, 133, 151), new Color(244, 168, 150))), TuplesKt.to("fire", new Pair<Color, Color>(new Color(255, 45, 30), new Color(255, 123, 15))), TuplesKt.to("aqua", new Pair<Color, Color>(new Color(80, 255, 255), new Color(80, 190, 255))), TuplesKt.to("peony", new Pair<Color, Color>(new Color(255, 120, 255), new Color(255, 190, 255))), TuplesKt.to("vergren", new Pair<Color, Color>(new Color(170, 255, 169), new Color(17, 255, 189))), TuplesKt.to("eveningsunshine", new Pair<Color, Color>(new Color(185, 43, 39), new Color(21, 101, 192))), TuplesKt.to("lightorange", new Pair<Color, Color>(new Color(255, 183, 94), new Color(237, 143, 3))), TuplesKt.to("reef", new Pair<Color, Color>(new Color(0, 210, 255), new Color(58, 123, 213))), TuplesKt.to("amin", new Pair<Color, Color>(new Color(142, 45, 226), new Color(74, 0, 224))), TuplesKt.to("magics", new Pair<Color, Color>(new Color(89, 193, 115), new Color(93, 38, 193))), TuplesKt.to("mangopulp", new Pair<Color, Color>(new Color(240, 152, 25), new Color(237, 222, 93))), TuplesKt.to("moonpurple", new Pair<Color, Color>(new Color(78, 84, 200), new Color(143, 148, 251))), TuplesKt.to("aqualicious", new Pair<Color, Color>(new Color(80, 201, 195), new Color(150, 222, 218))), TuplesKt.to("stripe", new Pair<Color, Color>(new Color(31, 162, 255), new Color(166, 255, 203))), TuplesKt.to("shifter", new Pair<Color, Color>(new Color(188, 78, 156), new Color(248, 7, 89))), TuplesKt.to("quepal", new Pair<Color, Color>(new Color(17, 153, 142), new Color(56, 239, 125))), TuplesKt.to("orca", new Pair<Color, Color>(new Color(68, 160, 141), new Color(9, 54, 55))), TuplesKt.to("sublimevivid", new Pair<Color, Color>(new Color(252, 70, 107), new Color(63, 94, 251))), TuplesKt.to("moonasteroid", new Pair<Color, Color>(new Color(15, 32, 39), new Color(44, 83, 100))), TuplesKt.to("summerdog", new Pair<Color, Color>(new Color(168, 255, 120), new Color(120, 255, 214))), TuplesKt.to("pinkflavour", new Pair<Color, Color>(new Color(128, 0, 128), new Color(255, 192, 203))), TuplesKt.to("sincityred", new Pair<Color, Color>(new Color(237, 33, 58), new Color(147, 41, 30))), TuplesKt.to("timber", new Pair<Color, Color>(new Color(252, 0, 255), new Color(0, 219, 222))), TuplesKt.to("pinotnoir", new Pair<Color, Color>(new Color(75, 108, 183), new Color(24, 40, 72))), TuplesKt.to("dirtyfog", new Pair<Color, Color>(new Color(185, 147, 214), new Color(140, 166, 219))), TuplesKt.to("piglet", new Pair<Color, Color>(new Color(238, 156, 167), new Color(255, 221, 225))), TuplesKt.to("littleleaf", new Pair<Color, Color>(new Color(118, 184, 82), new Color(141, 194, 111))), TuplesKt.to("nelson", new Pair<Color, Color>(new Color(242, 112, 156), new Color(255, 148, 114))), TuplesKt.to("turquoiseflow", new Pair<Color, Color>(new Color(19, 106, 138), new Color(38, 120, 113))), TuplesKt.to("purplin", new Pair<Color, Color>(new Color(106, 48, 147), new Color(160, 68, 255))), TuplesKt.to("martini", new Pair<Color, Color>(new Color(253, 252, 71), new Color(36, 254, 65))), TuplesKt.to("soundcloud", new Pair<Color, Color>(new Color(254, 140, 0), new Color(248, 54, 0))), TuplesKt.to("inbox", new Pair<Color, Color>(new Color(69, 127, 202), new Color(86, 145, 200))), TuplesKt.to("amethyst", new Pair<Color, Color>(new Color(157, 80, 187), new Color(110, 72, 170))), TuplesKt.to("blush", new Pair<Color, Color>(new Color(178, 69, 146), new Color(241, 95, 121))), TuplesKt.to("mocharose", new Pair<Color, Color>(new Color(245, 194, 231), new Color(243, 139, 168))), TuplesKt.to("astolfo", new Pair<Color, Color>(ColorUtils.INSTANCE.skyRainbow(0, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), ColorUtils.INSTANCE.skyRainbow(90, 0.6f, 1.0f, 20000.0f / (float)ThemeFadeSpeed))), TuplesKt.to("rainbow", new Pair<Color, Color>(ColorUtils.INSTANCE.skyRainbow(0, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed), ColorUtils.INSTANCE.skyRainbow(90, 1.0f, 1.0f, 20000.0f / (float)ThemeFadeSpeed)))};
        Map colorMap = MapsKt.mapOf(pairArray);
        Pair pair = (Pair)colorMap.get(lower);
        if (pair == null) {
            return new Color(-1);
        }
        Pair pair2 = pair;
        return ColorUtils.INSTANCE.mixColors((Color)pair2.getFirst(), (Color)pair2.getSecond(), fadeVal, index);
    }

    static {
        BackgroundMode = "Synced";
        customBgColor = new Color(32, 32, 64);
        neverLoseBgColor = new Color(60, 60, 60);
    }
}

