/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.ui.client.hud.element.elements;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.ccbluex.liquidbounce.config.BoolValue;
import net.ccbluex.liquidbounce.config.ColorValue;
import net.ccbluex.liquidbounce.config.Configurable;
import net.ccbluex.liquidbounce.config.FloatValue;
import net.ccbluex.liquidbounce.config.Value;
import net.ccbluex.liquidbounce.ui.client.hud.element.Border;
import net.ccbluex.liquidbounce.ui.client.hud.element.Element;
import net.ccbluex.liquidbounce.ui.client.hud.element.ElementInfo;
import net.ccbluex.liquidbounce.utils.client.ClientUtils;
import net.ccbluex.liquidbounce.utils.io.FileFilters;
import net.ccbluex.liquidbounce.utils.io.MiscUtils;
import net.ccbluex.liquidbounce.utils.kotlin.RandomUtils;
import net.ccbluex.liquidbounce.utils.render.ColorUtils;
import net.ccbluex.liquidbounce.utils.render.RenderUtils;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;

@ElementInfo(name="Image")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020+R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0017\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\t\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lnet/ccbluex/liquidbounce/ui/client/hud/element/elements/Image;", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/Element;", "<init>", "()V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "color$delegate", "Lnet/ccbluex/liquidbounce/config/ColorValue;", "shadow", "", "getShadow", "()Z", "shadow$delegate", "Lnet/ccbluex/liquidbounce/config/BoolValue;", "xDistance", "", "getXDistance", "()F", "xDistance$delegate", "Lnet/ccbluex/liquidbounce/config/FloatValue;", "yDistance", "getYDistance", "yDistance$delegate", "shadowColor", "getShadowColor", "shadowColor$delegate", "image", "Lnet/ccbluex/liquidbounce/config/Value;", "", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "width", "", "height", "drawElement", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/Border;", "createElement", "setImage", "b64image", "Ljava/io/File;", "saveImage", "", "Companion", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Image.kt\nnet/ccbluex/liquidbounce/ui/client/hud/element/elements/Image\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class Image
extends Element {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ColorValue color$delegate;
    @NotNull
    private final BoolValue shadow$delegate;
    @NotNull
    private final FloatValue xDistance$delegate;
    @NotNull
    private final FloatValue yDistance$delegate;
    @NotNull
    private final ColorValue shadowColor$delegate;
    @NotNull
    private final Value<String> image;
    @NotNull
    private final ResourceLocation resourceLocation;
    private int width;
    private int height;

    public Image() {
        super("Image", 0.0, 0.0, 0.0f, null, 30, null);
        Configurable configurable = this;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.color$delegate = Configurable.color$default(configurable, "Color", color, false, null, 12, null);
        this.shadow$delegate = Configurable.boolean$default(this, "Shadow", true, null, 4, null);
        this.xDistance$delegate = Configurable.float$default(this, "ShadowXDistance", 1.0f, RangesKt.rangeTo(-2.0f, 2.0f), null, () -> Image.xDistance_delegate$lambda$0(this), 8, null);
        this.yDistance$delegate = Configurable.float$default(this, "ShadowYDistance", 1.0f, RangesKt.rangeTo(-2.0f, 2.0f), null, () -> Image.yDistance_delegate$lambda$1(this), 8, null);
        Configurable configurable2 = this;
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        this.shadowColor$delegate = Configurable.color$default(configurable2, "ShadowColor", ColorUtils.INSTANCE.withAlpha(color2, 128), false, () -> Image.shadowColor_delegate$lambda$2(this), 4, null);
        this.image = Configurable.text$default(this, "Image", "", null, 4, null).onChanged(arg_0 -> Image.image$lambda$3(this, arg_0));
        this.resourceLocation = new ResourceLocation(RandomUtils.INSTANCE.randomNumber(128));
        this.width = 64;
        this.height = 64;
    }

    private final Color getColor() {
        return this.color$delegate.getValue((Object)this, (KProperty)$$delegatedProperties[0]);
    }

    private final boolean getShadow() {
        return (Boolean)this.shadow$delegate.getValue((Object)this, (KProperty)$$delegatedProperties[1]);
    }

    private final float getXDistance() {
        return ((Number)this.xDistance$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2])).floatValue();
    }

    private final float getYDistance() {
        return ((Number)this.yDistance$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3])).floatValue();
    }

    private final Color getShadowColor() {
        return this.shadowColor$delegate.getValue((Object)this, (KProperty)$$delegatedProperties[4]);
    }

    @Override
    @NotNull
    public Border drawElement() {
        if (this.getShadow()) {
            RenderUtils.drawImage$default(RenderUtils.INSTANCE, this.resourceLocation, Float.valueOf(this.getXDistance()), Float.valueOf(this.getYDistance()), this.width / 2, this.height / 2, this.getShadowColor(), 0.0f, 64, null);
        }
        RenderUtils.drawImage$default(RenderUtils.INSTANCE, this.resourceLocation, 0, 0, this.width / 2, this.height / 2, this.getColor(), 0.0f, 64, null);
        return new Border(0.0f, 0.0f, (float)this.width / 2.0f, (float)this.height / 2.0f);
    }

    @Override
    public boolean createElement() {
        boolean bl;
        FileFilter[] fileFilterArray = new FileFilter[]{FileFilters.ALL_IMAGES};
        File file = MiscUtils.openFileChooser(fileFilterArray, false);
        if (file == null) {
            return false;
        }
        File file2 = file;
        if (!file2.exists()) {
            MiscUtils.showMessageDialog$default("Error", "The file does not exist.", 0, 4, null);
            return false;
        }
        if (file2.isDirectory()) {
            MiscUtils.showMessageDialog$default("Error", "The file is a directory.", 0, 4, null);
            return false;
        }
        try {
            this.setImage(file2);
            bl = true;
        }
        catch (Exception e2) {
            MiscUtils.showMessageDialog$default("Error", "Exception occurred while opening the image: " + e2.getMessage(), 0, 4, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Image setImage(String b64image) {
        BufferedImage bufferedImage;
        Image image;
        Image $this$setImage_u24lambda_u244 = image = this;
        boolean bl = false;
        $this$setImage_u24lambda_u244.image.changeValue(b64image);
        byte[] byArray = Base64.getDecoder().decode(b64image);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        Object object = byArray;
        object = new ByteArrayInputStream((byte[])object);
        Throwable throwable = null;
        try {
            InputStream p0 = (InputStream)object;
            boolean bl2 = false;
            boolean $i$f$setImage$lambda$4$stub_for_inlining = false;
            bufferedImage = ImageIO.read(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        $this$setImage_u24lambda_u244.width = bufferedImage2.getWidth();
        $this$setImage_u24lambda_u244.height = bufferedImage2.getHeight();
        $this$setImage_u24lambda_u244.getMc().func_110434_K().func_110579_a($this$setImage_u24lambda_u244.resourceLocation, (ITextureObject)new DynamicTexture(bufferedImage2));
        return image;
    }

    private final Image setImage(File image) {
        Image image2;
        Image $this$setImage_u24lambda_u245 = image2 = this;
        boolean bl = false;
        String string = Base64.getEncoder().encodeToString(FilesKt.readBytes(image));
        Intrinsics.checkNotNullExpressionValue(string, "encodeToString(...)");
        $this$setImage_u24lambda_u245.setImage(string);
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveImage() {
        int result2;
        Object object = new FileFilter[]{FileFilters.ALL_IMAGES};
        File file = MiscUtils.saveFileChooser(object, false);
        if (file == null) {
            MiscUtils.showMessageDialog$default("Save Image", "Please choose an image file.", 0, 4, null);
            return;
        }
        if (file.isDirectory()) {
            MiscUtils.showMessageDialog$default("Save Image", "Please choose a file, not a folder.", 0, 4, null);
            return;
        }
        if (file.isFile() && (result2 = JOptionPane.showConfirmDialog(null, "Save Image", "File " + file.getName() + " already exists. Do you want to overwrite it?", 0)) != 0) {
            return;
        }
        try {
            object = Okio.buffer(Okio.sink$default(file, false, 1, null));
            Throwable throwable = null;
            try {
                BufferedSink it = (BufferedSink)object;
                boolean bl = false;
                ByteString byteString = ByteString.Companion.decodeBase64(this.image.get());
                if (byteString == null) {
                    throw new IllegalStateException("Failed to decode Base64 image".toString());
                }
                BufferedSink bufferedSink = it.write(byteString);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        catch (Exception e2) {
            ClientUtils.INSTANCE.getLOGGER().error("Failed to save image", (Throwable)e2);
            ClientUtils.INSTANCE.displayChatMessage("\u00a7cFailed to save image: " + e2.getMessage());
        }
    }

    private static final boolean xDistance_delegate$lambda$0(Image this$0) {
        return this$0.getShadow();
    }

    private static final boolean yDistance_delegate$lambda$1(Image this$0) {
        return this$0.getShadow();
    }

    private static final boolean shadowColor_delegate$lambda$2(Image this$0) {
        return this$0.getShadow();
    }

    private static final Unit image$lambda$3(Image this$0, String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (StringsKt.isBlank(value)) {
            return Unit.INSTANCE;
        }
        this$0.setImage(value);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Image.class, "color", "getColor()Ljava/awt/Color;", 0)), Reflection.property1(new PropertyReference1Impl(Image.class, "shadow", "getShadow()Z", 0)), Reflection.property1(new PropertyReference1Impl(Image.class, "xDistance", "getXDistance()F", 0)), Reflection.property1(new PropertyReference1Impl(Image.class, "yDistance", "getYDistance()F", 0)), Reflection.property1(new PropertyReference1Impl(Image.class, "shadowColor", "getShadowColor()Ljava/awt/Color;", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lnet/ccbluex/liquidbounce/ui/client/hud/element/elements/Image$Companion;", "", "<init>", "()V", "default", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/elements/Image;", "FDPClient"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Image default() {
            Image image = new Image();
            image.setX(1.0);
            image.setY(1.0);
            return image;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

