/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.ui.client.hud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.ccbluex.liquidbounce.ui.client.hud.designer.EditorPanel;
import net.ccbluex.liquidbounce.ui.client.hud.designer.GuiHudDesigner;
import net.ccbluex.liquidbounce.ui.client.hud.element.Border;
import net.ccbluex.liquidbounce.ui.client.hud.element.Element;
import net.ccbluex.liquidbounce.ui.client.hud.element.ElementInfo;
import net.ccbluex.liquidbounce.ui.client.hud.element.elements.Arraylist;
import net.ccbluex.liquidbounce.ui.client.hud.element.elements.Notification;
import net.ccbluex.liquidbounce.ui.client.hud.element.elements.Notifications;
import net.ccbluex.liquidbounce.ui.client.hud.element.elements.ScoreboardElement;
import net.ccbluex.liquidbounce.ui.client.hud.element.elements.Watermark;
import net.ccbluex.liquidbounce.utils.client.ClassUtils;
import net.ccbluex.liquidbounce.utils.client.ClientUtils;
import net.ccbluex.liquidbounce.utils.client.MinecraftInstance;
import net.ccbluex.liquidbounce.utils.extensions.MathExtensionsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u001e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"J\u0006\u0010%\u001a\u00020\u001bJ\u0016\u0010&\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"J\u0016\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0006J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0006J\u0006\u00100\u001a\u00020\u001bJ\u000e\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u000bJ\u000e\u00103\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00100\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R=\u0010\u0014\u001a.\u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020\u0006 \u0016*\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u00170\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Lnet/ccbluex/liquidbounce/ui/client/hud/HUD;", "Lnet/ccbluex/liquidbounce/utils/client/MinecraftInstance;", "<init>", "()V", "elements", "", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/Element;", "getElements", "()Ljava/util/List;", "notifications", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/elements/Notification;", "getNotifications", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "ELEMENTS_CLASSES", "", "Ljava/lang/Class;", "getELEMENTS_CLASSES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "ELEMENTS", "Ljava/util/IdentityHashMap;", "kotlin.jvm.PlatformType", "Lnet/ccbluex/liquidbounce/ui/client/hud/element/ElementInfo;", "getELEMENTS", "()Ljava/util/IdentityHashMap;", "setDefault", "", "render", "designer", "", "update", "handleMouseClick", "mouseX", "", "mouseY", "button", "handleMouseReleased", "handleMouseMove", "handleKey", "c", "", "keyCode", "addElement", "element", "removeElement", "hudDesigner", "Lnet/ccbluex/liquidbounce/ui/client/hud/designer/GuiHudDesigner;", "clearElements", "addNotification", "notification", "removeNotification", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nHUD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HUD.kt\nnet/ccbluex/liquidbounce/ui/client/hud/HUD\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,187:1\n1053#2:188\n1863#2,2:189\n1010#2,2:191\n1755#2,3:193\n37#3:196\n36#3,3:197\n9469#4,4:200\n*S KotlinDebug\n*F\n+ 1 HUD.kt\nnet/ccbluex/liquidbounce/ui/client/hud/HUD\n*L\n50#1:188\n51#1:189,2\n157#1:191,2\n183#1:193,3\n30#1:196\n30#1:197,3\n32#1:200,4\n*E\n"})
public final class HUD
implements MinecraftInstance {
    @NotNull
    public static final HUD INSTANCE;
    @NotNull
    private static final List<Element> elements;
    @NotNull
    private static final CopyOnWriteArrayList<Notification> notifications;
    @NotNull
    private static final Class<? extends Element>[] ELEMENTS_CLASSES;
    @NotNull
    private static final IdentityHashMap<Class<? extends Element>, ElementInfo> ELEMENTS;

    private HUD() {
    }

    @NotNull
    public final List<Element> getElements() {
        return elements;
    }

    @NotNull
    public final CopyOnWriteArrayList<Notification> getNotifications() {
        return notifications;
    }

    @NotNull
    public final Class<? extends Element>[] getELEMENTS_CLASSES() {
        return ELEMENTS_CLASSES;
    }

    @NotNull
    public final IdentityHashMap<Class<? extends Element>, ElementInfo> getELEMENTS() {
        return ELEMENTS;
    }

    public final void setDefault() {
        elements.clear();
        this.addElement(new Watermark());
        this.addElement(new Arraylist(0.0, 0.0, 0.0f, null, 15, null));
        this.addElement(new ScoreboardElement(0.0, 0.0, 0.0f, null, 15, null));
        this.addElement(new Notifications(0.0, 0.0, 0.0f, null, 15, null));
    }

    public final void render(boolean designer) {
        Iterable $this$sortedBy$iv = elements;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Element it = (Element)a2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(-it.getInfo().priority());
                it = (Element)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, -it.getInfo().priority());
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            GL11.glPushMatrix();
            if (!it.getInfo().disableScale()) {
                GL11.glScalef((float)it.getScale(), (float)it.getScale(), (float)it.getScale());
            }
            GL11.glTranslated((double)it.getRenderX(), (double)it.getRenderY(), (double)0.0);
            try {
                it.setBorder(it.drawElement());
                if (designer) {
                    Border border = it.getBorder();
                    if (border != null) {
                        border.draw();
                    }
                }
            }
            catch (Exception ex) {
                ClientUtils.INSTANCE.getLOGGER().error("Something went wrong while drawing " + it.getName() + " element in HUD.", (Throwable)ex);
            }
            GL11.glPopMatrix();
        }
    }

    public final void update() {
        for (Element element : elements) {
            element.updateElement();
        }
    }

    public final void handleMouseClick(int mouseX, int mouseY, int button) {
        for (Element element : elements) {
            element.handleMouseClick((double)((float)mouseX / element.getScale()) - element.getRenderX(), (double)((float)mouseY / element.getScale()) - element.getRenderY(), button);
        }
        if (button == 0) {
            for (Element element : CollectionsKt.reversed((Iterable)elements)) {
                if (!element.isInBorder((double)((float)mouseX / element.getScale()) - element.getRenderX(), (double)((float)mouseY / element.getScale()) - element.getRenderY())) continue;
                element.setDrag(true);
                ((Collection)elements).remove(element);
                ((Collection)elements).add(element);
                break;
            }
        }
    }

    public final void handleMouseReleased() {
        for (Element element : elements) {
            element.setDrag(false);
        }
    }

    public final void handleMouseMove(int mouseX, int mouseY) {
        if (!(this.getMc().field_71462_r instanceof GuiHudDesigner)) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(this.getMc());
        int scaledWidth = MathExtensionsKt.component1(scaledResolution);
        int scaledHeight = MathExtensionsKt.component2(scaledResolution);
        for (Element element : elements) {
            Border border;
            float scaledX = (float)mouseX / element.getScale();
            float scaledY = (float)mouseY / element.getScale();
            float prevMouseX = element.getPrevMouseX();
            float prevMouseY = element.getPrevMouseY();
            element.setPrevMouseX(scaledX);
            element.setPrevMouseY(scaledY);
            if (!element.getDrag()) continue;
            float moveX = scaledX - prevMouseX;
            float moveY = scaledY - prevMouseY;
            if (moveX == 0.0f && moveY == 0.0f || element.getBorder() == null) continue;
            float minX = Math.min(border.getX(), border.getX2()) + 1.0f;
            float minY = Math.min(border.getY(), border.getY2()) + 1.0f;
            float maxX = Math.max(border.getX(), border.getX2()) - 1.0f;
            float maxY = Math.max(border.getY(), border.getY2()) - 1.0f;
            float width = (float)scaledWidth / element.getScale();
            float height = (float)scaledHeight / element.getScale();
            if ((element.getRenderX() + (double)minX + (double)moveX >= 0.0 || moveX > 0.0f) && (element.getRenderX() + (double)maxX + (double)moveX <= (double)width || moveX < 0.0f)) {
                element.setRenderX(moveX);
            }
            if (!(element.getRenderY() + (double)minY + (double)moveY >= 0.0) && !(moveY > 0.0f) || !(element.getRenderY() + (double)maxY + (double)moveY <= (double)height) && !(moveY < 0.0f)) continue;
            element.setRenderY(moveY);
        }
    }

    public final void handleKey(char c2, int keyCode) {
        for (Element element : elements) {
            element.handleKey(c2, keyCode);
        }
    }

    @NotNull
    public final HUD addElement(@NotNull Element element) {
        Intrinsics.checkNotNullParameter(element, "element");
        ((Collection)elements).add(element);
        List<Element> $this$sortBy$iv = elements;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    Element it = (Element)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-it.getInfo().priority());
                    it = (Element)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, -it.getInfo().priority());
                }
            });
        }
        element.updateElement();
        return this;
    }

    @NotNull
    public final HUD removeElement(@NotNull GuiHudDesigner hudDesigner, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)hudDesigner, "hudDesigner");
        Intrinsics.checkNotNullParameter(element, "element");
        EditorPanel.ElementEditableText elementEditableText = hudDesigner.getElementEditableText();
        if (Intrinsics.areEqual(elementEditableText != null ? elementEditableText.getElement() : null, element)) {
            hudDesigner.setElementEditableText(null);
        }
        element.destroyElement();
        elements.remove(element);
        return this;
    }

    public final void clearElements() {
        for (Element element : elements) {
            element.destroyElement();
        }
        elements.clear();
    }

    public final boolean addNotification(@NotNull Notification notification) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(notification, "notification");
            Iterable $this$any$iv = elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Element it = (Element)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof Notifications)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && notifications.add(notification);
    }

    public final boolean removeNotification(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter(notification, "notification");
        return notifications.remove(notification);
    }

    @Override
    @NotNull
    public Minecraft getMc() {
        return MinecraftInstance.DefaultImpls.getMc(this);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        void $this$associateWithTo$iv;
        INSTANCE = new HUD();
        elements = new ArrayList();
        notifications = new CopyOnWriteArrayList();
        Class<? extends Element>[] $this$toTypedArray$iv = (Class<? extends Element>[])ClassUtils.INSTANCE.resolvePackage(HUD.class.getPackage().getName() + ".element.elements", Element.class);
        boolean $i$f$toTypedArray = false;
        Class<? extends Element>[] thisCollection$iv = $this$toTypedArray$iv;
        ELEMENTS_CLASSES = thisCollection$iv.toArray(new Class[0]);
        $this$toTypedArray$iv = ELEMENTS_CLASSES;
        Map destination$iv = new IdentityHashMap(ELEMENTS_CLASSES.length);
        boolean $i$f$associateWithTo = false;
        int n = ((void)$this$associateWithTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var6_8 = element$iv = $this$associateWithTo$iv[i];
            void var9_11 = element$iv;
            Map map2 = destination$iv;
            boolean bl = false;
            ElementInfo elementInfo = it.getAnnotation(ElementInfo.class);
            map2.put(var9_11, elementInfo);
        }
        ELEMENTS = (IdentityHashMap)var1_2;
    }
}

