/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.script;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.ccbluex.liquidbounce.file.FileManager;
import net.ccbluex.liquidbounce.script.Script;
import net.ccbluex.liquidbounce.script.ScriptManagerKt;
import net.ccbluex.liquidbounce.script.remapper.Remapper;
import net.ccbluex.liquidbounce.utils.client.ClientUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0002J\u0006\u0010\u001a\u001a\u00020\u0010J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010\u001e\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0001J\u0011\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0096\u0003J\u0011\u0010$\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001J\t\u0010%\u001a\u00020\u001cH\u0096\u0001J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0096\u0003J\u0011\u0010(\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0096\u0001J\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*2\u0006\u0010\"\u001a\u00020#H\u0096\u0001J\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020#H\u0096\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010.\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"Lnet/ccbluex/liquidbounce/script/ScriptManager;", "", "Lnet/ccbluex/liquidbounce/script/Script;", "<init>", "()V", "scriptsFolder", "Ljava/io/File;", "getScriptsFolder", "()Ljava/io/File;", "SCRIPT_FILE_FILTER", "Ljava/io/FileFilter;", "availableScriptFiles", "", "getAvailableScriptFiles", "()[Ljava/io/File;", "loadScripts", "", "unloadScripts", "loadScript", "scriptFile", "enableScripts", "disableScripts", "importScript", "file", "deleteScript", "script", "reloadScripts", "contains", "", "element", "containsAll", "elements", "", "get", "index", "", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "size", "getSize", "()I", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nScriptManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptManager.kt\nnet/ccbluex/liquidbounce/script/ScriptManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n13402#2,2:108\n1863#3,2:110\n1863#3,2:112\n*S KotlinDebug\n*F\n+ 1 ScriptManager.kt\nnet/ccbluex/liquidbounce/script/ScriptManager\n*L\n37#1:108,2\n65#1:110,2\n70#1:112,2\n*E\n"})
public final class ScriptManager
implements List<Script>,
KMappedMarker {
    @NotNull
    public static final ScriptManager INSTANCE = new ScriptManager();
    private final /* synthetic */ List<Script> $$delegate_0;
    @NotNull
    private static final File scriptsFolder = new File(FileManager.INSTANCE.getDir(), "scripts");
    @NotNull
    private static final FileFilter SCRIPT_FILE_FILTER = ScriptManager::SCRIPT_FILE_FILTER$lambda$0;

    private ScriptManager() {
        this.$$delegate_0 = ScriptManagerKt.access$getScripts$p();
    }

    @NotNull
    public final File getScriptsFolder() {
        return scriptsFolder;
    }

    @NotNull
    public final File[] getAvailableScriptFiles() {
        File[] fileArray = scriptsFolder.listFiles(SCRIPT_FILE_FILTER);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    public final void loadScripts() {
        if (!scriptsFolder.exists()) {
            scriptsFolder.mkdir();
        }
        File[] $this$forEach$iv = this.getAvailableScriptFiles();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File p0 = element$iv = $this$forEach$iv[i];
            boolean $i$f$loadScripts$stub_for_inlining = false;
            boolean bl = false;
            this.loadScript(p0);
        }
    }

    public final void unloadScripts() {
        ScriptManagerKt.access$getScripts$p().clear();
    }

    public final void loadScript(@NotNull File scriptFile) {
        Intrinsics.checkNotNullParameter(scriptFile, "scriptFile");
        try {
            if (!Remapper.INSTANCE.getMappingsLoaded()) {
                throw new IllegalStateException("The mappings were not loaded, re-start and check your internet connection.".toString());
            }
            Script script = new Script(scriptFile);
            script.initScript();
            ((Collection)ScriptManagerKt.access$getScripts$p()).add(script);
        }
        catch (Throwable t) {
            ClientUtils.INSTANCE.getLOGGER().error("[ScriptAPI] Failed to load script '" + scriptFile.getName() + "'.", t);
        }
    }

    public final void enableScripts() {
        Iterable $this$forEach$iv = ScriptManagerKt.access$getScripts$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Script it = (Script)element$iv;
            boolean bl = false;
            it.onEnable();
        }
    }

    public final void disableScripts() {
        Iterable $this$forEach$iv = ScriptManagerKt.access$getScripts$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Script it = (Script)element$iv;
            boolean bl = false;
            it.onDisable();
        }
    }

    public final void importScript(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        File scriptFile = new File(scriptsFolder, file.getName());
        FilesKt.copyTo$default(file, scriptFile, false, 0, 6, null);
        this.loadScript(scriptFile);
        ClientUtils.INSTANCE.getLOGGER().info("[ScriptAPI] Successfully imported script '" + scriptFile.getName() + "'.");
    }

    public final void deleteScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter(script, "script");
        script.onDisable();
        ScriptManagerKt.access$getScripts$p().remove(script);
        script.getScriptFile().delete();
        ClientUtils.INSTANCE.getLOGGER().info("[ScriptAPI] Successfully deleted script '" + script.getScriptFile().getName() + "'.");
    }

    public final void reloadScripts() {
        this.disableScripts();
        this.unloadScripts();
        this.loadScripts();
        this.enableScripts();
        ClientUtils.INSTANCE.getLOGGER().info("[ScriptAPI] Successfully reloaded scripts.");
    }

    public boolean contains(@NotNull Script element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.$$delegate_0.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.$$delegate_0.containsAll(elements);
    }

    @Override
    @NotNull
    public Script get(int index) {
        return this.$$delegate_0.get(index);
    }

    public int indexOf(@NotNull Script element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.$$delegate_0.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.$$delegate_0.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Script> iterator() {
        return this.$$delegate_0.iterator();
    }

    public int lastIndexOf(@NotNull Script element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.$$delegate_0.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<Script> listIterator() {
        return this.$$delegate_0.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Script> listIterator(int index) {
        return this.$$delegate_0.listIterator(index);
    }

    @Override
    @NotNull
    public List<Script> subList(int fromIndex, int toIndex) {
        return this.$$delegate_0.subList(fromIndex, toIndex);
    }

    public int getSize() {
        return this.$$delegate_0.size();
    }

    @Override
    public boolean add(Script element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, Script element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Script> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Script> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Script remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Script set(int index, Script element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Script> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Script> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final boolean SCRIPT_FILE_FILTER$lambda$0(File it) {
        Intrinsics.checkNotNull(it);
        String string = FilesKt.getExtension(it).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return Intrinsics.areEqual(string, "js");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

