/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.file.configs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.ccbluex.liquidbounce.config.FontValue;
import net.ccbluex.liquidbounce.config.Value;
import net.ccbluex.liquidbounce.file.FileConfig;
import net.ccbluex.liquidbounce.file.gson.JsonArrayBuilder;
import net.ccbluex.liquidbounce.file.gson.JsonObjectBuilder;
import net.ccbluex.liquidbounce.ui.client.hud.HUD;
import net.ccbluex.liquidbounce.ui.client.hud.element.Element;
import net.ccbluex.liquidbounce.ui.client.hud.element.ElementInfo;
import net.ccbluex.liquidbounce.ui.client.hud.element.Side;
import net.ccbluex.liquidbounce.utils.client.ClientUtils;
import net.ccbluex.liquidbounce.utils.io.FileExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lnet/ccbluex/liquidbounce/file/configs/HudConfig;", "Lnet/ccbluex/liquidbounce/file/FileConfig;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "loadDefault", "", "loadConfig", "saveConfig", "FDPClient"})
@SourceDebugExtension(value={"SMAP\nHudConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudConfig.kt\nnet/ccbluex/liquidbounce/file/configs/HudConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 GsonExtensions.kt\nnet/ccbluex/liquidbounce/file/gson/GsonExtensionsKt\n*L\n1#1,118:1\n1#2:119\n2632#3,3:120\n1863#3,2:125\n77#4:123\n71#4:124\n*S KotlinDebug\n*F\n+ 1 HudConfig.kt\nnet/ccbluex/liquidbounce/file/configs/HudConfig\n*L\n82#1:120,3\n109#1:125,2\n99#1:123\n101#1:124\n*E\n"})
public final class HudConfig
extends FileConfig {
    public HudConfig(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
    }

    @Override
    public void loadDefault() {
        HUD.INSTANCE.setDefault();
    }

    @Override
    public void loadConfig() throws IOException {
        JsonElement object5 = FileExtensionsKt.readJson(this.getFile());
        JsonArray jsonArray = object5 instanceof JsonArray ? (JsonArray)object5 : null;
        if (jsonArray == null) {
            return;
        }
        JsonArray jsonArray2 = jsonArray;
        HUD.INSTANCE.clearElements();
        try {
            Iterator iterator2 = jsonArray2.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object elementClass;
                JsonElement jsonElement = (JsonElement)iterator3.next();
                if (!(jsonElement instanceof JsonObject) || !((JsonObject)jsonElement).has("Type")) continue;
                String type = ((JsonObject)jsonElement).get("Type").getAsString();
                try {
                    Object v3;
                    Map.Entry it;
                    Object object;
                    Object object2;
                    block18: {
                        Set<Map.Entry<Class<? extends Element>, ElementInfo>> set = HUD.INSTANCE.getELEMENTS().entrySet();
                        Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
                        Iterable iterable = set;
                        object2 = iterable.iterator();
                        while (object2.hasNext()) {
                            object = object2.next();
                            it = (Map.Entry)object;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(((ElementInfo)it.getValue()).name(), type)) continue;
                            v3 = object;
                            break block18;
                        }
                        v3 = null;
                    }
                    Map.Entry entry = v3;
                    Object object3 = elementClass = entry != null ? (Class)entry.getKey() : null;
                    if (elementClass == null) {
                        ClientUtils.INSTANCE.getLOGGER().warn("Unrecognized HUD element: '" + type + '\'');
                        continue;
                    }
                    Element element = (Element)((Class)elementClass).newInstance();
                    element.setX(((JsonObject)jsonElement).get("X").getAsDouble());
                    element.setY(((JsonObject)jsonElement).get("Y").getAsDouble());
                    element.setScale(((JsonObject)jsonElement).get("Scale").getAsFloat());
                    String string = ((JsonObject)jsonElement).get("HorizontalFacing").getAsString();
                    Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                    Side.Horizontal horizontal = Side.Horizontal.Companion.getByName(string);
                    if (horizontal == null) {
                        horizontal = Side.Horizontal.RIGHT;
                    }
                    String string2 = ((JsonObject)jsonElement).get("VerticalFacing").getAsString();
                    Intrinsics.checkNotNullExpressionValue(string2, "getAsString(...)");
                    Side.Vertical vertical = Side.Vertical.Companion.getByName(string2);
                    if (vertical == null) {
                        vertical = Side.Vertical.UP;
                    }
                    element.setSide(new Side(horizontal, vertical));
                    for (Value<?> value : element.getValues()) {
                        if (!((JsonObject)jsonElement).has(value.getName())) continue;
                        JsonElement jsonElement2 = ((JsonObject)jsonElement).get(value.getName());
                        Intrinsics.checkNotNullExpressionValue(jsonElement2, "get(...)");
                        value.fromJson(jsonElement2);
                    }
                    if (((JsonObject)jsonElement).has("font")) {
                        Map.Entry entry2;
                        block19: {
                            object2 = element.getValues();
                            object = object2.iterator();
                            while (object.hasNext()) {
                                it = object.next();
                                Value it2 = (Value)((Object)it);
                                boolean bl = false;
                                if (!(it2 instanceof FontValue)) continue;
                                entry2 = it;
                                break block19;
                            }
                            entry2 = null;
                        }
                        Value value = (Value)((Object)entry2);
                        if (value != null) {
                            JsonElement jsonElement3 = ((JsonObject)jsonElement).get("font");
                            Intrinsics.checkNotNullExpressionValue(jsonElement3, "get(...)");
                            value.fromJson(jsonElement3);
                        }
                    }
                    Intrinsics.checkNotNull(element);
                    elementClass = HUD.INSTANCE.addElement(element);
                }
                catch (Exception e2) {
                    ClientUtils.INSTANCE.getLOGGER().error("Error while loading custom HUD element '" + type + "' from config.", (Throwable)e2);
                    elementClass = Unit.INSTANCE;
                }
            }
            for (Map.Entry entry : ((Map)HUD.INSTANCE.getELEMENTS()).entrySet()) {
                boolean bl;
                Class elementClass;
                block20: {
                    elementClass = (Class)entry.getKey();
                    ElementInfo info = (ElementInfo)entry.getValue();
                    if (!info.force()) continue;
                    Iterable $this$none$iv = HUD.INSTANCE.getElements();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Element it = (Element)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getClass(), elementClass)) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                Object t = elementClass.newInstance();
                Intrinsics.checkNotNullExpressionValue(t, "newInstance(...)");
                HUD.INSTANCE.addElement((Element)t);
            }
        }
        catch (Exception e3) {
            ClientUtils.INSTANCE.getLOGGER().error("Error while loading custom hud config.", (Throwable)e3);
            HUD.INSTANCE.setDefault();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveConfig() throws IOException {
        JsonArrayBuilder jsonArrayBuilder;
        boolean $i$f$jsonArray = false;
        JsonArrayBuilder $this$saveConfig_u24lambda_u245 = jsonArrayBuilder = new JsonArrayBuilder();
        boolean bl = false;
        for (Element element : HUD.INSTANCE.getElements()) {
            void $this$saveConfig_u24lambda_u245_u24lambda_u244;
            JsonObjectBuilder jsonObjectBuilder;
            boolean $i$f$json = false;
            JsonObjectBuilder jsonObjectBuilder2 = jsonObjectBuilder = new JsonObjectBuilder();
            JsonArrayBuilder jsonArrayBuilder2 = $this$saveConfig_u24lambda_u245;
            boolean bl2 = false;
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("Type", element.getName());
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("X", element.getX());
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("Y", element.getY());
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("Scale", Float.valueOf(element.getScale()));
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("HorizontalFacing", element.getSide().getHorizontal().getSideName());
            $this$saveConfig_u24lambda_u245_u24lambda_u244.to("VerticalFacing", element.getSide().getVertical().getSideName());
            Iterable $this$forEach$iv = element.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Value it = (Value)element$iv;
                boolean bl3 = false;
                $this$saveConfig_u24lambda_u245_u24lambda_u244.to(it.getName(), (Object)it.toJson());
            }
            jsonArrayBuilder2.unaryPlus((JsonElement)jsonObjectBuilder.build());
        }
        JsonArray jsonArray = jsonArrayBuilder.build();
        FileExtensionsKt.writeJson$default(this.getFile(), (JsonElement)jsonArray, null, 2, null);
    }
}

