/*
 * Decompiled with CFR 0.152.
 */
package net.ccbluex.liquidbounce.file.configs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.ccbluex.liquidbounce.file.FileConfig;
import net.ccbluex.liquidbounce.file.FileManager;
import net.ccbluex.liquidbounce.utils.client.ClientThemesUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lnet/ccbluex/liquidbounce/file/configs/ColorThemeConfig;", "Lnet/ccbluex/liquidbounce/file/FileConfig;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "loadConfig", "", "saveConfig", "FDPClient"})
public final class ColorThemeConfig
extends FileConfig {
    public ColorThemeConfig(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        super(file);
    }

    @Override
    public void loadConfig() {
        if (!this.getFile().exists()) {
            System.out.println((Object)"Config file does not exist. Loading default values.");
            this.loadDefault();
            return;
        }
        try {
            String content = FilesKt.readText(this.getFile(), Charsets.UTF_8);
            JsonObject json = new JsonParser().parse(content).getAsJsonObject();
            if (json.has("Theme")) {
                ClientThemesUtils.INSTANCE.setClientColorMode(json.get("Theme").getAsString());
            }
            if (json.has("Fade-Speed")) {
                ClientThemesUtils.INSTANCE.setThemeFadeSpeed(json.get("Fade-Speed").getAsInt());
            }
            if (json.has("Fade-Type")) {
                ClientThemesUtils.INSTANCE.setUpdown(json.get("Fade-Type").getAsBoolean());
            }
        }
        catch (Exception e2) {
            System.out.println((Object)("Error loading Color Theme Client: " + e2.getMessage()));
        }
    }

    @Override
    public void saveConfig() {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("Theme", ClientThemesUtils.INSTANCE.getClientColorMode());
            json.addProperty("Fade-Speed", (Number)ClientThemesUtils.INSTANCE.getThemeFadeSpeed());
            json.addProperty("Fade-Type", Boolean.valueOf(ClientThemesUtils.INSTANCE.getUpdown()));
            File file = this.getFile();
            String string = FileManager.INSTANCE.getPRETTY_GSON().toJson((JsonElement)json);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            FilesKt.writeText(file, string, Charsets.UTF_8);
        }
        catch (Exception e2) {
            System.out.println((Object)("Error saving Color Theme Config: " + e2.getMessage()));
        }
    }
}

