/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.packet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import moe.lasoleil.axochat4j.annotation.PacketMetadata;
import moe.lasoleil.axochat4j.exception.MalformedPacketException;
import moe.lasoleil.axochat4j.exception.PacketIOException;
import moe.lasoleil.axochat4j.packet.c2s.C2SBanUserPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SLoginJWTPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SLoginMojangPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SMessagePacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SPrivateMessagePacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestJWTPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestMojangInfoPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestUserCountPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SUnbanUserPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CErrorPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CMessagePacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CMojangInfoPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CNewJWTPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CPrivateMessagePacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CSuccessPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CUserCountPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AxochatPacket {
    public static PacketMetadata metadata(@NotNull AxochatPacket packet) {
        return AxochatPacket.metadata(Objects.requireNonNull(packet.getClass()));
    }

    public static PacketMetadata metadata(@NotNull Class<? extends AxochatPacket> packetClass) {
        return Objects.requireNonNull(packetClass.getAnnotation(PacketMetadata.class));
    }

    public static interface S2C
    extends AxochatPacket {
        public static final List<Class<? extends S2C>> ALL = Collections.unmodifiableList(Arrays.asList(S2CErrorPacket.class, S2CMessagePacket.class, S2CMojangInfoPacket.class, S2CNewJWTPacket.class, S2CPrivateMessagePacket.class, S2CSuccessPacket.class, S2CUserCountPacket.class));
    }

    public static interface C2S
    extends AxochatPacket {
        public static final List<Class<? extends C2S>> ALL = Collections.unmodifiableList(Arrays.asList(C2SBanUserPacket.class, C2SLoginJWTPacket.class, C2SLoginMojangPacket.class, C2SMessagePacket.class, C2SPrivateMessagePacket.class, C2SRequestJWTPacket.class, C2SRequestMojangInfoPacket.class, C2SRequestUserCountPacket.class, C2SUnbanUserPacket.class));
    }

    public static interface Adapter {
        @NotNull
        public Type type();

        @NotNull
        public AxochatPacket read(@NotNull String var1) throws PacketIOException, MalformedPacketException;

        public void write(@NotNull Appendable var1, @NotNull AxochatPacket var2) throws PacketIOException;

        public static enum Type {
            CLIENT,
            SERVER;

        }
    }

    public static final class Full {
        @SerializedName(value="m")
        @JsonProperty(value="m")
        @NotNull
        private final String packetName;
        @SerializedName(value="c")
        @JsonProperty(value="c")
        @Nullable
        private final AxochatPacket packetContent;

        public static Full of(@NotNull AxochatPacket packet) {
            PacketMetadata metadata = AxochatPacket.metadata(packet);
            return new Full(metadata.name(), metadata.noArg() ? null : packet);
        }

        @JsonProperty(value="m")
        @NotNull
        @Generated
        public String getPacketName() {
            return this.packetName;
        }

        @JsonProperty(value="c")
        @Nullable
        @Generated
        public AxochatPacket getPacketContent() {
            return this.packetContent;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Full)) {
                return false;
            }
            Full other = (Full)o;
            String this$packetName = this.getPacketName();
            String other$packetName = other.getPacketName();
            if (this$packetName == null ? other$packetName != null : !this$packetName.equals(other$packetName)) {
                return false;
            }
            AxochatPacket this$packetContent = this.getPacketContent();
            AxochatPacket other$packetContent = other.getPacketContent();
            return !(this$packetContent == null ? other$packetContent != null : !this$packetContent.equals(other$packetContent));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            String $packetName = this.getPacketName();
            result2 = result2 * 59 + ($packetName == null ? 43 : $packetName.hashCode());
            AxochatPacket $packetContent = this.getPacketContent();
            result2 = result2 * 59 + ($packetContent == null ? 43 : $packetContent.hashCode());
            return result2;
        }

        @Generated
        public String toString() {
            return "AxochatPacket.Full(packetName=" + this.getPacketName() + ", packetContent=" + this.getPacketContent() + ")";
        }

        @JsonCreator
        @Generated
        public Full(@JsonProperty(value="m") @NotNull String packetName, @JsonProperty(value="c") @Nullable AxochatPacket packetContent) {
            if (packetName == null) {
                throw new NullPointerException("packetName is marked non-null but is null");
            }
            this.packetName = packetName;
            this.packetContent = packetContent;
        }
    }
}

