/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.codec;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import moe.lasoleil.axochat4j.annotation.PacketMetadata;
import moe.lasoleil.axochat4j.codec.AppendableWriter;
import moe.lasoleil.axochat4j.exception.MalformedPacketException;
import moe.lasoleil.axochat4j.exception.PacketIOException;
import moe.lasoleil.axochat4j.exception.UnknownPacketNameException;
import moe.lasoleil.axochat4j.packet.AxochatPacket;
import org.jetbrains.annotations.NotNull;

public final class GsonAxochatClientAdapter
implements AxochatPacket.Adapter {
    public static final GsonAxochatClientAdapter INSTANCE = new GsonAxochatClientAdapter();
    private static final Gson GSON = new Gson();
    private static final JsonObject EMPTY = new JsonObject();
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Map<String, Class<? extends AxochatPacket.S2C>> packetNameTypeMap;

    private GsonAxochatClientAdapter() {
    }

    @Override
    @NotNull
    public AxochatPacket.Adapter.Type type() {
        return AxochatPacket.Adapter.Type.CLIENT;
    }

    @Override
    @NotNull
    public AxochatPacket read(@NotNull String source2) throws PacketIOException, MalformedPacketException {
        try {
            JsonElement src = JSON_PARSER.parse(source2);
            if (!(src instanceof JsonObject)) {
                throw new MalformedPacketException("Source JSON " + src + " is not a JsonObject");
            }
            JsonObject jsonObject = (JsonObject)src;
            JsonElement packetName = jsonObject.get("m");
            if (!(packetName instanceof JsonPrimitive)) {
                throw new MalformedPacketException("Packet name " + src + " is not a JsonPrimitive");
            }
            String realPacketName = packetName.getAsString();
            Class<? extends AxochatPacket.S2C> type = packetNameTypeMap.get(realPacketName);
            if (type == null) {
                throw new UnknownPacketNameException(realPacketName);
            }
            PacketMetadata metadata = AxochatPacket.metadata(type);
            if (!metadata.noArg()) {
                JsonElement packetBody = jsonObject.get("c");
                if (!(packetBody instanceof JsonObject)) {
                    throw new MalformedPacketException("Packet body " + packetBody + " is not a JsonObject");
                }
                return (AxochatPacket)GSON.fromJson(packetBody, type);
            }
            return (AxochatPacket)GSON.fromJson((JsonElement)EMPTY, type);
        }
        catch (JsonParseException e2) {
            throw new PacketIOException((Exception)((Object)e2));
        }
    }

    @Override
    public void write(@NotNull Appendable sink2, @NotNull AxochatPacket packet) throws PacketIOException {
        try {
            PacketMetadata metadata = AxochatPacket.metadata(packet);
            JsonWriter writer = new JsonWriter(AppendableWriter.of(sink2));
            writer.beginObject();
            writer.name("m").value(metadata.name());
            if (!metadata.noArg()) {
                writer.name("c");
                GSON.toJson((Object)packet, packet.getClass(), writer);
            }
            writer.endObject();
            writer.flush();
        }
        catch (IOException e2) {
            throw new PacketIOException(e2);
        }
    }

    static {
        int size = AxochatPacket.S2C.ALL.size();
        HashMap<String, Class<? extends AxochatPacket.S2C>> _packetNameTypeMap = new HashMap<String, Class<? extends AxochatPacket.S2C>>(size, 1.0f);
        for (Class<? extends AxochatPacket.S2C> clazz : AxochatPacket.S2C.ALL) {
            PacketMetadata metadata = AxochatPacket.metadata(clazz);
            _packetNameTypeMap.put(metadata.name(), clazz);
        }
        packetNameTypeMap = Collections.unmodifiableMap(_packetNameTypeMap);
    }
}

