/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.codec;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

final class AppendableWriter
extends Writer {
    private final Appendable appendable;

    private AppendableWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    public static Writer of(@NotNull Appendable appendable) {
        return appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
    }

    @Override
    public void write(int c2) throws IOException {
        this.appendable.append((char)c2);
    }

    @Override
    public void write(char @NotNull [] cbuf) throws IOException {
        this.appendable.append(new String(cbuf));
    }

    @Override
    public void write(@NotNull String str) throws IOException {
        this.appendable.append(str);
    }

    @Override
    public void write(@NotNull String str, int off, int len) throws IOException {
        this.appendable.append(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c2) throws IOException {
        this.appendable.append(c2);
        return this;
    }

    @Override
    public void write(char @NotNull [] cbuf, int off, int len) throws IOException {
        this.appendable.append(new String(cbuf, off, len));
    }

    @Override
    public void flush() throws IOException {
        if (this.appendable instanceof Flushable) {
            ((Flushable)((Object)this.appendable)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.appendable instanceof Closeable) {
            ((Closeable)((Object)this.appendable)).close();
        }
    }
}

