/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.TrustManagerFactory;
import moe.lasoleil.axochat4j.client.AbstractAxochatClientConnection;
import moe.lasoleil.axochat4j.client.AxochatClientConnection;
import moe.lasoleil.axochat4j.client.ClientUtils;
import moe.lasoleil.axochat4j.client.WebSocketConnectionEvent;
import moe.lasoleil.axochat4j.exception.PacketIOException;
import moe.lasoleil.axochat4j.packet.AxochatPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NettyAxochatClient
implements AxochatClientConnection.Factory<Bootstrap> {
    public static final NettyAxochatClient INSTANCE = new NettyAxochatClient();

    private NettyAxochatClient() {
    }

    @Nullable
    private static SslContext insecureSslContextOrNull(@NotNull URI uri) {
        boolean ssl = "wss".equalsIgnoreCase(uri.getScheme());
        SslContext sslContext = null;
        if (ssl) {
            try {
                sslContext = SslContext.newClientContext((TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE);
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Failed to create SSL context", e2);
            }
        }
        return sslContext;
    }

    @Override
    @NotNull
    public AxochatClientConnection create(@NotNull Bootstrap bootstrap, final @NotNull AxochatClientConnection.Config config) {
        if (config.getPacketAdapter().type() != AxochatPacket.Adapter.Type.CLIENT) {
            throw new IllegalArgumentException("Packet adaptor type must be CLIENT");
        }
        final URI uri = config.getUri();
        final SslContext sslContext = NettyAxochatClient.insecureSslContextOrNull(uri);
        final AbstractAxochatClientConnection<Channel> connection = new AbstractAxochatClientConnection<Channel>(){

            @Override
            protected boolean isBackendAvailable(@Nullable Channel backend) {
                return backend != null && backend.isWritable();
            }

            @Override
            @NotNull
            protected String backendUnavailableMessage() {
                return "Channel is not writable";
            }

            @Override
            public void send(@NotNull AxochatPacket.C2S packet) throws PacketIOException {
                Channel channel = (Channel)this.getBackendOrError();
                ByteBuf buf = channel.alloc().buffer(128);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new ByteBufOutputStream(buf), StandardCharsets.UTF_8);){
                    config.getPacketAdapter().write(writer, packet);
                }
                catch (PacketIOException e2) {
                    throw e2;
                }
                catch (IOException e3) {
                    throw new PacketIOException(e3);
                }
                channel.writeAndFlush((Object)new TextWebSocketFrame(buf));
            }

            @Override
            public void close() throws IOException {
                try {
                    ((Channel)this.getBackendOrError()).writeAndFlush((Object)new CloseWebSocketFrame(1000, null)).sync();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Close frame sending interrupted", e2);
                }
            }

            @Override
            protected void forceClose() throws IOException {
                try {
                    ((Channel)this.getBackendOrError()).close().sync();
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Channel closing interrupted", e2);
                }
            }
        };
        ((Bootstrap)bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslContext != null) {
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                pipeline.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(65536), new WebSocketClientProtocolHandler(uri, WebSocketVersion.V13, null, true, (HttpHeaders)new DefaultHttpHeaders(), 65536, true), new ChatChannelHandler(connection, config)});
            }
        })).connect(uri.getHost(), uri.getPort()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                connection.setBackend(channelFuture.channel());
            } else {
                ClientUtils.safeAccept(connection, config, new WebSocketConnectionEvent.ErrorOccurred(channelFuture.cause(), System.currentTimeMillis()));
            }
        }));
        return connection;
    }

    private static class ChatChannelHandler
    extends SimpleChannelInboundHandler<WebSocketFrame> {
        private final AxochatClientConnection connection;
        private final AxochatClientConnection.Config config;

        ChatChannelHandler(@NotNull AxochatClientConnection connection, @NotNull AxochatClientConnection.Config config) {
            this.connection = connection;
            this.config = config;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                ClientUtils.safeAccept(this.connection, this.config, new WebSocketConnectionEvent.Connected(this.config.getUri(), System.currentTimeMillis()));
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            ClientUtils.safeAccept(this.connection, this.config, new WebSocketConnectionEvent.Disconnected(this.config.getUri(), -1, null, System.currentTimeMillis()));
            super.channelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ClientUtils.safeAccept(this.connection, this.config, new WebSocketConnectionEvent.ErrorOccurred(cause, System.currentTimeMillis()));
        }

        protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
            if (msg instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)msg;
                String text = textFrame.content().toString(StandardCharsets.UTF_8);
                ClientUtils.safeAccept(this.connection, this.config, new WebSocketConnectionEvent.TextFrameReceived(text, System.currentTimeMillis()));
                ClientUtils.safeRead(this.connection, this.config, text);
            } else if (msg instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)msg;
                ByteBuf byteBuf = binaryFrame.content();
                ClientUtils.safeAccept(this.connection, this.config, new WebSocketConnectionEvent.BinaryFrameReceived(byteBuf.nioBuffer(), System.currentTimeMillis()));
            }
        }
    }
}

