/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.client;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import moe.lasoleil.axochat4j.client.AxochatClientConnection;
import moe.lasoleil.axochat4j.client.UserProfileUtils;
import moe.lasoleil.axochat4j.client.WebSocketConnectionEvent;
import moe.lasoleil.axochat4j.exception.PacketIOException;
import moe.lasoleil.axochat4j.model.AxochatUser;
import moe.lasoleil.axochat4j.packet.AxochatPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SBanUserPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SLoginJWTPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SLoginMojangPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SMessagePacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SPrivateMessagePacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestJWTPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestMojangInfoPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SRequestUserCountPacket;
import moe.lasoleil.axochat4j.packet.c2s.C2SUnbanUserPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CErrorPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CMessagePacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CMojangInfoPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CNewJWTPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CPrivateMessagePacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CSuccessPacket;
import moe.lasoleil.axochat4j.packet.s2c.S2CUserCountPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AxochatClientBootstrap<F> {
    private final F webSocketFactory;
    private final AxochatClientConnection.Factory<F> connectionFactory;
    @Nullable
    private final Handlers.OnConnected onConnected;
    @Nullable
    private final Handlers.OnDisconnected onDisconnected;
    @Nullable
    private final Handlers.OnError onError;
    @Nullable
    private final Handlers.OnUnknownMessageFormat onUnknownMessageFormat;
    @Nullable
    private final Handlers.OnServerUserCount onServerUserCount;
    @Nullable
    private final Handlers.OnServerSuccess onServerSuccess;
    @Nullable
    private final Handlers.OnServerError onServerError;
    @Nullable
    private final Handlers.OnServerMojangInfo onServerMojangInfo;
    @Nullable
    private final Handlers.OnServerNewJWT onServerNewJWT;
    @Nullable
    private final Handlers.OnServerMessage onServerMessage;
    @Nullable
    private final Handlers.OnServerPrivateMessage onServerPrivateMessage;
    private final AxochatClientConnection.Config config;
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private volatile AxochatClientConnection connection = null;

    private AxochatClientBootstrap(@NotNull Builder<F> builder) {
        this.config = AxochatClientConnection.Config.builder().uri(Objects.requireNonNull(builder.uri, "uri == null")).packetAdapter(Objects.requireNonNull(builder.packetAdapter, "packetAdapter == null")).packetHandler(this::packetHandler).webSocketHandler(this::webSocketHandler).build();
        this.connectionFactory = Objects.requireNonNull(builder.connectionFactory, "connectionFactory == null");
        this.webSocketFactory = Objects.requireNonNull(builder.webSocketFactory, "webSocketFactory == null");
        this.onConnected = builder.onConnected;
        this.onDisconnected = builder.onDisconnected;
        this.onError = builder.onError;
        this.onUnknownMessageFormat = builder.onUnknownMessageFormat;
        this.onServerUserCount = builder.onServerUserCount;
        this.onServerSuccess = builder.onServerSuccess;
        this.onServerError = builder.onServerError;
        this.onServerMojangInfo = builder.onServerMojangInfo;
        this.onServerNewJWT = builder.onServerNewJWT;
        this.onServerMessage = builder.onServerMessage;
        this.onServerPrivateMessage = builder.onServerPrivateMessage;
    }

    public final boolean connect() {
        if (this.state.compareAndSet(State.IDLE, State.CONNECTING)) {
            this.connection = this.connectionFactory.create(this.webSocketFactory, this.config);
            return true;
        }
        return false;
    }

    public final boolean disconnect() throws IOException {
        return this.disconnect(true);
    }

    public final boolean disconnect(boolean force) throws IOException {
        if (this.state.compareAndSet(State.CONNECTED, State.DISCONNECTING)) {
            this.connection.close(force);
            return true;
        }
        return false;
    }

    private final boolean send(@NotNull AxochatPacket.C2S packet) throws PacketIOException {
        if (this.state.compareAndSet(State.CONNECTED, State.CONNECTED)) {
            this.connection.send(packet);
            return true;
        }
        return false;
    }

    public final boolean banUser(@NotNull String target) throws PacketIOException {
        return this.send(new C2SBanUserPacket(UserProfileUtils.toUUIDOrError(target)));
    }

    public final boolean unbanUser(@NotNull String target) throws PacketIOException {
        return this.send(new C2SUnbanUserPacket(UserProfileUtils.toUUIDOrError(target)));
    }

    public final boolean requestUserCount() throws PacketIOException {
        return this.send(new C2SRequestUserCountPacket());
    }

    public final boolean requestMojangInfo() throws PacketIOException {
        return this.send(new C2SRequestMojangInfoPacket());
    }

    public final boolean requestJWT() throws PacketIOException {
        return this.send(new C2SRequestJWTPacket());
    }

    public final boolean loginMojang(@NotNull String username, @NotNull UUID uuid, boolean allowMessages) throws PacketIOException {
        return this.send(new C2SLoginMojangPacket(username, uuid, allowMessages));
    }

    public final boolean loginJWT(@NotNull String token, boolean allowMessages) throws PacketIOException {
        return this.send(new C2SLoginJWTPacket(token, allowMessages));
    }

    public final boolean message(@NotNull String content) throws PacketIOException {
        return this.send(new C2SMessagePacket(content));
    }

    public final boolean privateMessage(@NotNull String receiver, @NotNull String content) throws PacketIOException {
        return this.send(new C2SPrivateMessagePacket(receiver, content));
    }

    @NotNull
    public final Builder<F> newBuilder() {
        Builder<F> builder = new Builder<F>(this.connectionFactory);
        builder.uri = this.config.getUri();
        builder.packetAdapter = this.config.getPacketAdapter();
        builder.webSocketFactory = this.webSocketFactory;
        builder.onConnected = this.onConnected;
        builder.onDisconnected = this.onDisconnected;
        builder.onError = this.onError;
        builder.onUnknownMessageFormat = this.onUnknownMessageFormat;
        builder.onServerUserCount = this.onServerUserCount;
        builder.onServerSuccess = this.onServerSuccess;
        builder.onServerError = this.onServerError;
        builder.onServerMojangInfo = this.onServerMojangInfo;
        builder.onServerNewJWT = this.onServerNewJWT;
        builder.onServerMessage = this.onServerMessage;
        builder.onServerPrivateMessage = this.onServerPrivateMessage;
        return builder;
    }

    private void packetHandler(AxochatClientConnection connection, AxochatPacket.S2C packet) {
        if (packet instanceof S2CUserCountPacket) {
            if (this.onServerUserCount != null) {
                this.onServerUserCount.invoke(this, ((S2CUserCountPacket)packet).getConnections(), ((S2CUserCountPacket)packet).getLoggedIn());
            }
        } else if (packet instanceof S2CSuccessPacket) {
            if (this.onServerSuccess != null) {
                this.onServerSuccess.invoke(this, ((S2CSuccessPacket)packet).getReason());
            }
        } else if (packet instanceof S2CErrorPacket) {
            if (this.onServerError != null) {
                this.onServerError.invoke(this, ((S2CErrorPacket)packet).getMessage());
            }
        } else if (packet instanceof S2CMojangInfoPacket) {
            if (this.onServerMojangInfo != null) {
                this.onServerMojangInfo.invoke(this, ((S2CMojangInfoPacket)packet).getSessionHash());
            }
        } else if (packet instanceof S2CNewJWTPacket) {
            if (this.onServerNewJWT != null) {
                this.onServerNewJWT.invoke(this, ((S2CNewJWTPacket)packet).getToken());
            }
        } else if (packet instanceof S2CMessagePacket) {
            if (this.onServerMessage != null) {
                this.onServerMessage.invoke(this, ((S2CMessagePacket)packet).getAuthorInfo(), ((S2CMessagePacket)packet).getContent());
            }
        } else if (packet instanceof S2CPrivateMessagePacket && this.onServerPrivateMessage != null) {
            this.onServerPrivateMessage.invoke(this, ((S2CPrivateMessagePacket)packet).getAuthorInfo(), ((S2CPrivateMessagePacket)packet).getContent());
        }
    }

    private void webSocketHandler(AxochatClientConnection connection, WebSocketConnectionEvent event) {
        if (event instanceof WebSocketConnectionEvent.Connected) {
            this.state.set(State.CONNECTED);
            if (this.onConnected != null) {
                this.onConnected.invoke(this);
            }
        } else if (event instanceof WebSocketConnectionEvent.Disconnected) {
            this.state.set(State.IDLE);
            if (this.onDisconnected != null) {
                this.onDisconnected.invoke(this);
            }
            this.connection = null;
        } else if (event instanceof WebSocketConnectionEvent.ErrorOccurred) {
            if (this.state.compareAndSet(State.CONNECTING, State.IDLE) || this.state.compareAndSet(State.DISCONNECTING, State.IDLE)) {
                this.connection = null;
            }
            if (this.onError != null) {
                this.onError.invoke(this, ((WebSocketConnectionEvent.ErrorOccurred)event).getCause());
            }
        } else if (event instanceof WebSocketConnectionEvent.UnknownMessageFormat && this.onUnknownMessageFormat != null) {
            this.onUnknownMessageFormat.invoke(this, ((WebSocketConnectionEvent.UnknownMessageFormat)event).getRaw(), ((WebSocketConnectionEvent.UnknownMessageFormat)event).getCause());
        }
    }

    public static final class Handlers {
        private Handlers() {
        }

        @FunctionalInterface
        public static interface OnServerPrivateMessage {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull AxochatUser var2, @NotNull String var3);
        }

        @FunctionalInterface
        public static interface OnServerMessage {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull AxochatUser var2, @NotNull String var3);
        }

        @FunctionalInterface
        public static interface OnServerNewJWT {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull String var2);
        }

        @FunctionalInterface
        public static interface OnServerMojangInfo {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull String var2);
        }

        @FunctionalInterface
        public static interface OnServerError {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull String var2);
        }

        @FunctionalInterface
        public static interface OnServerSuccess {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull String var2);
        }

        @FunctionalInterface
        public static interface OnServerUserCount {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, int var2, int var3);
        }

        @FunctionalInterface
        public static interface OnUnknownMessageFormat {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull String var2, @NotNull Throwable var3);
        }

        @FunctionalInterface
        public static interface OnError {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1, @NotNull Throwable var2);
        }

        @FunctionalInterface
        public static interface OnDisconnected {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1);
        }

        @FunctionalInterface
        public static interface OnConnected {
            public void invoke(@NotNull AxochatClientBootstrap<?> var1);
        }
    }

    public static final class Builder<F> {
        URI uri = null;
        AxochatPacket.Adapter packetAdapter = null;
        AxochatClientConnection.Factory<F> connectionFactory = null;
        F webSocketFactory = null;
        Handlers.OnConnected onConnected = null;
        Handlers.OnDisconnected onDisconnected = null;
        Handlers.OnError onError = null;
        Handlers.OnUnknownMessageFormat onUnknownMessageFormat = null;
        Handlers.OnServerUserCount onServerUserCount = null;
        Handlers.OnServerSuccess onServerSuccess = null;
        Handlers.OnServerError onServerError = null;
        Handlers.OnServerMojangInfo onServerMojangInfo = null;
        Handlers.OnServerNewJWT onServerNewJWT = null;
        Handlers.OnServerMessage onServerMessage = null;
        Handlers.OnServerPrivateMessage onServerPrivateMessage = null;

        public Builder(@NotNull AxochatClientConnection.Factory<F> connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @NotNull
        public Builder<F> uri(@NotNull URI uri) {
            this.uri = uri;
            return this;
        }

        @NotNull
        public Builder<F> packetAdapter(@NotNull AxochatPacket.Adapter packetAdapter) {
            this.packetAdapter = packetAdapter;
            return this;
        }

        @NotNull
        public Builder<F> webSocketFactory(@NotNull F webSocketFactory) {
            this.webSocketFactory = webSocketFactory;
            return this;
        }

        @NotNull
        public Builder<F> onConnected(@Nullable Handlers.OnConnected onConnected) {
            this.onConnected = onConnected;
            return this;
        }

        @NotNull
        public Builder<F> onDisconnected(@Nullable Handlers.OnDisconnected onDisconnected) {
            this.onDisconnected = onDisconnected;
            return this;
        }

        @NotNull
        public Builder<F> onError(@Nullable Handlers.OnError onError) {
            this.onError = onError;
            return this;
        }

        @NotNull
        public Builder<F> onUnknownMessageFormat(@Nullable Handlers.OnUnknownMessageFormat onUnknownMessageFormat) {
            this.onUnknownMessageFormat = onUnknownMessageFormat;
            return this;
        }

        @NotNull
        public Builder<F> onServerUserCount(@Nullable Handlers.OnServerUserCount onServerUserCount) {
            this.onServerUserCount = onServerUserCount;
            return this;
        }

        @NotNull
        public Builder<F> onServerSuccess(@Nullable Handlers.OnServerSuccess onServerSuccess) {
            this.onServerSuccess = onServerSuccess;
            return this;
        }

        @NotNull
        public Builder<F> onServerError(@Nullable Handlers.OnServerError onServerError) {
            this.onServerError = onServerError;
            return this;
        }

        @NotNull
        public Builder<F> onServerMojangInfo(@Nullable Handlers.OnServerMojangInfo onServerMojangInfo) {
            this.onServerMojangInfo = onServerMojangInfo;
            return this;
        }

        @NotNull
        public Builder<F> onServerNewJWT(@Nullable Handlers.OnServerNewJWT onServerNewJWT) {
            this.onServerNewJWT = onServerNewJWT;
            return this;
        }

        @NotNull
        public Builder<F> onServerMessage(@Nullable Handlers.OnServerMessage onServerMessage) {
            this.onServerMessage = onServerMessage;
            return this;
        }

        @NotNull
        public Builder<F> onServerPrivateMessage(@Nullable Handlers.OnServerPrivateMessage onServerPrivateMessage) {
            this.onServerPrivateMessage = onServerPrivateMessage;
            return this;
        }

        @NotNull
        public AxochatClientBootstrap<F> build() {
            return new AxochatClientBootstrap(this);
        }
    }

    private static enum State {
        IDLE,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

