/*
 * Decompiled with CFR 0.152.
 */
package moe.lasoleil.axochat4j.client;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import moe.lasoleil.axochat4j.client.AxochatClientConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractAxochatClientConnection<T>
implements AxochatClientConnection {
    protected static final int DEFAULT_SEND_BUFFER_SIZE = 128;
    private final AtomicReference<T> backendRef = new AtomicReference<Object>(null);

    AbstractAxochatClientConnection() {
    }

    public void setBackend(@Nullable T value) {
        this.backendRef.set(value);
    }

    @NotNull
    protected final StringBuilder newSendBuffer() {
        return new StringBuilder(128);
    }

    protected boolean isBackendAvailable(@Nullable T backend) {
        return backend != null;
    }

    @NotNull
    protected abstract String backendUnavailableMessage();

    @NotNull
    protected final T getBackendOrError() {
        T result2 = this.backendRef.get();
        if (this.isBackendAvailable(result2)) {
            return result2;
        }
        throw new IllegalStateException(this.backendUnavailableMessage());
    }

    protected abstract void forceClose() throws IOException;

    @Override
    public final void close(boolean force) throws IOException {
        this.close();
        if (force) {
            this.forceClose();
        }
    }
}

