/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public abstract class RGBComposite
implements Composite {
    protected float extraAlpha;

    public RGBComposite() {
        this(1.0f);
    }

    public RGBComposite(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("RGBComposite: alpha must be between 0 and 1");
        }
        this.extraAlpha = alpha;
    }

    public float getAlpha() {
        return this.extraAlpha;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.extraAlpha);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RGBComposite)) {
            return false;
        }
        RGBComposite c2 = (RGBComposite)o;
        return this.extraAlpha == c2.extraAlpha;
    }

    public abstract /* synthetic */ CompositeContext createContext(ColorModel var1, ColorModel var2, RenderingHints var3);

    public static abstract class RGBCompositeContext
    implements CompositeContext {
        private float alpha;
        private ColorModel srcColorModel;
        private ColorModel dstColorModel;

        public RGBCompositeContext(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            this.alpha = alpha;
            this.srcColorModel = srcColorModel;
            this.dstColorModel = dstColorModel;
        }

        public void dispose() {
        }

        static int multiply255(int a2, int b2) {
            int t = a2 * b2 + 128;
            return (t >> 8) + t >> 8;
        }

        static int clamp(int a2) {
            return a2 < 0 ? 0 : (a2 > 255 ? 255 : a2);
        }

        public abstract void composeRGB(int[] var1, int[] var2, float var3);

        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            float alpha = this.alpha;
            int[] srcPix = null;
            int[] dstPix = null;
            int x = dstOut.getMinX();
            int w = dstOut.getWidth();
            int y0 = dstOut.getMinY();
            int y1 = y0 + dstOut.getHeight();
            for (int y = y0; y < y1; ++y) {
                srcPix = src.getPixels(x, y, w, 1, srcPix);
                dstPix = dstIn.getPixels(x, y, w, 1, dstPix);
                this.composeRGB(srcPix, dstPix, alpha);
                dstOut.setPixels(x, y, w, 1, dstPix);
            }
        }
    }
}

