/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.StringUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class FlatToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.createSharedUI(FlatToolTipUI.class, FlatToolTipUI::new);
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        FlatHTML.updateRendererCSSFontBaseSize(c2);
    }

    @Override
    protected void installListeners(JComponent c2) {
        super.installListeners(c2);
        c2.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent c2) {
        super.uninstallListeners(c2);
        c2.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        FlatHTML.propertyChange(e2);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        String text = ((JToolTip)c2).getTipText();
        if (text == null || text.isEmpty()) {
            return new Dimension();
        }
        if (this.isMultiLine(c2)) {
            FontMetrics fm = c2.getFontMetrics(c2.getFont());
            Insets insets = c2.getInsets();
            List<String> lines = StringUtils.split(((JToolTip)c2).getTipText(), '\n');
            int width = 0;
            int height = fm.getHeight() * Math.max(lines.size(), 1);
            for (String line : lines) {
                width = Math.max(width, SwingUtilities.computeStringWidth(fm, line));
            }
            return new Dimension(insets.left + width + insets.right + 6, insets.top + height + insets.bottom);
        }
        return super.getPreferredSize(c2);
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        if (this.isMultiLine(c2)) {
            FontMetrics fm = c2.getFontMetrics(c2.getFont());
            Insets insets = c2.getInsets();
            g.setColor(c2.getForeground());
            List<String> lines = StringUtils.split(((JToolTip)c2).getTipText(), '\n');
            int x = insets.left + 3;
            int x2 = c2.getWidth() - insets.right - 3;
            int y = insets.top - fm.getDescent();
            int lineHeight = fm.getHeight();
            JComponent comp = ((JToolTip)c2).getComponent();
            boolean leftToRight = (comp != null ? comp : c2).getComponentOrientation().isLeftToRight();
            for (String line : lines) {
                FlatUIUtils.drawString(c2, g, line, leftToRight ? x : x2 - SwingUtilities.computeStringWidth(fm, line), y += lineHeight);
            }
        } else {
            super.paint(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g), c2);
        }
    }

    private boolean isMultiLine(JComponent c2) {
        String text = ((JToolTip)c2).getTipText();
        return c2.getClientProperty("html") == null && text != null && text.indexOf(10) >= 0;
    }
}

