/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class FlatToolBarSeparatorUI
extends BasicToolBarSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    private static final int LINE_WIDTH = 1;
    @FlatStylingSupport.Styleable
    protected int separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.canUseSharedUI(c2) ? FlatUIUtils.createSharedUI(FlatToolBarSeparatorUI.class, () -> new FlatToolBarSeparatorUI(true)) : new FlatToolBarSeparatorUI(false);
    }

    protected FlatToolBarSeparatorUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.installStyle((JSeparator)c2);
    }

    @Override
    protected void installDefaults(JSeparator c2) {
        super.installDefaults(c2);
        if (!this.defaults_initialized) {
            this.separatorWidth = UIManager.getInt("ToolBar.separatorWidth");
            this.separatorColor = UIManager.getColor("ToolBar.separatorColor");
            this.defaults_initialized = true;
        }
        c2.setAlignmentX(0.0f);
    }

    @Override
    protected void uninstallDefaults(JSeparator s) {
        super.uninstallDefaults(s);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator s) {
        super.installListeners(s);
        s.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator s) {
        super.uninstallListeners(s);
        s.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        switch (e2.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JSeparator s = (JSeparator)e2.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(s)) {
                    s.updateUI();
                } else {
                    this.installStyle(s);
                }
                s.revalidate();
                HiDPIUtils.repaint(s);
            }
        }
    }

    protected void installStyle(JSeparator s) {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(s, "ToolBarSeparator"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = ((JToolBar.Separator)c2).getSeparatorSize();
        if (size != null) {
            return UIScale.scale(size);
        }
        int separatorWidth = this.separatorWidth;
        FlatToolBarUI toolBarUI = this.getToolBarUI(c2);
        if (toolBarUI != null && toolBarUI.separatorWidth != null) {
            separatorWidth = toolBarUI.separatorWidth;
        }
        int sepWidth = UIScale.scale((separatorWidth - 1) / 2) * 2 + UIScale.scale(1);
        boolean vertical = this.isVertical(c2);
        return new Dimension(vertical ? sepWidth : 0, vertical ? 0 : sepWidth);
    }

    @Override
    public Dimension getMaximumSize(JComponent c2) {
        Dimension size = this.getPreferredSize(c2);
        if (this.isVertical(c2)) {
            return new Dimension(size.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, size.height);
    }

    @Override
    public void paint(Graphics g, JComponent c2) {
        int width = c2.getWidth();
        int height = c2.getHeight();
        float lineWidth = UIScale.scale(1.0f);
        float offset = UIScale.scale(2.0f);
        Color separatorColor = this.separatorColor;
        FlatToolBarUI toolBarUI = this.getToolBarUI(c2);
        if (toolBarUI != null && toolBarUI.separatorColor != null) {
            separatorColor = toolBarUI.separatorColor;
        }
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g);
        g.setColor(separatorColor);
        if (this.isVertical(c2)) {
            ((Graphics2D)g).fill(new Rectangle2D.Float(Math.round(((float)width - lineWidth) / 2.0f), offset, lineWidth, (float)height - offset * 2.0f));
        } else {
            ((Graphics2D)g).fill(new Rectangle2D.Float(offset, Math.round(((float)height - lineWidth) / 2.0f), (float)width - offset * 2.0f, lineWidth));
        }
        FlatUIUtils.resetRenderingHints(g, oldRenderingHints);
    }

    private boolean isVertical(JComponent c2) {
        return ((JToolBar.Separator)c2).getOrientation() == 1;
    }

    private FlatToolBarUI getToolBarUI(JComponent c2) {
        Container parent = c2.getParent();
        return parent instanceof JToolBar && ((JToolBar)parent).getUI() instanceof FlatToolBarUI ? (FlatToolBarUI)((JToolBar)parent).getUI() : null;
    }
}

