/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatSpinnerUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.SpinnerUI;

public class FlatRoundBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("Component.arc");
    @FlatStylingSupport.Styleable
    protected Boolean roundRect;

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        if (this.isMacStyleSpinner(c2)) {
            int macStyleButtonsWidth = ((FlatSpinnerUI)((JSpinner)c2).getUI()).getMacStyleButtonsWidth();
            width -= macStyleButtonsWidth;
            if (!c2.getComponentOrientation().isLeftToRight()) {
                x += macStyleButtonsWidth;
            }
        }
        super.paintBorder(c2, g, x, y, width, height);
    }

    @Override
    protected int getArc(Component c2) {
        if (this.isCellEditor(c2)) {
            return 0;
        }
        Boolean roundRect = FlatUIUtils.isRoundRect(c2);
        if (roundRect == null) {
            roundRect = this.roundRect;
        }
        return roundRect != null ? (roundRect.booleanValue() ? Short.MAX_VALUE : 0) : (this.isMacStyleSpinner(c2) ? 0 : this.arc);
    }

    private boolean isMacStyleSpinner(Component c2) {
        SpinnerUI ui;
        if (c2 instanceof JSpinner && (ui = ((JSpinner)c2).getUI()) instanceof FlatSpinnerUI) {
            return ((FlatSpinnerUI)ui).isMacStyle();
        }
        return false;
    }
}

