/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class FlatCheckBoxMenuItemIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected Color checkmarkColor = UIManager.getColor("CheckBoxMenuItem.icon.checkmarkColor");
    @FlatStylingSupport.Styleable
    protected Color disabledCheckmarkColor = UIManager.getColor("CheckBoxMenuItem.icon.disabledCheckmarkColor");
    @FlatStylingSupport.Styleable
    protected Color selectionForeground = UIManager.getColor("MenuItem.selectionForeground");

    public FlatCheckBoxMenuItemIcon() {
        super(15, 15, null);
    }

    public Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    public Object getStyleableValue(String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    protected void paintIcon(Component c2, Graphics2D g2) {
        boolean selected;
        boolean bl = selected = c2 instanceof AbstractButton && ((AbstractButton)c2).isSelected();
        if (selected) {
            g2.setColor(this.getCheckmarkColor(c2));
            this.paintCheckmark(g2);
        }
    }

    protected void paintCheckmark(Graphics2D g2) {
        Path2D.Float path2 = new Path2D.Float(1, 3);
        path2.moveTo(4.5f, 7.5f);
        path2.lineTo(6.6f, 10.0f);
        path2.lineTo(11.25f, 3.5f);
        g2.setStroke(new BasicStroke(1.9f, 1, 1));
        g2.draw(path2);
    }

    protected Color getCheckmarkColor(Component c2) {
        if (c2 instanceof JMenuItem && ((JMenuItem)c2).isArmed() && !this.isUnderlineSelection()) {
            return this.selectionForeground;
        }
        return c2.isEnabled() ? this.checkmarkColor : this.disabledCheckmarkColor;
    }

    protected boolean isUnderlineSelection() {
        return "underline".equals(UIManager.getString("MenuItem.selectionType"));
    }
}

