import com.cleanroommc.groovyscript.helper.ingredient.OreDictIngredient

import loader.hooks.P2PConvertor

import static gregtech.api.GTValues.*

import static util.GroovyUtil.*

/* -------------------------------------------------------------------------- */
def fluix_crystal = item('appliedenergistics2:material', 7)
def fluix_dust = item('appliedenergistics2:material', 8)
def fluix_pearl = item('appliedenergistics2:material', 9)
def logic_processor = item('appliedenergistics2:material', 22)
def calculation_processor = item('appliedenergistics2:material', 23)
def engineering_processor = item('appliedenergistics2:material', 24)
def basic_card = item('appliedenergistics2:material', 25)
def advanced_card = item('appliedenergistics2:material', 28)
def storage_component_spatial_2 = item('appliedenergistics2:material', 32)
def storage_component_spatial_16 = item('appliedenergistics2:material', 33)
def storage_component_spatial_128 = item('appliedenergistics2:material', 34)
def storage_component_1k = item('appliedenergistics2:material', 35)
def storage_component_4k = item('appliedenergistics2:material', 36)
def storage_component_16k = item('appliedenergistics2:material', 37)
def storage_component_64k = item('appliedenergistics2:material', 38)
def empty_storage_cell = item('appliedenergistics2:material', 39)
def wireless_receiver = item('appliedenergistics2:material', 41)
def wireless_booster = item('appliedenergistics2:material', 42)
def formation_core = item('appliedenergistics2:material', 43)
def annihilation_core = item('appliedenergistics2:material', 44)
def blank_pattern = item('appliedenergistics2:material', 52)
def storage_component_fluid_1k = item('appliedenergistics2:material', 54)
def storage_component_fluid_4k = item('appliedenergistics2:material', 55)
def storage_component_fluid_16k = item('appliedenergistics2:material', 56)
def storage_component_fluid_64k = item('appliedenergistics2:material', 57)
def quantum_link_card = item('appliedenergistics2:material', 59)
def magnet_card = item('appliedenergistics2:material', 60)

def glass_cable = item('appliedenergistics2:part', 16)
def dense_cable = item('appliedenergistics2:part', 76)
def quartz_fiber = item('appliedenergistics2:part', 140)
def storage_monitor = item('appliedenergistics2:part', 400)

def quartz_glass = item('appliedenergistics2:quartz_glass')
def vibrant_quartz_glass = item('appliedenergistics2:quartz_vibrant_glass')

/* -------------------------------------------------------------------------- */
def alloy_smelter = recipemap('alloy_smelter')
def assembly_line = recipemap('assembly_line')
def assembler = recipemap('assembler')
def chemical_bath = recipemap('chemical_bath')
def circuit_assembler = recipemap('circuit_assembler')
def compressor = recipemap('compressor')
def cutter = recipemap('cutter')
def forge_hammer = recipemap('forge_hammer')
def forming_press = recipemap('forming_press')
def macerator = recipemap('macerator')
def mixer = recipemap('mixer')
def laser_engraver = recipemap('laser_engraver')
def packer = recipemap('packer')
def wiremill = recipemap('wiremill')

/* -------------------------- Applied Energistics 2 ------------------------- */

// Certus Quartz Block
crafting.removeByOutput(item('appliedenergistics2:quartz_block'))
crafting.removeByOutput(item('appliedenergistics2:quartz_pillar'))
crafting.removeByOutput(item('appliedenergistics2:chiseled_quartz_block'))

// Fluix Crystal
mixer.recipeBuilder()
    .circuitMeta(4)
    .inputs(ore('dustCertusQuartz'))
    .inputs(ore('dustNetherQuartz'))
    .inputs(ore('dustRedstone'))
    .fluidInputs(fluid('water') * 100)
    .outputs(fluix_crystal * 4)
    .EUt(VA[LV])
    .duration(2 * SECOND)
    .buildAndRegister()

mixer.recipeBuilder()
    .circuitMeta(4)
    .inputs(ore('dustCertusQuartz'))
    .inputs(ore('dustNetherQuartz'))
    .inputs(ore('dustRedstone'))
    .fluidInputs(fluid('distilled_water') * 100)
    .outputs(fluix_crystal * 4)
    .EUt(VA[LV])
    .duration(2 * SECOND)
    .buildAndRegister()

// Fluix Block
compressor.recipeBuilder()
    .inputs(fluix_crystal * 4)
    .outputs(item('appliedenergistics2:fluix_block'))
    .EUt(2) // ULV
    .duration(12 * TICK)
    .buildAndRegister()

forge_hammer.recipeBuilder()
    .inputs(item('appliedenergistics2:fluix_block'))
    .outputs(fluix_crystal * 4)
    .EUt(24) // LV
    .duration(16 * TICK)
    .buildAndRegister()

// Fluix Dust
crafting.shapedBuilder()
    .name(resource('gtlite:mortar_grind_fluix_crystal'))
    .shape(' C ',
           ' M ',
           '   ')
    .key('C', fluix_crystal)
    .key('M', ore('toolMortar'))
    .output(fluix_dust)
    .register()

macerator.recipeBuilder()
    .inputs(fluix_crystal)
    .outputs(fluix_dust)
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

macerator.recipeBuilder()
    .inputs(item('appliedenergistics2:fluix_block'))
    .outputs(fluix_dust * 4)
    .EUt(VA[ULV])
    .duration(8 * TICK)
    .buildAndRegister()

// Fluix Slab
cutter.recipeBuilder()
    .inputs(item('appliedenergistics2:fluix_block'))
    .outputs(item('appliedenergistics2:fluix_slab') * 2)
    .EUt(VA[ULV])
    .duration(15 * TICK)
    .buildAndRegister()

// Logic Processor
mods.ae2.inscriber.removeByOutput(logic_processor)
circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1104)) // Engraved Ruby Chip
    .inputs(metaitem('circuit_board.basic'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltGold') * 4)
    .outputs(logic_processor * 8) // Logic processor
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1104)) // Engraved Ruby Chip
    .inputs(metaitem('circuit_board.good'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltElectrum') * 4)
    .outputs(logic_processor * 16)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// Calculation Processor
mods.ae2.inscriber.removeByOutput(calculation_processor)
circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1105)) // Engraved Sapphire Chip
    .inputs(metaitem('circuit_board.basic'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltGold') * 4)
    .outputs(calculation_processor * 8) 
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1105)) // Engraved Sapphire Chip
    .inputs(metaitem('circuit_board.good'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltElectrum') * 4)
    .outputs(calculation_processor * 16)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// Engineering Processor
mods.ae2.inscriber.removeByOutput(engineering_processor)
circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1103)) // Engraved Diamond Chip
    .inputs(metaitem('circuit_board.basic'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltGold') * 4)
    .outputs(engineering_processor * 8)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

circuit_assembler.recipeBuilder()
    .inputs(item('gtlitecore:gtlite_meta_item', 1103)) // Engraved Diamond Chip
    .inputs(metaitem('circuit_board.good'))
    .inputs(ore('wireGtSingleRedAlloy') * 2)
    .inputs(ore('boltElectrum') * 4)
    .outputs(engineering_processor * 16)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// Quartz Glass
crafting.removeByOutput(quartz_glass)
alloy_smelter.recipeBuilder()
    .inputs(item('minecraft:glass'))
    .inputs(ore('dustQuartzite'))
    .outputs(quartz_glass * 2)
    .EUt(VA[LV])
    .duration(4 * SECOND)
    .buildAndRegister()

alloy_smelter.recipeBuilder()
    .inputs(item('minecraft:glass'))
    .inputs(ore('dustNetherQuartz'))
    .outputs(quartz_glass * 2)
    .EUt(VA[LV])
    .duration(4 * SECOND)
    .buildAndRegister()

alloy_smelter.recipeBuilder()
    .inputs(item('minecraft:glass'))
    .inputs(ore('dustCertusQuartz'))
    .outputs(quartz_glass * 2)
    .EUt(VA[LV])
    .duration(4 * SECOND)
    .buildAndRegister()

// Vibrant Quartz Glass
crafting.removeByOutput(vibrant_quartz_glass)
alloy_smelter.recipeBuilder()
    .inputs(quartz_glass)
    .inputs(ore('dustGlowstone'))
    .outputs(vibrant_quartz_glass)
    .EUt(VA[LV])
    .duration(2 * SECOND)
    .buildAndRegister()

// Fluix Pearl
crafting.removeByOutput(fluix_pearl)
alloy_smelter.recipeBuilder()
    .inputs(ore('gemEnderPearl'))
    .inputs(fluix_crystal)
    .outputs(fluix_pearl * 2)
    .EUt(VA[LV])
    .duration(4 * SECOND)
    .buildAndRegister()

alloy_smelter.recipeBuilder()
    .inputs(ore('gemEnderPearl'))
    .inputs(fluix_dust)
    .outputs(fluix_pearl * 2)
    .EUt(VA[LV])
    .duration(4 * SECOND)
    .buildAndRegister()

// Formation core
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:materials/formationcore'))
    .replaceByName()
    .shape('   ',
           'QDX',
           '   ')
    .key('Q', ore('gemCertusQuartz'))
    .key('D', fluix_dust)
    .key('X', logic_processor)
    .output(formation_core * 32)
    .register()

assembler.recipeBuilder()
    .circuitMeta(4)
    .inputs(ore('gemCertusQuartz'))
    .inputs(fluix_dust)
    .inputs(logic_processor)
    .outputs(formation_core * 64)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

// Annihilation Core
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:materials/annihilationcore'))
    .replaceByName()
    .shape('   ',
           'QDX',
           '   ')
    .key('Q', ore('gemNetherQuartz'))
    .key('D', fluix_dust)
    .key('X', logic_processor)
    .output(annihilation_core * 32)
    .register()

assembler.recipeBuilder()
    .circuitMeta(5)
    .inputs(ore('gemNetherQuartz'))
    .inputs(fluix_dust)
    .inputs(logic_processor)
    .outputs(annihilation_core * 64)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

// ME Storage Cell
crafting.removeByOutput(empty_storage_cell)
crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_1a'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', item('minecraft:glass_pane'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateSteel'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_2a'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', item('minecraft:glass_pane'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateAluminium'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 32)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_3a'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', item('minecraft:glass_pane'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateStainlessSteel'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 64)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_1b'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', ore('plateGlass'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateSteel'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_2b'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', ore('plateGlass'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateAluminium'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 32)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:empty_storage_cell_3b'))
    .shape('HAS',
           'BGB',
           'SPD')
    .key('G', ore('plateGlass'))
    .key('A', ore('plateCertusQuartz'))
    .key('P', ore('plateStainlessSteel'))
    .key('B', ore('plateTin'))
    .key('S', ore('screwIron'))
    .key('H', ore('toolHammer'))
    .key('D', ore('toolScrewdriver'))
    .output(empty_storage_cell * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateSteel'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 16)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateAluminium'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 32)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder() 
    .circuitMeta(1)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateStainlessSteel'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 64)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder() 
    .circuitMeta(1)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateSteel'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 16)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateAluminium'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 32)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateCertusQuartz'))
    .inputs(ore('plateStainlessSteel'))
    .inputs(ore('plateTin') * 2)
    .outputs(empty_storage_cell * 64)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

// 1k ME Item Storage Component
crafting.removeByOutput(storage_component_1k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.coated'))
    .inputs(logic_processor)
    .inputs(ore('foilGold') * 4)
    .inputs(ore('boltIron') * 2)
    .outputs(storage_component_1k * 16)
    .EUt(VA[LV])
    .duration(5 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// 1k ME Item Storage Cell
crafting.remove('appliedenergistics2:network/cells/storage_cell_1k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_1k)
    .outputs(item('appliedenergistics2:storage_cell_1k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:storage_cell_1k'))
    .outputs(storage_component_1k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 1k ME Fluid Storage Component
crafting.removeByOutput(storage_component_fluid_1k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.coated'))
    .inputs(calculation_processor)
    .inputs(ore('foilSilver') * 4)
    .inputs(ore('boltIron') * 2)
    .outputs(storage_component_fluid_1k * 16)
    .EUt(VA[LV])
    .duration(5 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// 1k ME Fluid Storage Cell
crafting.remove('appliedenergistics2:network/cells/fluid_storage_cell_1k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_fluid_1k)
    .outputs(item('appliedenergistics2:fluid_storage_cell_1k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:fluid_storage_cell_1k'))
    .outputs(storage_component_fluid_1k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 4k ME Item Storage Component
crafting.removeByOutput(storage_component_4k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.coated'))
    .inputs(storage_component_1k * 4)
    .inputs(engineering_processor)
    .inputs(ore('wireGtSingleLead') * 2)
    .outputs(storage_component_4k * 16)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// 4k ME Item Storage Cell
crafting.remove('appliedenergistics2:network/cells/storage_cell_4k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_4k)
    .outputs(item('appliedenergistics2:storage_cell_4k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:storage_cell_4k'))
    .outputs(storage_component_4k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 4k ME Fluid Storage Component
crafting.removeByOutput(storage_component_fluid_4k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.coated'))
    .inputs(storage_component_fluid_1k * 4)
    .inputs(engineering_processor)
    .inputs(ore('wireGtSingleLead') * 2)
    .outputs(storage_component_fluid_4k * 16)
    .EUt(VA[LV])
    .duration(10 * SECOND)
    .solderMultiplier(1)
    .buildAndRegister()

// 4k ME Fluid Storage Cell
crafting.remove('appliedenergistics2:network/cells/fluid_storage_cell_4k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_fluid_4k)
    .outputs(item('appliedenergistics2:fluid_storage_cell_4k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:fluid_storage_cell_4k'))
    .outputs(storage_component_fluid_4k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 16k ME Item Storage Component
crafting.removeByOutput(storage_component_16k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.phenolic'))
    .inputs(storage_component_4k * 4)
    .inputs(ore('circuitUlv'))
    .inputs(ore('wireGtSingleAnnealedCopper') * 2)
    .outputs(storage_component_16k * 16)
    .EUt(VA[LV])
    .duration(15 * SECOND)
    .solderMultiplier(2)
    .buildAndRegister()

// 16k ME Item Storage Cell
crafting.remove('appliedenergistics2:network/cells/storage_cell_16k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_16k)
    .outputs(item('appliedenergistics2:storage_cell_16k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:storage_cell_16k'))
    .outputs(storage_component_16k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// A little fix for 16k ME Item Storage Cell shapeless recipe.
crafting.remove('appliedenergistics2:network/cells/storage_cell_16k_storage')
crafting.shapelessBuilder()
    .name('appliedenergistics2:network/cells/storage_cell_16k_storage')
    .replaceByName()
    .input([empty_storage_cell,
            storage_component_16k])
    .output(item('appliedenergistics2:storage_cell_16k'))
    .register()

// 16k ME Fluid Storage Component
crafting.removeByOutput(storage_component_fluid_16k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.phenolic'))
    .inputs(storage_component_fluid_4k * 4)
    .inputs(ore('circuitUlv'))
    .inputs(ore('wireGtSingleAnnealedCopper') * 2)
    .outputs(storage_component_fluid_16k * 16)
    .EUt(VA[LV])
    .duration(15 * SECOND)
    .solderMultiplier(2)
    .buildAndRegister()

// 16k ME Fluid Storage Cell
crafting.remove('appliedenergistics2:network/cells/fluid_storage_cell_16k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_fluid_16k)
    .outputs(item('appliedenergistics2:fluid_storage_cell_16k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:fluid_storage_cell_16k'))
    .outputs(storage_component_fluid_16k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 64k ME Item Storage Component
crafting.removeByOutput(storage_component_64k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.phenolic'))
    .inputs(storage_component_16k * 4)
    .inputs(ore('circuitLv'))
    .inputs(ore('wireGtSingleGold') * 2)
    .outputs(storage_component_64k * 16)
    .EUt(VA[MV])
    .duration(20 * SECOND)
    .solderMultiplier(2)
    .buildAndRegister()

// 64k ME Item Storage Cell
crafting.remove('appliedenergistics2:network/cells/storage_cell_64k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_64k)
    .outputs(item('appliedenergistics2:storage_cell_64k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:storage_cell_64k'))
    .outputs(storage_component_64k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 64k ME Fluid Storage Component
crafting.removeByOutput(storage_component_fluid_64k)
circuit_assembler.recipeBuilder()
    .inputs(metaitem('board.phenolic'))
    .inputs(storage_component_fluid_16k * 4)
    .inputs(ore('circuitLv'))
    .inputs(ore('wireGtSingleGold') * 2)
    .outputs(storage_component_fluid_64k * 16)
    .EUt(VA[MV])
    .duration(20 * SECOND)
    .solderMultiplier(2)
    .buildAndRegister()

// 64k ME Fluid Storage Cell
crafting.remove('appliedenergistics2:network/cells/fluid_storage_cell_64k')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_fluid_64k)
    .outputs(item('appliedenergistics2:fluid_storage_cell_64k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:fluid_storage_cell_64k'))
    .outputs(storage_component_fluid_64k)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// View Cell
crafting.remove('appliedenergistics2:network/cells/view_cell')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(ore('gemCertusQuartz'))
    .outputs(item('appliedenergistics2:view_cell'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:view_cell'))
    .outputs(metaitem('gemCertusQuartz'))
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 2^3 Spatial Storage Component
crafting.removeByOutput(storage_component_spatial_2)
laser_engraver.recipeBuilder()
    .notConsumable(ore('craftingLensPurple'))
    .inputs(engineering_processor)
    .inputs(fluix_pearl)
    .inputs(ore('wireFineRoseGold') * 4)
    .outputs(storage_component_spatial_2 * 16)
    .EUt(VA[LV])
    .duration(5 * SECOND)
    .buildAndRegister()

// 2^3 Spatial Storage Cell
crafting.remove('appliedenergistics2:network/cells/spatial_storage_cell_2_cubed')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_spatial_2)
    .outputs(item('appliedenergistics2:spatial_storage_cell_2_cubed'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:spatial_storage_cell_2_cubed'))
    .outputs(storage_component_spatial_2)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 16^3 Spatial Storage Component
crafting.removeByOutput(storage_component_spatial_16)
laser_engraver.recipeBuilder()
    .notConsumable(ore('craftingLensPurple'))
    .inputs(storage_component_spatial_2)
    .inputs(logic_processor)
    .inputs(ore('foilSterlingSilver') * 4)
    .outputs(storage_component_spatial_16 * 16)
    .EUt(VA[LV])
    .duration(5 * SECOND)
    .buildAndRegister()

// 16^3 Spatial Storage Cell
crafting.remove('appliedenergistics2:network/cells/spatial_storage_cell_16_cubed')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_spatial_16)
    .outputs(item('appliedenergistics2:spatial_storage_cell_16_cubed'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:spatial_storage_cell_16_cubed'))
    .outputs(storage_component_spatial_16)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 128^3 Spatial Storage Component
crafting.removeByOutput(storage_component_spatial_128)
laser_engraver.recipeBuilder()
    .notConsumable(ore('craftingLensPurple'))
    .inputs(storage_component_spatial_16)
    .inputs(calculation_processor)
    .inputs(ore('springSmallCobaltBrass') * 2)
    .outputs(storage_component_spatial_128 * 16)
    .EUt(VA[LV])
    .duration(5 * SECOND)
    .buildAndRegister()

// 128^3 Spatial Storage Cell
crafting.remove('appliedenergistics2:network/cells/spatial_storage_cell_128_cubed')
packer.recipeBuilder()
    .inputs(empty_storage_cell)
    .inputs(storage_component_spatial_128)
    .outputs(item('appliedenergistics2:spatial_storage_cell_128_cubed'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:spatial_storage_cell_128_cubed'))
    .outputs(storage_component_spatial_128)
    .outputs(empty_storage_cell)
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// Quartz Fiber
crafting.removeByOutput(quartz_fiber)
crafting.shapelessBuilder()
    .name(resource('gtlite:fine_wire_quartz'))
    .input([ore('toolWireCutter'), ore('gemNetherQuartz')])
    .output(quartz_fiber * 8)
    .register()

wiremill.recipeBuilder()
    .circuitMeta(3)
    .inputs(ore('gemNetherQuartz'))
    .outputs(quartz_fiber * 8)
    .EUt(VA[ULV])
    .duration(12 * TICK)
    .buildAndRegister()

// Wireless Receiver
crafting.removeByOutput(wireless_receiver)
crafting.shapedBuilder()
    .name(resource('gtlite:wireless_receiver_1'))
    .shape('dFw',
           'PWP',
           ' P ')
    .key('F', fluix_pearl)
    .key('W', quartz_fiber)
    .key('P', ore('plateIron'))
    .key('w', ore('toolWrench'))
    .key('d', ore('toolScrewdriver'))
    .output(wireless_receiver * 2)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:wireless_receiver_2'))
    .shape('dFw',
           'PWP',
           ' P ')
    .key('F', fluix_pearl)
    .key('W', quartz_fiber)
    .key('P', ore('plateAluminium'))
    .key('w', ore('toolWrench'))
    .key('d', ore('toolScrewdriver'))
    .output(wireless_receiver * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:wireless_receiver_3'))
    .shape('dFw',
           'PWP',
           ' P ')
    .key('F', fluix_pearl)
    .key('W', quartz_fiber)
    .key('P', ore('plateStainlessSteel'))
    .key('w', ore('toolWrench'))
    .key('d', ore('toolScrewdriver'))
    .output(wireless_receiver * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:wireless_receiver_4'))
    .shape('dFw',
           'PWP',
           ' P ')
    .key('F', fluix_pearl)
    .key('W', quartz_fiber)
    .key('P', ore('plateTitanium'))
    .key('w', ore('toolWrench'))
    .key('d', ore('toolScrewdriver'))
    .output(wireless_receiver * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(quartz_fiber)
    .inputs(fluix_pearl)
    .inputs(ore('plateIron') * 3)
    .outputs(wireless_receiver * 2)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(quartz_fiber)
    .inputs(fluix_pearl)
    .inputs(ore('plateAluminium') * 3)
    .outputs(wireless_receiver * 8)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(quartz_fiber)
    .inputs(fluix_pearl)
    .inputs(ore('plateStainlessSteel') * 3)
    .outputs(wireless_receiver * 16)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(quartz_fiber)
    .inputs(fluix_pearl)
    .inputs(ore('plateTitanium') * 3)
    .outputs(wireless_receiver * 64)
    .EUt(VA[LV])
    .duration(10 * TICK)
    .buildAndRegister()

// ME Interface
crafting.remove('appliedenergistics2:network/blocks/interfaces_interface')
crafting.shapedBuilder()
    .name(resource('gtlite:me_interface_1'))
    .shape('PCP',
           'AHF',
           'PCP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.lv'))
    .key('F', formation_core)
    .key('P', ore('plateSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:interface'))
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_interface_2'))
    .shape('PCP',
           'AHF',
           'PCP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.mv'))
    .key('F', formation_core)
    .key('P', ore('plateAluminium'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:interface') * 2)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_interface_3'))
    .shape('PCP',
           'AHF',
           'PCP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.hv'))
    .key('F', formation_core)
    .key('P', ore('plateStainlessSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:interface') * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_interface_4'))
    .shape('PCP',
           'AHF',
           'PCP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.ev'))
    .key('F', formation_core)
    .key('P', ore('plateTitanium'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:interface') * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_interface_5'))
    .shape('PCP',
           'AHF',
           'PCP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.iv'))
    .key('F', formation_core)
    .key('P', ore('plateTungstenSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:interface') * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(10)
    .inputs(metaitem('hull.lv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:interface'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(10)
    .inputs(metaitem('hull.mv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateAluminium') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:interface') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(10)
    .inputs(metaitem('hull.hv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateStainlessSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:interface') * 4)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(10)
    .inputs(metaitem('hull.ev'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTitanium') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:interface') * 16)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(10)
    .inputs(metaitem('hull.iv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTungstenSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:interface') * 64)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Fluid Interface
crafting.remove('appliedenergistics2:network/blocks/fluid_interfaces_interface')
crafting.shapedBuilder()
    .name(resource('gtlite:me_fluid_interface_1'))
    .shape('PAP',
           'CHC',
           'PFP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.lv'))
    .key('F', formation_core)
    .key('P', ore('plateSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:fluid_interface'))
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_fluid_interface_2'))
    .shape('PAP',
           'CHC',
           'PFP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.mv'))
    .key('F', formation_core)
    .key('P', ore('plateAluminium'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:fluid_interface') * 2)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_fluid_interface_3'))
    .shape('PAP',
           'CHC',
           'PFP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.hv'))
    .key('F', formation_core)
    .key('P', ore('plateStainlessSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:fluid_interface') * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_fluid_interface_4'))
    .shape('PAP',
           'CHC',
           'PFP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.ev'))
    .key('F', formation_core)
    .key('P', ore('plateTitanium'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:fluid_interface') * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:me_fluid_interface_5'))
    .shape('PAP',
           'CHC',
           'PFP')
    .key('A', annihilation_core)
    .key('H', metaitem('hull.iv'))
    .key('F', formation_core)
    .key('P', ore('plateTungstenSteel'))
    .key('C', glass_cable)
    .output(item('appliedenergistics2:fluid_interface') * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(11)
    .inputs(metaitem('hull.lv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:fluid_interface'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(11)
    .inputs(metaitem('hull.mv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateAluminium') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:fluid_interface') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(11)
    .inputs(metaitem('hull.hv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateStainlessSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:fluid_interface') * 4)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(11)
    .inputs(metaitem('hull.ev'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTitanium') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:fluid_interface') * 16)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(11)
    .inputs(metaitem('hull.iv'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTungstenSteel') * 4)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:fluid_interface') * 64)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Wireless Access Point
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/wireless_access_point'))
    .replaceByName()
    .shape(' R ',
           'EXE',
           'DCW')
    .key('C', glass_cable)
    .key('R', wireless_receiver)
    .key('E', ore('screwSteel'))
    .key('W', ore('toolWrench'))
    .key('D', ore('toolScrewdriver'))
    .key('X', calculation_processor)
    .output(item('appliedenergistics2:wireless_access_point'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(1)
    .inputs(wireless_receiver)
    .inputs(calculation_processor)
    .inputs(glass_cable)
    .inputs(ore('screwSteel') * 2)
    .outputs(item('appliedenergistics2:wireless_access_point'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Security Station
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/security_station'))
    .replaceByName()
    .shape('PSP',
           'WCW',
           'PXP')
    .key('S', quartz_glass)
    .key('C', item('appliedenergistics2:chest'))
    .key('X', engineering_processor)
    .key('P', ore('plateSteel'))
    .key('W', glass_cable)
    .output(item('appliedenergistics2:security_station'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(7)
    .inputs(item('appliedenergistics2:chest'))
    .inputs(ore('plateSteel') * 4)
    .inputs(engineering_processor)
    .inputs(quartz_glass)
    .inputs(glass_cable * 2)
    .outputs(item('appliedenergistics2:security_station'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Quantum Ring
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/quantum_ring'))
    .replaceByName()
    .shape('PXP',
           'YCD',
           'PXP')
    .key('C', item('appliedenergistics2:energy_cell'))
    .key('D', dense_cable)
    .key('P', ore('plateSteel'))
    .key('X', logic_processor)
    .key('Y', engineering_processor)
    .output(item('appliedenergistics2:quantum_ring') * 2)
    .register()

assembler.recipeBuilder()
    .circuitMeta(7)
    .inputs(item('appliedenergistics2:energy_cell'))
    .inputs(ore('plateSteel') * 4)
    .inputs(logic_processor * 2)
    .inputs(engineering_processor)
    .inputs(dense_cable)
    .outputs(item('appliedenergistics2:quantum_ring') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Quantum Link Chamber
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/quantum_link'))
    .replaceByName()
    .shape('SGS',
           'GPG',
           'SGS')
    .key('G', vibrant_quartz_glass)
    .key('P', fluix_pearl)
    .key('S', ore('screwSteel'))
    .output(item('appliedenergistics2:quantum_link'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(7)
    .inputs(vibrant_quartz_glass * 4)
    .inputs(fluix_pearl)
    .inputs(ore('screwSteel') * 4)
    .outputs(item('appliedenergistics2:quantum_link'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Spatial Pylon
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/spatial_io_pylon'))
    .replaceByName()
    .shape('GEG',
           'CPL',
           'GWG')
    .key('G', vibrant_quartz_glass)
    .key('P', fluix_pearl)
    .key('W', glass_cable)
    .key('C', calculation_processor)
    .key('E', engineering_processor)
    .key('L', logic_processor)
    .output(item('appliedenergistics2:spatial_pylon') * 2)
    .register()

assembler.recipeBuilder()
    .circuitMeta(8)
    .inputs(vibrant_quartz_glass * 4)
    .inputs(fluix_pearl)
    .inputs(calculation_processor)
    .inputs(engineering_processor)
    .inputs(logic_processor)
    .inputs(glass_cable)
    .outputs(item('appliedenergistics2:spatial_pylon') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Spatial IO Part
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/spatial_io_port'))
    .replaceByName()
    .shape('GGG',
           'WCW',
           'SXS')
    .key('G', quartz_glass)
    .key('W', glass_cable)
    .key('C', item('appliedenergistics2:io_port'))
    .key('S', ore('screwSteel'))
    .key('X', logic_processor)
    .output(item('appliedenergistics2:spatial_io_port'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(8)
    .inputs(item('appliedenergistics2:io_port'))
    .inputs(quartz_glass * 3)
    .inputs(logic_processor)
    .inputs(glass_cable * 2)
    .inputs(ore('screwSteel') * 2)
    .outputs(item('appliedenergistics2:spatial_io_port'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Controller
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/controller'))
    .replaceByName()
    .shape('PXP',
           'CBC',
           'PGP')
    .key('B', item('appliedenergistics2:fluix_block'))
    .key('X', ore('circuitLv'))
    .key('P', ore('plateSteel'))
    .key('G', glass_cable)
    .key('C', engineering_processor)
    .output(item('appliedenergistics2:controller') * 2)
    .register()

assembler.recipeBuilder()
    .circuitMeta(7)
    .inputs(item('appliedenergistics2:fluix_block'))
    .inputs(ore('plateSteel') * 4)
    .inputs(engineering_processor * 2)
    .inputs(ore('circuitLv'))
    .inputs(glass_cable)
    .outputs(item('appliedenergistics2:controller') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Drive
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/storage_drive'))
    .replaceByName()
    .shape('PXP',
           'GCG',
           'PSP')
    .key('C', item('appliedenergistics2:chest'))
    .key('P', ore('plateSteel'))
    .key('S', ore('screwSteel'))
    .key('G', glass_cable)
    .key('X', engineering_processor)
    .output(item('appliedenergistics2:drive'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(8)
    .inputs(item('appliedenergistics2:chest'))
    .inputs(ore('plateSteel') * 4)
    .inputs(engineering_processor)
    .inputs(glass_cable * 2)
    .inputs(ore('screwSteel'))
    .outputs(item('appliedenergistics2:drive'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// ME Chest
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/storage_chest'))
    .replaceByName()
    .shape('GRG',
           'WCW',
           'SQS')
    .key('C', item('gtlitecore:mte', 2026)) // Iron Crate
    .key('G', quartz_glass)
    .key('R', metaitem('cover.screen'))
    .key('W', glass_cable) 
    .key('Q', fluix_crystal)
    .key('S', ore('screwSteel'))
    .output(item('appliedenergistics2:chest'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(7)
    .inputs(item('gtlitecore:mte', 2026)) // Iron Crate
    .inputs(quartz_glass * 2)
    .inputs(metaitem('cover.screen'))
    .inputs(fluix_crystal)
    .inputs(glass_cable * 2)
    .inputs(ore('screwSteel') * 2)
    .outputs(item('appliedenergistics2:chest'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Cell Workbench
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/cell_workbench'))
    .replaceByName()
    .shape('PXP',
           'SCS',
           'SDS')
    .key('C', item('craftingstation:crafting_station'))
    .key('D', item('minecraft:chest'))
    .key('P', ore('plateIron'))
    .key('S', ore('stickIron'))
    .key('X', calculation_processor)
    .output(item('appliedenergistics2:cell_workbench'))
    .register()

// ME IO Port
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/io_port'))
    .replaceByName()
    .shape('PXP',
           'GDG',
           'PXP')
    .key('D', item('appliedenergistics2:drive'))
    .key('G', fluix_crystal)
    .key('X', engineering_processor)
    .key('P', ore('plateSteel'))
    .output(item('appliedenergistics2:io_port'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(8)
    .inputs(item('appliedenergistics2:drive'))
    .inputs(fluix_crystal * 2)
    .inputs(engineering_processor * 2)
    .inputs(ore('plateSteel') * 4)
    .outputs(item('appliedenergistics2:io_port'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Matter Condenser
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/io_condenser'))
    .replaceByName()
    .shape('QXQ',
           'PBP',
           'CYC')
    .key('B', item('appliedenergistics2:fluix_block'))
    .key('P', ore('plateIron'))
    .key('Q', metaitem('electric.piston.lv'))
    .key('C', glass_cable)
    .key('X', engineering_processor)
    .key('Y', calculation_processor)
    .output(item('appliedenergistics2:condenser'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(6)
    .inputs(item('appliedenergistics2:fluix_block'))
    .inputs(ore('plateIron') * 2)
    .inputs(metaitem('electric.piston.lv') * 2)
    .inputs(glass_cable * 2)
    .inputs(engineering_processor)
    .inputs(calculation_processor)
    .outputs(item('appliedenergistics2:condenser'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Energy Acceptor
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:network/blocks/energy_energy_acceptor'))
    .replaceByName()
    .shape('PGP',
           'GCG',
           'PGP')
    .key('C', fluix_crystal)
    .key('G', quartz_glass)
    .key('P', ore('plateIron'))
    .output(item('appliedenergistics2:energy_acceptor'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(6)
    .inputs(quartz_glass * 4)
    .inputs(ore('plateIron') * 4)
    .inputs(fluix_crystal)
    .outputs(item('appliedenergistics2:energy_acceptor'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Creative Energy Cell
assembly_line.recipeBuilder()
    .inputs(item('appliedenergistics2:controller') * 16)
    .inputs(item('appliedenergistics2:dense_energy_cell') * 16)
    .inputs(item('appliedenergistics2:energy_acceptor') * 16)
    .inputs(ore('plateDenseHssg') * 6)
    .inputs(ore('plateDenseRuridit') * 6)
    .inputs(ore('plateDenseVanadiumGallium') * 6)
    .inputs(metaitem('field.generator.iv') * 2)
    .fluidInputs(fluid('soldering_alloy') * (L * 40))
    .fluidInputs(fluid('rtm_alloy') * (L * 20))
    .outputs(item('appliedenergistics2:creative_energy_cell'))
    .EUt(VA[LuV])
    .duration(1 * MINUTE)
    .scannerResearch({ r ->
        r.researchStack(item('appliedenergistics2:dense_energy_cell'))
         .EUt(VA[IV])
         .duration(30 * SECOND)
    })
    .buildAndRegister()

// Crafting Unit
crafting.removeByOutput(item('appliedenergistics2:crafting_unit'))
crafting.shapedBuilder()
    .name(resource('gtlite:crafting_unit_1'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', item('minecraft:glass_pane'))
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_unit'))
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:crafting_unit_2'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', ore('plateGlass'))
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_unit'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(3)
    .inputs(ore('plateIron') * 4)
    .inputs(calculation_processor)
    .inputs(logic_processor)
    .inputs(glass_cable * 2)
    .inputs(item('minecraft:glass_pane'))
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(3)
    .inputs(ore('plateIron') * 4)
    .inputs(calculation_processor)
    .inputs(logic_processor)
    .inputs(glass_cable * 2)
    .inputs(ore('plateGlass'))
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Crafting Accelerator
crafting.shapedBuilder()
    .name(resource('gtlite:crafting_accelerator'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', engineering_processor)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_accelerator'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(engineering_processor)
    .outputs(item('appliedenergistics2:crafting_accelerator'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_accelerator'))
    .outputs(engineering_processor)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// A little fix for Crafting Accelerator shapeless recipe.
crafting.shapelessBuilder()
    .name(resource('appliedenergistics2:network/crafting/cpu_crafting_accelerator'))
    .replaceByName()
    .input([item('appliedenergistics2:crafting_unit'), engineering_processor])
    .output(item('appliedenergistics2:crafting_accelerator'))
    .register()

// 1k Crafting Storage Unit
crafting.shapedBuilder()
    .name(resource('gtlite:1k_crafting_storage_unit'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', storage_component_1k)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_storage_1k'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(storage_component_1k)
    .outputs(item('appliedenergistics2:crafting_storage_1k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_storage_1k'))
    .outputs(storage_component_1k)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// 4k Crafting Storage Unit
crafting.shapedBuilder()
    .name(resource('gtlite:4k_crafting_storage_unit'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', storage_component_4k)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_storage_4k'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(storage_component_4k)
    .outputs(item('appliedenergistics2:crafting_storage_4k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_storage_4k'))
    .outputs(storage_component_4k)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// A little fix for 4k Crafting Storage Unit shapeless recipe.
crafting.shapelessBuilder()
    .name(resource('appliedenergistics2:network/crafting/cpu_crafting_storage_4k'))
    .replaceByName()
    .input([item('appliedenergistics2:crafting_unit'), storage_component_4k])
    .output(item('appliedenergistics2:crafting_storage_4k'))
    .register()

// 16k Crafting Storage Unit
crafting.shapedBuilder()
    .name(resource('gtlite:16k_crafting_storage_unit'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', storage_component_16k)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_storage_16k'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(storage_component_16k)
    .outputs(item('appliedenergistics2:crafting_storage_16k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_storage_16k'))
    .outputs(storage_component_16k)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// A little fix for 16k Crafting Storage Unit shapeless recipe.
crafting.shapelessBuilder()
    .name(resource('appliedenergistics2:network/crafting/cpu_crafting_storage_16k'))
    .replaceByName()
    .input([item('appliedenergistics2:crafting_unit'), storage_component_16k])
    .output(item('appliedenergistics2:crafting_storage_16k'))
    .register()

// 64k Crafting Storage Unit
crafting.shapedBuilder()
    .name(resource('gtlite:64k_crafting_storage_unit'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', storage_component_64k)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_storage_64k'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(storage_component_64k)
    .outputs(item('appliedenergistics2:crafting_storage_64k'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_storage_64k'))
    .outputs(storage_component_64k)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// Crafting Monitor
crafting.shapedBuilder()
    .name(resource('gtlite:crafting_monitor'))
    .shape('PXP',
           'CGC',
           'PYP')
    .key('G', storage_monitor)
    .key('P', ore('plateIron'))
    .key('C', glass_cable)
    .key('X', calculation_processor)
    .key('Y', logic_processor)
    .output(item('appliedenergistics2:crafting_monitor'))
    .register()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_unit'))
    .inputs(storage_monitor)
    .outputs(item('appliedenergistics2:crafting_monitor'))
    .EUt(VA[ULV])
    .duration(2 * TICK)
    .buildAndRegister()

packer.recipeBuilder()
    .inputs(item('appliedenergistics2:crafting_monitor'))
    .outputs(storage_monitor)
    .outputs(item('appliedenergistics2:crafting_unit'))
    .EUt(V[ULV])
    .duration(4 * TICK)
    .buildAndRegister()

// A little fix for Crafting Monitor shapeless recipe.
crafting.shapelessBuilder()
    .name(resource('appliedenergistics2:network/crafting/cpu_crafting_monitor'))
    .replaceByName()
    .input([item('appliedenergistics2:crafting_unit'), storage_monitor])
    .output(item('appliedenergistics2:crafting_monitor'))
    .register()

// Molecular Assembler
crafting.removeByOutput(item('appliedenergistics2:molecular_assembler'))
crafting.shapedBuilder()
    .name(resource('gtlite:molecular_assembler_1'))
    .shape('PGP',
           'ACF',
           'PGP')
    .key('C', item('craftingstation:crafting_station'))
    .key('A', annihilation_core)
    .key('F', formation_core)
    .key('P', ore('plateSteel'))
    .key('G', quartz_glass)
    .output(item('appliedenergistics2:molecular_assembler'))
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:molecular_assembler_2'))
    .shape('PGP',
           'ACF',
           'PGP')
    .key('C', item('craftingstation:crafting_station'))
    .key('A', annihilation_core)
    .key('F', formation_core)
    .key('P', ore('plateAluminium'))
    .key('G', quartz_glass)
    .output(item('appliedenergistics2:molecular_assembler') * 2)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:molecular_assembler_3'))
    .shape('PGP',
           'ACF',
           'PGP')
    .key('C', item('craftingstation:crafting_station'))
    .key('A', annihilation_core)
    .key('F', formation_core)
    .key('P', ore('plateStainlessSteel'))
    .key('G', quartz_glass)
    .output(item('appliedenergistics2:molecular_assembler') * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:molecular_assembler_4'))
    .shape('PGP',
           'ACF',
           'PGP')
    .key('C', item('craftingstation:crafting_station'))
    .key('A', annihilation_core)
    .key('F', formation_core)
    .key('P', ore('plateTitanium'))
    .key('G', quartz_glass)
    .output(item('appliedenergistics2:molecular_assembler') * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:molecular_assembler_5'))
    .shape('PGP',
           'ACF',
           'PGP')
    .key('C', item('craftingstation:crafting_station'))
    .key('A', annihilation_core)
    .key('F', formation_core)
    .key('P', ore('plateTungstenSteel'))
    .key('G', quartz_glass)
    .output(item('appliedenergistics2:molecular_assembler') * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(12)
    .inputs(item('craftingstation:crafting_station'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateSteel') * 4)
    .inputs(quartz_glass * 2)
    .outputs(item('appliedenergistics2:molecular_assembler'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(12)
    .inputs(item('craftingstation:crafting_station'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateAluminium') * 4)
    .inputs(quartz_glass * 2)
    .outputs(item('appliedenergistics2:molecular_assembler') * 2)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(12)
    .inputs(item('craftingstation:crafting_station'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateStainlessSteel') * 4)
    .inputs(quartz_glass * 2)
    .outputs(item('appliedenergistics2:molecular_assembler') * 4)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(12)
    .inputs(item('craftingstation:crafting_station'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTitanium') * 4)
    .inputs(quartz_glass * 2)
    .outputs(item('appliedenergistics2:molecular_assembler') * 16)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(12)
    .inputs(item('craftingstation:crafting_station'))
    .inputs(annihilation_core)
    .inputs(formation_core)
    .inputs(ore('plateTungstenSteel') * 4)
    .inputs(quartz_glass * 2)
    .outputs(item('appliedenergistics2:molecular_assembler') * 64)
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Basic Card
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:materials/basiccard'))
    .replaceByName()
    .shape('GP ',
           'FXP',
           'GP ')
    .key('F', ore('wireFineRedAlloy'))
    .key('G', ore('wireFineGold'))
    .key('X', calculation_processor)
    .key('P', ore('plateTin'))
    .output(basic_card * 8)
    .register()

forming_press.recipeBuilder()
    .circuitMeta(1)
    .inputs(calculation_processor)
    .inputs(ore('plateGold'))
    .inputs(ore('wireFineRedAlloy') * 2)
    .outputs(basic_card * 16)
    .EUt(VA[LV])
    .duration(2 * SECOND)
    .buildAndRegister()

// Advanced Card
crafting.shapedBuilder()
    .name(resource('appliedenergistics2:materials/advancedcard'))
    .replaceByName()
    .shape('GP ',
           'FXP',
           'GP ')
    .key('F', ore('wireFineRedAlloy'))
    .key('G', ore('wireFineAluminium'))
    .key('X', calculation_processor)
    .key('P', ore('plateTin'))
    .output(advanced_card * 8)
    .register()

forming_press.recipeBuilder()
    .circuitMeta(2)
    .inputs(calculation_processor)
    .inputs(ore('plateAluminium'))
    .inputs(ore('wireFineRedAlloy') * 2)
    .outputs(advanced_card * 16)
    .EUt(VA[LV])
    .duration(2 * SECOND)
    .buildAndRegister()

// Wireless Booster
laser_engraver.recipeBuilder()
    .notConsumable(ore('craftingLensLime'))
    .inputs(ore('plateEnderPearl'))
    .outputs(wireless_booster)
    .EUt(VA[LV])
    .duration(1 * MINUTE)
    .buildAndRegister()

// Blank Pattern
crafting.removeByOutput(blank_pattern)
crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_1a'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', item('minecraft:glass_pane'))
    .key('A', ore('plateSteel'))
    .output(blank_pattern * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_2a'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', item('minecraft:glass_pane'))
    .key('A', ore('plateAluminium'))
    .output(blank_pattern * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_3a'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', item('minecraft:glass_pane'))
    .key('A', ore('plateStainlessSteel'))
    .output(blank_pattern * 64)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_1b'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', ore('plateGlass'))
    .key('A', ore('plateSteel'))
    .output(blank_pattern * 4)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_2b'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', ore('plateGlass'))
    .key('A', ore('plateAluminium'))
    .output(blank_pattern * 16)
    .register()

crafting.shapedBuilder()
    .name(resource('gtlite:blank_pattern_3b'))
    .shape('hPs',
           'PQP',
           'AAA')
    .key('h', ore('toolHammer'))
    .key('s', ore('toolScrewdriver'))
    .key('P', ore('plateGlowstone'))
    .key('Q', ore('plateGlass'))
    .key('A', ore('plateStainlessSteel'))
    .output(blank_pattern * 64)
    .register()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateSteel') * 3)
    .outputs(blank_pattern * 4)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateAluminium') * 3)
    .outputs(blank_pattern * 16)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(item('minecraft:glass_pane'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateStainlessSteel') * 3)
    .outputs(blank_pattern * 64)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateSteel') * 3)
    .outputs(blank_pattern * 4)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateAluminium') * 3)
    .outputs(blank_pattern * 16)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

assembler.recipeBuilder()
    .circuitMeta(2)
    .inputs(ore('plateGlass'))
    .inputs(ore('plateGlowstone') * 3)
    .inputs(ore('plateStainlessSteel') * 3)
    .outputs(blank_pattern * 64)
    .EUt(VA[LV])
    .duration(1 * SECOND)
    .buildAndRegister()

// Quantum Link Card
crafting.shapelessBuilder()
    .name(resource('gtlite:quantum_link_card'))
    .input([item('appliedenergistics2:quantum_ring'), advanced_card])
    .output(quantum_link_card)
    .register()

// Magnet Card
crafting.shapelessBuilder()
    .name(resource('gtlite:magnet_card'))
    .input([metaitem('stickIronMagnetic'), basic_card])
    .output(magnet_card)
    .register()

// Cables
def dyeColors = [ 'white', 'orange', 'magenta', 'light_blue',
    'yellow', 'lime', 'pink', 'gray',
    'light_gray', 'cyan', 'purple', 'blue',
    'brown', 'green', 'red', 'black'
]

for (int i = 0; i < 16; i++) {
    // Glass Cable + Chem Dye -> Colored Glass Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', 16))
        .fluidInputs(fluid('dye_' + dyeColors[i]) * 36)
        .outputs(item('appliedenergistics2:part', i))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()

    // Colored Glass Cable + Water -> Glass Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', i))
        .fluidInputs(fluid('water') * 100)
        .outputs(item('appliedenergistics2:part', 16))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()
}

for (int i = 20; i < 36; i++) {
    // Covered Cable + Chem Dye -> Covered Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', 36))
        .fluidInputs(fluid('dye_' + dyeColors[i - 20]) * 36)
        .outputs(item('appliedenergistics2:part', i))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()

    // Colored Covered Cable + Water -> Covered Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', i))
        .fluidInputs(fluid('water') * 100)
        .outputs(item('appliedenergistics2:part', 36))
        .EUt(VA[LV])
        .duration(2 * TICK)
        .buildAndRegister()
}

// Colored Smart Cable -> Smart Cable
for (int i = 40; i < 56; i++) {
    // Smart Cable + Chem Dye -> Colored Smart Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', 56))
        .fluidInputs(fluid('dye_' + dyeColors[i - 40]) * 36)
        .outputs(item('appliedenergistics2:part', i))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()

    // Colored Smart Cable + Water -> Smart Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', i))
        .fluidInputs(fluid('water') * 100)
        .outputs(item('appliedenergistics2:part', 56))
        .EUt(VA[LV])
        .duration(2 * TICK)
        .buildAndRegister()
}

for (int i = 60; i < 76; i++) {
    // Dense Cable + Chem Dye -> Colored Dense Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', 76))
        .fluidInputs(fluid('dye_' + dyeColors[i - 60]) * 36)
        .outputs(item('appliedenergistics2:part', i))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()
    
    // Colored Dense Cable + Water -> Dense Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', i))
        .fluidInputs(fluid('water') * 100)
        .outputs(item('appliedenergistics2:part', 76))
        .EUt(VA[LV])
        .duration(2 * TICK)
        .buildAndRegister()
}

for (int i = 500; i < 516; i++) { 
    // Dense Covered Cable + Chem Dye -> Colored Dense Covered Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', 516))
        .fluidInputs(fluid('dye_' + dyeColors[i - 500]) * 36)
        .outputs(item('appliedenergistics2:part', i))
        .EUt(VA[LV])
        .duration(TICK)
        .buildAndRegister()

    // Colored Dense Covered Cable + Water -> Dense Covered Cable
    chemical_bath.recipeBuilder()
        .inputs(item('appliedenergistics2:part', i))
        .fluidInputs(fluid('water') * 100)
        .outputs(item('appliedenergistics2:part', 516))
        .EUt(VA[LV])
        .duration(2 * TICK)
        .buildAndRegister()
}

// P2P Tunnels
OreDictIngredient p2pOreDict = ore('p2pTunnels')
p2pOreDict.add(P2PConvertor.getP2PStack())
p2pOreDict.add(P2PConvertor.getP2PVariants().collect { it -> it.value })

crafting.addShapeless(P2PConvertor.getP2PStack(), [p2pOreDict])
for (int i : 0..P2PConvertor.getP2PVariants().size() - 1) {
    assembler.recipeBuilder()
        .circuitMeta(i + 1)
        .inputs(p2pOreDict)
        .outputs(P2PConvertor.getP2PVariants()[i].value)
        .EUt(VA[LV])
        .duration(10 * TICK)
        .buildAndRegister()
}

crafting.remove('appliedenergistics2:network/parts/tunnels_me')
crafting.shapelessBuilder()
    .name(resource('gtlite:p2p_tunnel'))
    .input([ore('itemIlluminatedPanel'), item('projectred-fabrication:ic_chip')])
    .output(P2PConvertor.getP2PStack())
    .register()

/* -------------------------------- AE2 Stuff ------------------------------- */
// Wireless Connector
crafting.shapedBuilder()
    .name(resource('gtlite:wireless_connector'))
    .shape('GIG',
           'XWX',
           'GIG')
    .key('W', wireless_receiver)
    .key('X', engineering_processor)
    .key('G', fluix_crystal)
    .key('I', ore('plateAluminium'))
    .output(item('ae2stuff:wireless'))
    .register()

assembler.recipeBuilder()
    .circuitMeta(6)
    .inputs(wireless_receiver)
    .inputs(engineering_processor * 2)
    .inputs(fluix_crystal * 4)
    .inputs(ore('plateAluminium') * 2)
    .outputs(item('ae2stuff:wireless'))
    .EUt(VA[LV])
    .duration(2 * SECOND + 10 * TICK)
    .buildAndRegister()

// Network Visualiser
crafting.shapelessBuilder()
    .name(resource('gtlite:network_visualiser'))
    .input([logic_processor, 
            metaitem('cover.screen'), 
            item('appliedenergistics2:network_tool')])
    .output(item('ae2stuff:visualiser'))
    .register()

// Colored Wireless Connector
for (i in 1..16) {
    crafting.removeByOutput(item('ae2stuff:wireless', i))
    crafting.removeByOutput(item('ae2stuff:wireless_hub', i))
}