/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.jei;

import gregtechlite.gtlitecore.core.GTLiteConfigHolder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ItemStackRenderer.class}, remap=false)
public class MixinItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    @Overwrite
    public void render(Minecraft mc, int x, int y, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            FontRenderer fontRenderer = this.getFontRenderer(mc, ingredient);
            mc.func_175599_af().func_184391_a(null, ingredient, x, y);
            if (GTLiteConfigHolder.compat.jeiCompat.scaleableFontRenderer) {
                this.gtlitecore$renderItemAndEffectIntoGui(fontRenderer, ingredient, x, y);
            } else {
                mc.func_175599_af().func_180453_a(fontRenderer, ingredient, x, y, null);
            }
            GlStateManager.func_179084_k();
            RenderHelper.func_74518_a();
        }
    }

    @Unique
    private void gtlitecore$renderItemAndEffectIntoGui(FontRenderer fontRenderer, ItemStack stack, int x, int y) {
        if (stack.func_190916_E() != 1) {
            boolean shouldScale;
            String count = this.gtlitecore$formatCount(stack.func_190916_E());
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            boolean bl = shouldScale = stack.func_190916_E() > 99;
            if (shouldScale) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            }
            int posX = shouldScale ? (x + 16) * 2 - fontRenderer.func_78256_a(count) : x + 16 - fontRenderer.func_78256_a(count);
            int posY = shouldScale ? (y + 16) * 2 - 8 : y + 16 - 8;
            fontRenderer.func_175063_a(count, (float)posX, (float)posY, 0xFFFFFF);
            if (shouldScale) {
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    @Unique
    private String gtlitecore$formatCount(int count) {
        if (count <= 99) {
            return String.valueOf(count);
        }
        if (count <= 9999) {
            return String.valueOf(count);
        }
        if (count <= 999999) {
            float k = (float)count / 1000.0f;
            return String.format(k % 1.0f == 0.0f ? "%.0fk" : "%.1fk", Float.valueOf(k));
        }
        if (count <= 999999999) {
            float m = (float)count / 1000000.0f;
            return String.format(m % 1.0f == 0.0f ? "%.0fm" : "%.1fm", Float.valueOf(m));
        }
        float g = (float)count / 1.0E9f;
        return String.format(g % 1.0f == 0.0f ? "%.0fg" : "%.1fg", Float.valueOf(g));
    }
}

