/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech.client;

import gregtech.api.GTValues;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.utils.IBloomEffect;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityFusionReactor;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MetaTileEntityFusionReactor.class}, remap=false)
public abstract class MixinMetaTileEntityFusionReactor
extends RecipeMapMultiblockController
implements IFastRenderMetaTileEntity,
IBloomEffect {
    @Mutable
    @Final
    @Shadow
    private final int tier;

    public MixinMetaTileEntityFusionReactor(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.FUSION_RECIPES);
        this.tier = tier;
    }

    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        long energyCostEach = this.calculateEnergyStorageFactor(16) / 1000000L;
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.energy_cost", (Object[])new Object[]{GTValues.V[this.tier] / 16L, energyCostEach / 16L}));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.recipe_request", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gtlitecore.machine.fusion_reactor.tier", (Object[])new Object[]{GTValues.VNF[this.tier]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.overclocking", (Object[])new Object[0]));
    }

    @Shadow
    private long calculateEnergyStorageFactor(int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, this.tier - 6) * 10000000L;
    }
}

