/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech.client;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.registry.MTERegistry;
import gregtech.api.mui.GregTechGuiTransferHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.category.ICategoryOverride;
import gregtech.api.recipes.ingredients.GTRecipeOreInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.recipes.machines.IScannerRecipeMap;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.JustEnoughItemsModule;
import gregtech.integration.jei.basic.GTFluidVeinCategory;
import gregtech.integration.jei.basic.GTFluidVeinInfo;
import gregtech.integration.jei.basic.GTOreCategory;
import gregtech.integration.jei.basic.GTOreInfo;
import gregtech.integration.jei.basic.MaterialTree;
import gregtech.integration.jei.basic.MaterialTreeCategory;
import gregtech.integration.jei.basic.OreByProduct;
import gregtech.integration.jei.basic.OreByProductCategory;
import gregtech.integration.jei.multiblock.MultiblockInfoCategory;
import gregtech.integration.jei.recipe.FacadeRegistryPlugin;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtech.integration.jei.recipe.IntCircuitCategory;
import gregtech.integration.jei.recipe.IntCircuitRecipeWrapper;
import gregtech.integration.jei.utils.ModularUIGuiHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={JustEnoughItemsModule.class}, remap=false)
public abstract class MixinJustEnoughItemsModule {
    @Shadow
    public static IIngredientRegistry ingredientRegistry;
    @Shadow
    public static IGuiHelper guiHelper;

    @Shadow
    protected abstract void registerRecipeMapCatalyst(IModRegistry var1, RecipeMap<?> var2, MetaTileEntity var3);

    @Overwrite
    public void register(@NotNull IModRegistry registry) {
        MetaTileEntity[][] machineLists;
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipes(IntCircuitRecipeWrapper.create(), IntCircuitCategory.UID);
        MultiblockInfoCategory.registerRecipes((IModRegistry)registry);
        registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new FacadeRegistryPlugin());
        ModularUIGuiHandler modularUIGuiHandler = new ModularUIGuiHandler(jeiHelpers.recipeTransferHandlerHelper());
        modularUIGuiHandler.blacklistCategory(new String[]{IntCircuitCategory.UID, MaterialTreeCategory.UID, "jei.information", "minecraft.fuel"});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)modularUIGuiHandler, "universal recipe transfer handler");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new GregTechGuiTransferHandler(jeiHelpers.recipeTransferHandlerHelper()), "minecraft.crafting");
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{modularUIGuiHandler});
        registry.addGhostIngredientHandler(modularUIGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)modularUIGuiHandler);
        for (RecipeMap recipeMap : RecipeMap.getRecipeMaps()) {
            if (!recipeMap.getRecipeMapUI().isJEIVisible()) continue;
            for (Map.Entry entry : recipeMap.getRecipesByCategory().entrySet()) {
                IScannerRecipeMap scannerMap;
                List scannerRecipes;
                Stream<Recipe> recipeStream = ((List)entry.getValue()).stream().filter(recipe -> !recipe.isHidden() && recipe.hasValidInputsForDisplay());
                if (recipeMap.getSmallRecipeMap() != null) {
                    Collection smallRecipes = recipeMap.getSmallRecipeMap().getRecipeList();
                    recipeStream = recipeStream.filter(recipe -> !smallRecipes.contains(recipe));
                }
                if (recipeMap instanceof IScannerRecipeMap && !(scannerRecipes = (scannerMap = (IScannerRecipeMap)recipeMap).getRepresentativeRecipes()).isEmpty()) {
                    registry.addRecipes((Collection)scannerRecipes.stream().map(r -> new GTRecipeWrapper(recipeMap, r)).collect(Collectors.toList()), ((GTRecipeCategory)entry.getKey()).getUniqueID());
                }
                registry.addRecipes((Collection)recipeStream.map(r -> new GTRecipeWrapper(recipeMap, r)).collect(Collectors.toList()), ((GTRecipeCategory)entry.getKey()).getUniqueID());
            }
        }
        for (MetaTileEntity metaTileEntity : this.gtlitecore$getSortedMTEs()) {
            assert (metaTileEntity != null);
            if (metaTileEntity instanceof ICategoryOverride && ((ICategoryOverride)metaTileEntity).shouldOverride()) {
                ICategoryOverride override = (ICategoryOverride)metaTileEntity;
                for (RecipeMap recipeMap : override.getJEIRecipeMapCategoryOverrides()) {
                    this.registerRecipeMapCatalyst(registry, recipeMap, metaTileEntity);
                }
                if (override.getJEICategoryOverrides().length != 0) {
                    registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), override.getJEICategoryOverrides());
                }
                if (override.shouldReplace()) continue;
            }
            if (metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null) == null) continue;
            IControllable workableCapability = (IControllable)metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
            if (workableCapability instanceof ICategoryOverride && ((ICategoryOverride)workableCapability).shouldOverride()) {
                ICategoryOverride iCategoryOverride = (ICategoryOverride)workableCapability;
                for (RecipeMap recipeMap : iCategoryOverride.getJEIRecipeMapCategoryOverrides()) {
                    this.registerRecipeMapCatalyst(registry, recipeMap, metaTileEntity);
                }
                if (iCategoryOverride.getJEICategoryOverrides().length != 0) {
                    registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), iCategoryOverride.getJEICategoryOverrides());
                }
                if (iCategoryOverride.shouldReplace()) continue;
            }
            if (!(workableCapability instanceof AbstractRecipeLogic)) continue;
            AbstractRecipeLogic abstractRecipeLogic = (AbstractRecipeLogic)workableCapability;
            if (metaTileEntity instanceof IMultipleRecipeMaps) {
                for (RecipeMap recipeMap : ((IMultipleRecipeMaps)metaTileEntity).getAvailableRecipeMaps()) {
                    this.registerRecipeMapCatalyst(registry, recipeMap, metaTileEntity);
                }
                continue;
            }
            if (abstractRecipeLogic.getRecipeMap() == null) continue;
            this.registerRecipeMapCatalyst(registry, abstractRecipeLogic.getRecipeMap(), metaTileEntity);
        }
        ArrayList<OreByProduct> oreByproductList = new ArrayList<OreByProduct>();
        ArrayList<MaterialTree> materialTreeList = new ArrayList<MaterialTree>();
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            if (material.hasProperty(PropertyKey.ORE)) {
                oreByproductList.add(new OreByProduct(material));
            }
            if (material.hasProperty(PropertyKey.DUST)) {
                materialTreeList.add(new MaterialTree(material));
            }
            if (!material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW) || !material.hasFlag(MaterialFlags.GENERATE_RING) || !material.hasProperty(PropertyKey.TOOL)) continue;
            registry.addIngredientInfo((Object)ToolItems.TOOLBELT.get(material), VanillaTypes.ITEM, new String[]{"item.gt.tool.toolbelt.tooltip", "item.gt.tool.toolbelt.paint", "item.gt.tool.toolbelt.dye", "item.gt.tool.toolbelt.maintenance"});
        }
        registry.addRecipes(oreByproductList, OreByProductCategory.UID);
        for (MetaTileEntity[] machine : machineLists = new MetaTileEntity[][]{MetaTileEntities.MACERATOR, MetaTileEntities.ORE_WASHER, MetaTileEntities.CENTRIFUGE, MetaTileEntities.THERMAL_CENTRIFUGE, MetaTileEntities.CHEMICAL_BATH, MetaTileEntities.ELECTROMAGNETIC_SEPARATOR, MetaTileEntities.SIFTER}) {
            if (machine.length < 2 || machine[1] == null) continue;
            registry.addRecipeCatalyst((Object)machine[1].getStackForm(), new String[]{OreByProductCategory.UID});
        }
        registry.addRecipes(materialTreeList, MaterialTreeCategory.UID);
        List list = WorldGenRegistry.getOreDeposits();
        ArrayList<GTOreInfo> oreInfoList = new ArrayList<GTOreInfo>();
        for (OreDepositDefinition vein : list) {
            oreInfoList.add(new GTOreInfo(vein));
        }
        String oreSpawnID = GTOreCategory.UID;
        registry.addRecipes(oreInfoList, oreSpawnID);
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LV.getStackForm(), new String[]{oreSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_HV.getStackForm(), new String[]{oreSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LUV.getStackForm(), new String[]{oreSpawnID});
        List fluidVeins = WorldGenRegistry.getBedrockVeinDeposits();
        ArrayList<GTFluidVeinInfo> fluidVeinInfos = new ArrayList<GTFluidVeinInfo>();
        for (BedrockFluidDepositDefinition fluidVein : fluidVeins) {
            fluidVeinInfos.add(new GTFluidVeinInfo(fluidVein));
        }
        String fluidVeinSpawnID = GTFluidVeinCategory.UID;
        registry.addRecipes(fluidVeinInfos, fluidVeinSpawnID);
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_HV.getStackForm(), new String[]{fluidVeinSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LUV.getStackForm(), new String[]{fluidVeinSpawnID});
        ingredientRegistry = registry.getIngredientRegistry();
        for (int i = 0; i <= 32; ++i) {
            registry.addIngredientInfo((Object)IntCircuitIngredient.getIntegratedCircuit((int)i), VanillaTypes.ITEM, new String[]{"metaitem.circuit.integrated.jei_description"});
        }
        registry.addRecipeCatalyst((Object)MetaTileEntities.WORKBENCH.getStackForm(), new String[]{"minecraft.crafting"});
        for (SimpleMachineMetaTileEntity machine : MetaTileEntities.CANNER) {
            if (machine == null) continue;
            registry.addIngredientInfo((Object)machine.getStackForm(), VanillaTypes.ITEM, new String[]{"gregtech.machine.canner.jei_description"});
        }
        MultiblockInfoCategory.REGISTER.forEach(mte -> {
            String[] desc = mte.getDescription();
            if (desc.length > 0) {
                registry.addIngredientInfo((Object)mte.getStackForm(), VanillaTypes.ITEM, mte.getDescription());
            }
        });
        registry.addIngredientInfo((Object)new ItemStack((Block)MetaBlocks.BRITTLE_CHARCOAL), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"tile.brittle_charcoal.tooltip.1", (Object[])new Object[]{I18n.func_135052_a((String)"tile.brittle_charcoal.tooltip.2", (Object[])new Object[0])})});
        GTRecipeOreInput.refreshStackCache();
    }

    @Unique
    private List<MetaTileEntity> gtlitecore$getSortedMTEs() {
        ArrayList<MetaTileEntity> sortedMTEs = new ArrayList<MetaTileEntity>();
        for (MTERegistry mteRegistry : GregTechAPI.mteManager.getRegistries()) {
            for (ResourceLocation mteId : mteRegistry.func_148742_b()) {
                MetaTileEntity mte = (MetaTileEntity)mteRegistry.func_82594_a((Object)mteId);
                if (mte == null) continue;
                sortedMTEs.add(mte);
            }
        }
        sortedMTEs.sort((a, b) -> {
            boolean a1 = a.metaTileEntityId.func_110624_b().equals("gregtech");
            boolean b1 = b.metaTileEntityId.func_110624_b().equals("gregtech");
            if (a1 && !b1) {
                return -1;
            }
            if (!a1 && b1) {
                return 1;
            }
            return a.metaTileEntityId.func_110624_b().compareTo(b.metaTileEntityId.func_110624_b());
        });
        return sortedMTEs;
    }
}

