/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech.client;

import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.ItemPipeRenderer;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemPipeRenderer.class}, remap=false)
public abstract class MixinItemPipeRenderer {
    @Unique
    private final Table<ItemPipeType, MaterialIconSet, TextureAtlasSprite> gtlitecore$pipeTextures = HashBasedTable.create();
    @Unique
    private final Map<MaterialIconSet, TextureAtlasSprite> gtlitecore$pipeSideTextures = new HashMap<MaterialIconSet, TextureAtlasSprite>();

    @Inject(method={"registerIcons"}, at={@At(value="TAIL")})
    private void registerIcons(TextureMap map, CallbackInfo ci) {
        for (MaterialIconSet iconSet : MaterialIconSet.ICON_SETS.values()) {
            ResourceLocation iconSetPipeSmallLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_small_in"));
            ResourceLocation iconSetPipeNormalLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_normal_in"));
            ResourceLocation iconSetPipeLargeLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_large_in"));
            ResourceLocation iconSetPipeHugeLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_huge_in"));
            ResourceLocation iconSetPipeSideLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_side"));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.SMALL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeSmallLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.NORMAL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeNormalLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.LARGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeLargeLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.HUGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeHugeLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.RESTRICTIVE_SMALL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeSmallLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.RESTRICTIVE_NORMAL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeNormalLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.RESTRICTIVE_LARGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeLargeLocation));
            this.gtlitecore$pipeTextures.put((Object)ItemPipeType.RESTRICTIVE_HUGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeHugeLocation));
            this.gtlitecore$pipeSideTextures.put(iconSet, map.func_174942_a(iconSetPipeSideLocation));
        }
    }

    @Inject(method={"buildRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material, CallbackInfo ci) {
        if (material != null && pipeType instanceof ItemPipeType) {
            MaterialIconSet iconSet = material.getMaterialIconSet();
            TextureAtlasSprite pipeTexture = (TextureAtlasSprite)this.gtlitecore$pipeTextures.get(pipeType, (Object)iconSet);
            TextureAtlasSprite pipeSideTexture = this.gtlitecore$pipeSideTextures.get(iconSet);
            renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(pipeTexture)}).addSideRender(new IVertexOperation[]{new IconTransformation(pipeSideTexture)});
            if (((ItemPipeType)pipeType).isRestrictive()) {
                renderContext.addSideRender(false, new IVertexOperation[]{new IconTransformation(Textures.RESTRICTIVE_OVERLAY)});
            }
        }
        ci.cancel();
    }
}

