/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech.client;

import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.FluidPipeRenderer;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidPipeRenderer.class}, remap=false)
public abstract class MixinFluidPipeRenderer {
    @Unique
    private final Table<FluidPipeType, MaterialIconSet, TextureAtlasSprite> gtlitecore$pipeTextures = HashBasedTable.create();
    @Unique
    private final Map<MaterialIconSet, TextureAtlasSprite> gtlitecore$pipeSideTextures = new HashMap<MaterialIconSet, TextureAtlasSprite>();

    @Inject(method={"registerIcons"}, at={@At(value="TAIL")})
    private void registerIcons(TextureMap map, CallbackInfo ci) {
        for (MaterialIconSet iconSet : MaterialIconSet.ICON_SETS.values()) {
            ResourceLocation iconSetPipeTinyLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_tiny_in"));
            ResourceLocation iconSetPipeSmallLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_small_in"));
            ResourceLocation iconSetPipeNormalLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_normal_in"));
            ResourceLocation iconSetPipeLargeLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_large_in"));
            ResourceLocation iconSetPipeHugeLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_huge_in"));
            ResourceLocation iconSetPipeQuadrupleLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_quadruple_in"));
            ResourceLocation iconSetPipeNonupleLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_nonuple_in"));
            ResourceLocation iconSetPipeSideLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/pipe_side"));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.TINY, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeTinyLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.SMALL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeSmallLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.NORMAL, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeNormalLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.LARGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeLargeLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.HUGE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeHugeLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.QUADRUPLE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeQuadrupleLocation));
            this.gtlitecore$pipeTextures.put((Object)FluidPipeType.NONUPLE, (Object)iconSet, (Object)map.func_174942_a(iconSetPipeNonupleLocation));
            this.gtlitecore$pipeSideTextures.put(iconSet, map.func_174942_a(iconSetPipeSideLocation));
        }
    }

    @Inject(method={"buildRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material, CallbackInfo ci) {
        if (material == null || !(pipeType instanceof FluidPipeType)) {
            return;
        }
        MaterialIconSet iconSet = material.getMaterialIconSet();
        TextureAtlasSprite pipeTexture = (TextureAtlasSprite)this.gtlitecore$pipeTextures.get(pipeType, (Object)iconSet);
        TextureAtlasSprite pipeSideTexture = this.gtlitecore$pipeSideTextures.get(iconSet);
        renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(pipeTexture)}).addSideRender(new IVertexOperation[]{new IconTransformation(pipeSideTexture)});
        ci.cancel();
    }
}

