/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech.client;

import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.CableRenderer;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.common.pipelike.cable.Insulation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CableRenderer.class}, remap=false)
public abstract class MixinCableRenderer {
    @Unique
    private final Map<MaterialIconSet, TextureAtlasSprite> gtlitecore$wireTextures = new HashMap<MaterialIconSet, TextureAtlasSprite>();
    @Final
    @Shadow
    private TextureAtlasSprite[] insulationTextures;

    @Inject(method={"registerIcons"}, at={@At(value="TAIL")})
    private void registerIcons(TextureMap map, CallbackInfo ci) {
        ResourceLocation wireLocation = GTUtility.gregtechId((String)"blocks/cable/wire");
        this.gtlitecore$wireTextures.put(MaterialIconSet.DULL, map.func_174942_a(wireLocation));
        for (MaterialIconSet iconSet : MaterialIconSet.ICON_SETS.values()) {
            ResourceLocation iconSetWireLocation = GTUtility.gregtechId((String)("blocks/material_sets/" + iconSet.getName().toLowerCase() + "/wire"));
            this.gtlitecore$wireTextures.put(iconSet, map.func_174942_a(iconSetWireLocation));
        }
    }

    @Inject(method={"buildRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    private void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material, CallbackInfo ci) {
        if (material != null && pipeType instanceof Insulation) {
            int insulationLevel = ((Insulation)pipeType).insulationLevel;
            MaterialIconSet iconSet = material.getMaterialIconSet();
            TextureAtlasSprite wireTexture = this.gtlitecore$wireTextures.getOrDefault(iconSet, this.gtlitecore$wireTextures.get(MaterialIconSet.DULL));
            IconTransformation wireRender = new IconTransformation(wireTexture);
            ColourMultiplier wireColor = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL((int)material.getMaterialRGB()));
            ColourMultiplier insulationColor = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL((int)0x404040));
            if (pipeTile != null) {
                if (pipeTile.getPaintingColor() != pipeTile.getDefaultPaintingColor()) {
                    wireColor.colour = GTUtility.convertRGBtoOpaqueRGBA_CL((int)pipeTile.getPaintingColor());
                }
                insulationColor.colour = GTUtility.convertRGBtoOpaqueRGBA_CL((int)pipeTile.getPaintingColor());
            }
            if (insulationLevel != -1) {
                if ((renderContext.getConnections() & 0x3F) == 0) {
                    renderContext.addOpenFaceRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[5]), insulationColor});
                    return;
                }
                renderContext.addOpenFaceRender(false, new IVertexOperation[]{wireRender, wireColor}).addOpenFaceRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[insulationLevel]), insulationColor}).addSideRender(false, new IVertexOperation[]{new IconTransformation(this.insulationTextures[5]), insulationColor});
            } else {
                renderContext.addOpenFaceRender(false, new IVertexOperation[]{wireRender, wireColor}).addSideRender(false, new IVertexOperation[]{wireRender, wireColor});
            }
        }
        ci.cancel();
    }

    @Inject(method={"getParticleTexture(Lgregtech/api/pipenet/tile/IPipeTile;)Lorg/apache/commons/lang3/tuple/Pair;"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetParticleTexture(IPipeTile<?, ?> pipeTile, CallbackInfoReturnable<Pair<TextureAtlasSprite, Integer>> cir) {
        IPipeType pipeType;
        if (pipeTile != null && (pipeType = (IPipeType)pipeTile.getPipeType()) instanceof Insulation) {
            int particleColor;
            Material material = pipeTile instanceof TileEntityMaterialPipeBase ? ((TileEntityMaterialPipeBase)pipeTile).getPipeMaterial() : null;
            int insulationLevel = ((Insulation)pipeType).insulationLevel;
            MaterialIconSet iconSet = material != null ? material.getMaterialIconSet() : MaterialIconSet.DULL;
            TextureAtlasSprite atlasSprite = this.gtlitecore$wireTextures.getOrDefault(iconSet, this.gtlitecore$wireTextures.get(MaterialIconSet.DULL));
            if (insulationLevel == -1) {
                particleColor = material == null ? 0xFFFFFF : material.getMaterialRGB();
            } else {
                atlasSprite = this.insulationTextures[5];
                particleColor = pipeTile.getPaintingColor();
            }
            cir.setReturnValue((Object)Pair.of((Object)atlasSprite, (Object)particleColor));
        }
    }
}

