/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech;

import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.RecipeMap;
import gregtechlite.gtlitecore.api.capability.MultipleNotifiableHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MultiblockRecipeLogic.class}, remap=false)
public abstract class MixinMultiblockRecipeLogic
extends AbstractRecipeLogic {
    @Shadow
    protected List<IItemHandlerModifiable> invalidatedInputList;

    public MixinMultiblockRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap) {
        super(tileEntity, recipeMap);
    }

    @Overwrite
    protected boolean canWorkWithInputs() {
        RecipeMapMultiblockController distinctController;
        MultiblockWithDisplayBase controller = (MultiblockWithDisplayBase)this.metaTileEntity;
        if (controller instanceof RecipeMapMultiblockController && (distinctController = (RecipeMapMultiblockController)controller).canBeDistinct() && distinctController.isDistinct() && this.getInputInventory().getSlots() > 0) {
            boolean canWork = false;
            if (this.invalidatedInputList.isEmpty()) {
                return true;
            }
            if (!this.metaTileEntity.getNotifiedFluidInputList().isEmpty()) {
                canWork = true;
                this.invalidatedInputList.clear();
                this.metaTileEntity.getNotifiedFluidInputList().clear();
                this.metaTileEntity.getNotifiedItemInputList().clear();
            } else {
                Iterator notifiedIter = this.metaTileEntity.getNotifiedItemInputList().iterator();
                while (notifiedIter.hasNext()) {
                    IItemHandlerModifiable bus = (IItemHandlerModifiable)notifiedIter.next();
                    Iterator<IItemHandlerModifiable> iterator = this.invalidatedInputList.iterator();
                    block1: while (iterator.hasNext()) {
                        IItemHandler invalidatedHandler = (IItemHandler)iterator.next();
                        if (invalidatedHandler instanceof MultipleNotifiableHandler) {
                            MultipleNotifiableHandler multipleNotifiableHandler = (MultipleNotifiableHandler)invalidatedHandler;
                            for (INotifiableHandler notifiableHandler : multipleNotifiableHandler.getBackingNotifiers()) {
                                if (notifiableHandler != bus) continue;
                                canWork = true;
                                iterator.remove();
                                continue block1;
                            }
                            continue;
                        }
                        if (invalidatedHandler != bus) continue;
                        canWork = true;
                        iterator.remove();
                    }
                    notifiedIter.remove();
                }
            }
            ArrayList<IItemHandler> flattenedHandlers = new ArrayList<IItemHandler>();
            for (IItemHandler iItemHandler : this.getInputBuses()) {
                if (iItemHandler instanceof ItemHandlerList) {
                    flattenedHandlers.addAll(((ItemHandlerList)iItemHandler).getBackingHandlers());
                }
                flattenedHandlers.add(iItemHandler);
            }
            if (!this.invalidatedInputList.containsAll(flattenedHandlers)) {
                canWork = true;
            }
            return canWork;
        }
        return super.canWorkWithInputs();
    }

    @Shadow
    protected abstract List<IItemHandlerModifiable> getInputBuses();
}

