/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import gregtechlite.gtlitecore.api.capability.MultipleNotifiableHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MetaTileEntityMultiblockNotifiablePart.class}, remap=false)
public abstract class MixinMetaTileEntityMultiblockNotifiablePart
extends MetaTileEntityMultiblockPart {
    @Shadow
    @Final
    protected boolean isExportHatch;

    public MixinMetaTileEntityMultiblockNotifiablePart(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Overwrite
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.gtlitecore$getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.addNotifiableMetaTileEntity((MetaTileEntity)controllerBase);
            handler.addToNotifiedList((MetaTileEntity)this, (Object)handler, this.isExportHatch);
        }
    }

    @Overwrite
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.gtlitecore$getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.removeNotifiableMetaTileEntity((MetaTileEntity)controllerBase);
        }
    }

    @Unique
    private List<INotifiableHandler> gtlitecore$getPartHandlers() {
        ArrayList<INotifiableHandler> notifiableHandlers;
        block9: {
            FluidTankList fluidTankList;
            block8: {
                notifiableHandlers = new ArrayList<INotifiableHandler>();
                if (!(this instanceof IMultiblockAbilityPart)) break block8;
                IMultiblockAbilityPart abilityPart = (IMultiblockAbilityPart)this;
                List abilities = abilityPart.getAbilities();
                for (MultiblockAbility ability : abilities) {
                    AbilityInstances instances = new AbilityInstances(ability);
                    abilityPart.registerAbilities(instances);
                    for (Object handler : instances) {
                        if (handler instanceof MultipleNotifiableHandler) {
                            MultipleNotifiableHandler multipleNotifiableHandler = (MultipleNotifiableHandler)handler;
                            notifiableHandlers.addAll(multipleNotifiableHandler.getBackingNotifiers());
                            continue;
                        }
                        if (handler instanceof IMultipleTankHandler) {
                            IMultipleTankHandler multipleTankHandler = (IMultipleTankHandler)handler;
                            for (IFluidTank tank : multipleTankHandler.getFluidTanks()) {
                                if (!(tank instanceof INotifiableHandler)) continue;
                                INotifiableHandler notifiableTank = (INotifiableHandler)tank;
                                notifiableHandlers.add(notifiableTank);
                            }
                            continue;
                        }
                        if (!(handler instanceof INotifiableHandler)) continue;
                        INotifiableHandler notifiableHandler = (INotifiableHandler)handler;
                        notifiableHandlers.add(notifiableHandler);
                    }
                }
                break block9;
            }
            for (INotifiableHandler notifier : this.getItemHandlers()) {
                if (notifier.size() <= 0) continue;
                notifiableHandlers.add(notifier);
            }
            if (this.fluidInventory.getTankProperties().length <= 0 || (fluidTankList = this.getFluidHandlers()) == null) break block9;
            for (IFluidTank fluidTank : fluidTankList) {
                if (fluidTank instanceof IMultipleTankHandler.ITankEntry) {
                    IMultipleTankHandler.ITankEntry entry = (IMultipleTankHandler.ITankEntry)fluidTank;
                    fluidTank = entry.getDelegate();
                }
                if (!(fluidTank instanceof INotifiableHandler)) continue;
                notifiableHandlers.add((INotifiableHandler)fluidTank);
            }
        }
        return notifiableHandlers;
    }

    @Shadow
    protected abstract List<INotifiableHandler> getItemHandlers();

    @Shadow
    protected abstract FluidTankList getFluidHandlers();
}

