/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech;

import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.MaterialProperties;
import gregtech.api.unification.material.properties.PropertyKey;
import java.util.Map;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MaterialProperties.class}, remap=false)
public abstract class MixinMaterialProperties {
    @Shadow
    @Final
    private Map<PropertyKey<? extends IMaterialProperty>, IMaterialProperty> propertyMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"setProperty"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends IMaterialProperty> void setProperty(PropertyKey<T> key, IMaterialProperty value, CallbackInfo ci) {
        if (value == null) {
            throw new IllegalArgumentException("Material Property must not be null!");
        }
        if (this.hasProperty(key)) {
            if (!key.equals((Object)PropertyKey.INGOT) && !key.equals((Object)PropertyKey.GEM) || !this.hasProperty(PropertyKey.DUST)) throw new IllegalArgumentException("Material Property " + key + " already registered!");
            this.propertyMap.remove(PropertyKey.DUST);
            this.propertyMap.put(key, value);
        } else {
            this.propertyMap.put(key, value);
            this.propertyMap.remove(PropertyKey.EMPTY);
        }
        ci.cancel();
    }

    @Shadow
    public abstract <T extends IMaterialProperty> boolean hasProperty(PropertyKey<T> var1);
}

