/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech;

import com.google.common.collect.ImmutableList;
import gregtech.api.capability.DualHandler;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtechlite.gtlitecore.api.capability.MultipleNotifiableHandler;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DualHandler.class}, remap=false)
public abstract class MixinDualHandler
implements INotifiableHandler,
MultipleNotifiableHandler {
    @Shadow
    @NotNull
    protected IItemHandlerModifiable itemDelegate;
    @Shadow
    @NotNull
    protected IMultipleTankHandler fluidDelegate;
    @Shadow
    List<MetaTileEntity> notifiableEntities;

    @Overwrite
    public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        if (metaTileEntity == null || this.notifiableEntities.contains(metaTileEntity)) {
            return;
        }
        this.notifiableEntities.add(metaTileEntity);
        if (this.getItemDelegate() instanceof INotifiableHandler) {
            INotifiableHandler handler = (INotifiableHandler)this.getItemDelegate();
            handler.addNotifiableMetaTileEntity(metaTileEntity);
        } else if (this.getItemDelegate() instanceof ItemHandlerList) {
            ItemHandlerList list = (ItemHandlerList)this.getItemDelegate();
            for (IItemHandler handler : list.getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                INotifiableHandler notifiableHandler = (INotifiableHandler)handler;
                notifiableHandler.addNotifiableMetaTileEntity(metaTileEntity);
            }
        }
        for (IMultipleTankHandler.ITankEntry entry : this.getFluidDelegate()) {
            IItemHandler handler;
            if (!(entry.getDelegate() instanceof INotifiableHandler)) continue;
            handler = (INotifiableHandler)entry.getDelegate();
            handler.addNotifiableMetaTileEntity(metaTileEntity);
        }
    }

    @Overwrite
    public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.notifiableEntities.remove(metaTileEntity);
        if (this.getItemDelegate() instanceof INotifiableHandler) {
            INotifiableHandler handler = (INotifiableHandler)this.getItemDelegate();
            handler.removeNotifiableMetaTileEntity(metaTileEntity);
        } else if (this.getItemDelegate() instanceof ItemHandlerList) {
            ItemHandlerList list = (ItemHandlerList)this.getItemDelegate();
            for (IItemHandler handler : list.getBackingHandlers()) {
                if (!(handler instanceof INotifiableHandler)) continue;
                INotifiableHandler notifiableHandler = (INotifiableHandler)handler;
                notifiableHandler.removeNotifiableMetaTileEntity(metaTileEntity);
            }
        }
        for (IMultipleTankHandler.ITankEntry entry : this.getFluidDelegate()) {
            IItemHandler handler;
            if (!(entry.getDelegate() instanceof INotifiableHandler)) continue;
            handler = (INotifiableHandler)entry.getDelegate();
            handler.removeNotifiableMetaTileEntity(metaTileEntity);
        }
    }

    @Override
    @NotNull
    public Collection<INotifiableHandler> getBackingNotifiers() {
        ImmutableList.Builder handlerList = ImmutableList.builder();
        if (this.itemDelegate instanceof MultipleNotifiableHandler) {
            MultipleNotifiableHandler multipleNotifiableHandler = (MultipleNotifiableHandler)this.itemDelegate;
            handlerList.addAll(multipleNotifiableHandler.getBackingNotifiers());
        } else if (this.itemDelegate instanceof INotifiableHandler) {
            INotifiableHandler notifiableHandler = (INotifiableHandler)this.itemDelegate;
            handlerList.add((Object)notifiableHandler);
        }
        for (IMultipleTankHandler.ITankEntry tank : this.fluidDelegate) {
            if (!(tank instanceof INotifiableHandler)) continue;
            INotifiableHandler notifiableHandler = (INotifiableHandler)tank;
            handlerList.add((Object)notifiableHandler);
        }
        return handlerList.build();
    }

    @Shadow
    @NotNull
    public abstract IItemHandlerModifiable getItemDelegate();

    @Shadow
    @NotNull
    public abstract IMultipleTankHandler getFluidDelegate();
}

