/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.mixins.gregtech;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import gregtechlite.gtlitecore.api.pattern.BlockPatternExtension;
import gregtechlite.gtlitecore.api.pattern.GTLitePredicate;
import gregtechlite.gtlitecore.mixins.gregtech.AccessorTraceabilityPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockPattern.class}, remap=false)
public abstract class MixinBlockPattern
implements BlockPatternExtension {
    @Unique
    private static final Object CENTER_INFO = new Object();
    @Shadow
    static EnumFacing[] FACINGS;
    @Shadow
    @Final
    protected int fingerLength;
    @Shadow
    @Final
    protected int thumbLength;
    @Shadow
    @Final
    protected int palmLength;
    @Shadow
    @Final
    protected TraceabilityPredicate[][][] blockMatches;
    @Shadow
    @Final
    public RelativeDirection[] structureDir;
    @Unique
    private int gtlitecore$previewPages;

    @Override
    public int getPreviewPages() {
        if (this.gtlitecore$previewPages <= 0) {
            this.gtlitecore$previewPages = Arrays.stream(this.blockMatches).flatMap(Arrays::stream).flatMap(Arrays::stream).flatMap(predicate -> Stream.concat(predicate.common.stream(), predicate.limited.stream())).filter(GTLitePredicate.class::isInstance).map(GTLitePredicate.class::cast).filter(GTLitePredicate::getPreviewCandidates).mapToInt(predicate -> ((BlockInfo[])predicate.candidates.get()).length).max().orElse(1);
            return this.gtlitecore$previewPages;
        }
        return this.gtlitecore$previewPages;
    }

    @Override
    @NotNull
    public @NotNull BlockInfo @NotNull [] @NotNull [] @NotNull [] getPreview(int @NotNull [] repetition, int candidateIndex) {
        HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]> cacheInfos = new HashMap<TraceabilityPredicate.SimplePredicate, BlockInfo[]>();
        HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheGlobal = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
        HashMap<BlockPos, BlockInfo> blocks = new HashMap<BlockPos, BlockInfo>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int x = 0;
        for (int l = 0; l < this.fingerLength; ++l) {
            for (int r = 0; r < repetition[l]; ++r) {
                HashMap<TraceabilityPredicate.SimplePredicate, Integer> cacheLayer = new HashMap<TraceabilityPredicate.SimplePredicate, Integer>();
                for (int y = 0; y < this.thumbLength; ++y) {
                    for (int z = 0; z < this.palmLength; ++z) {
                        TraceabilityPredicate predicate = this.blockMatches[l][y][z];
                        boolean find = false;
                        boolean previewCandidates = false;
                        BlockInfo[] infos = null;
                        for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                            if (limit.minLayerCount <= 0) continue;
                            if (!cacheLayer.containsKey(limit)) {
                                cacheLayer.put(limit, 1);
                            } else {
                                if ((Integer)cacheLayer.get(limit) >= limit.minLayerCount) continue;
                                cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                            }
                            if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                if (!cacheGlobal.containsKey(limit)) {
                                    cacheGlobal.put(limit, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                    cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                }
                            }
                            if (!cacheInfos.containsKey(limit)) {
                                cacheInfos.put(limit, limit.candidates == null ? null : (BlockInfo[])limit.candidates.get());
                            }
                            infos = (BlockInfo[])cacheInfos.get(limit);
                            find = true;
                            previewCandidates = this.gtlitecore$shouldPreviewCandidates(limit);
                            break;
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                if (limit.minGlobalCount == -1 && limit.previewCount == -1) continue;
                                if (cacheGlobal.getOrDefault(limit, 0) < limit.previewCount) {
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.previewCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                } else {
                                    if (limit.minGlobalCount <= 0) continue;
                                    if (!cacheGlobal.containsKey(limit)) {
                                        cacheGlobal.put(limit, 1);
                                    } else {
                                        if ((Integer)cacheGlobal.get(limit) >= limit.minGlobalCount) continue;
                                        cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                    }
                                }
                                if (!cacheInfos.containsKey(limit)) {
                                    cacheInfos.put(limit, limit.candidates == null ? null : (BlockInfo[])limit.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(limit);
                                find = true;
                                previewCandidates = this.gtlitecore$shouldPreviewCandidates(limit);
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
                                if (common.previewCount <= 0) continue;
                                if (!cacheGlobal.containsKey(common)) {
                                    cacheGlobal.put(common, 1);
                                } else {
                                    if ((Integer)cacheGlobal.get(common) >= common.previewCount) continue;
                                    cacheGlobal.put(common, (Integer)cacheGlobal.get(common) + 1);
                                }
                                if (!cacheInfos.containsKey(common)) {
                                    cacheInfos.put(common, common.candidates == null ? null : (BlockInfo[])common.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(common);
                                find = true;
                                previewCandidates = this.gtlitecore$shouldPreviewCandidates(common);
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate common : predicate.common) {
                                if (common.previewCount != -1) continue;
                                if (!cacheInfos.containsKey(common)) {
                                    cacheInfos.put(common, common.candidates == null ? null : (BlockInfo[])common.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(common);
                                find = true;
                                previewCandidates = this.gtlitecore$shouldPreviewCandidates(common);
                                break;
                            }
                        }
                        if (!find) {
                            for (TraceabilityPredicate.SimplePredicate limit : predicate.limited) {
                                if (limit.previewCount != -1) continue;
                                if (limit.maxGlobalCount != -1 || limit.maxLayerCount != -1) {
                                    if (cacheGlobal.getOrDefault(limit, 0) < limit.maxGlobalCount) {
                                        if (!cacheGlobal.containsKey(limit)) {
                                            cacheGlobal.put(limit, 1);
                                        } else {
                                            cacheGlobal.put(limit, (Integer)cacheGlobal.get(limit) + 1);
                                        }
                                    } else {
                                        if (cacheLayer.getOrDefault(limit, 0) >= limit.maxLayerCount) continue;
                                        if (!cacheLayer.containsKey(limit)) {
                                            cacheLayer.put(limit, 1);
                                        } else {
                                            cacheLayer.put(limit, (Integer)cacheLayer.get(limit) + 1);
                                        }
                                    }
                                }
                                if (!cacheInfos.containsKey(limit)) {
                                    cacheInfos.put(limit, limit.candidates == null ? null : (BlockInfo[])limit.candidates.get());
                                }
                                infos = (BlockInfo[])cacheInfos.get(limit);
                                previewCandidates = this.gtlitecore$shouldPreviewCandidates(limit);
                                break;
                            }
                        }
                        BlockInfo info2 = BlockInfo.EMPTY;
                        if (infos != null && infos.length > 0) {
                            int index = previewCandidates ? Math.min(candidateIndex, infos.length - 1) : 0;
                            info2 = infos[index];
                        }
                        BlockPos pos2 = RelativeDirection.setActualRelativeOffset((int)z, (int)y, (int)x, (EnumFacing)EnumFacing.NORTH, (EnumFacing)EnumFacing.UP, (boolean)false, (RelativeDirection[])this.structureDir);
                        if (info2.getTileEntity() instanceof MetaTileEntityHolder) {
                            MetaTileEntityHolder holder = new MetaTileEntityHolder();
                            holder.setMetaTileEntity(((MetaTileEntityHolder)info2.getTileEntity()).getMetaTileEntity());
                            holder.getMetaTileEntity().onPlacement();
                            IBlockState state = holder.getMetaTileEntity().getBlock().func_176223_P();
                            info2 = ((AccessorTraceabilityPredicate)predicate).isCenter() ? new BlockInfo(state, (TileEntity)holder, CENTER_INFO) : new BlockInfo(state, (TileEntity)holder);
                        }
                        blocks.put(pos2, info2);
                        minX = Math.min(pos2.func_177958_n(), minX);
                        minY = Math.min(pos2.func_177956_o(), minY);
                        minZ = Math.min(pos2.func_177952_p(), minZ);
                        maxX = Math.max(pos2.func_177958_n(), maxX);
                        maxY = Math.max(pos2.func_177956_o(), maxY);
                        maxZ = Math.max(pos2.func_177952_p(), maxZ);
                    }
                }
                ++x;
            }
        }
        BlockInfo[][][] result = (BlockInfo[][][])Array.newInstance(BlockInfo.class, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int finalMinX = minX;
        int finalMinY = minY;
        int finalMinZ = minZ;
        blocks.forEach((pos, info) -> {
            if (info.getTileEntity() instanceof MetaTileEntityHolder) {
                MetaTileEntity metaTileEntity = ((MetaTileEntityHolder)info.getTileEntity()).getMetaTileEntity();
                if (!CENTER_INFO.equals(info.getInfo())) {
                    boolean find = false;
                    for (EnumFacing enumFacing : FACINGS) {
                        if (!metaTileEntity.isValidFrontFacing(enumFacing) || blocks.containsKey(pos.func_177972_a(enumFacing))) continue;
                        metaTileEntity.setFrontFacing(enumFacing);
                        find = true;
                        break;
                    }
                    if (!find) {
                        for (EnumFacing enumFacing : FACINGS) {
                            BlockInfo blockInfo = (BlockInfo)blocks.get(pos.func_177972_a(enumFacing));
                            if (blockInfo == null || blockInfo.getBlockState().func_177230_c() != Blocks.field_150350_a || !metaTileEntity.isValidFrontFacing(enumFacing)) continue;
                            metaTileEntity.setFrontFacing(enumFacing);
                            break;
                        }
                    }
                } else {
                    metaTileEntity.setFrontFacing(EnumFacing.SOUTH);
                }
            }
            result[pos.func_177958_n() - finalMinX][pos.func_177956_o() - finalMinY][pos.func_177952_p() - finalMinZ] = info;
        });
        return result;
    }

    @Unique
    private boolean gtlitecore$shouldPreviewCandidates(TraceabilityPredicate.SimplePredicate predicate) {
        if (predicate instanceof GTLitePredicate) {
            return ((GTLitePredicate)predicate).getPreviewCandidates();
        }
        return false;
    }
}

