/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.producer;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtechlite.gtlitecore.api.extension.RecipeBuilderExtKt;
import gregtechlite.gtlitecore.api.item.GTLiteToolHelper;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J(\u0010\u0006\u001a\u00020\u00052\u000e\u0010\u0007\u001a\n0\bR\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/producer/DisposableToolRecipeProducer;", "", "<init>", "()V", "produce", "", "processHardToolRecipe", "toolStack", "Lgregtech/api/items/metaitem/MetaItem$MetaValueItem;", "Lgregtech/api/items/metaitem/MetaItem;", "material", "Lgregtech/api/unification/material/Material;", "cost", "", "getCastingMoldByToolStack", "Lnet/minecraft/item/ItemStack;", "stack", "gtlitecore"})
public final class DisposableToolRecipeProducer {
    @NotNull
    public static final DisposableToolRecipeProducer INSTANCE = new DisposableToolRecipeProducer();

    private DisposableToolRecipeProducer() {
    }

    public final void produce() {
        for (Material material : GregTechAPI.materialManager.getRegisteredMaterials()) {
            MetaItem.MetaValueItem metaValueItem = GTLiteMetaItems.INSTANCE.getDISPOSABLE_SAW();
            Intrinsics.checkNotNull((Object)material);
            this.processHardToolRecipe(metaValueItem, material, 2);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_HARD_HAMMER(), material, 6);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_WRENCH(), material, 4);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_FILE(), material, 2);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_CROWBAR(), material, 2);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SCREWDRIVER(), material, 1);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_MORTAR(), material, 2);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_WIRE_CUTTER(), material, 4);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_KNIFE(), material, 1);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_BUTCHERY_KNIFE(), material, 4);
            this.processHardToolRecipe(GTLiteMetaItems.INSTANCE.getDISPOSABLE_ROLLING_PIN(), material, 2);
        }
        RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.TOOL_CASTER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SOFT_MALLET())).fluidInputs(Materials.Rubber.getFluid(144))).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 42);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[2])).duration(200)).buildAndRegister();
        RecipeBuilder recipeBuilder2 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.TOOL_CASTER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SOFT_MALLET())).fluidInputs(Materials.Polyethylene.getFluid(144))).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 64)).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 20);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder2, GTValues.VA[2])).duration(200)).buildAndRegister();
        RecipeBuilder recipeBuilder3 = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.TOOL_CASTER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SOFT_MALLET())).fluidInputs(Materials.Polytetrafluoroethylene.getFluid(144))).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 64)).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 64)).output(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET(), 40);
        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"output(...)");
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder3, GTValues.VA[2])).duration(200)).buildAndRegister();
    }

    private final void processHardToolRecipe(MetaItem.MetaValueItem toolStack, Material material, int cost) {
        if (material.hasProperty(PropertyKey.TOOL) && material.hasProperty(PropertyKey.FLUID)) {
            int count = GTLiteToolHelper.getMaxCraftingDurability(material) / cost;
            if (count <= 0 || count > 576) {
                return;
            }
            List outputStacks = new ArrayList();
            for (int i = count; i > 64; i -= 64) {
                ItemStack itemStack = toolStack.getStackForm(64);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackForm(...)");
                outputStacks.add(itemStack);
                count -= 64;
            }
            ItemStack itemStack = toolStack.getStackForm(count);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackForm(...)");
            outputStacks.add(itemStack);
            SimpleRecipeBuilder simpleRecipeBuilder = (SimpleRecipeBuilder)GTLiteRecipeMaps.TOOL_CASTER_RECIPES.recipeBuilder();
            ItemStack itemStack2 = toolStack.getStackForm();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackForm(...)");
            RecipeBuilder recipeBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)simpleRecipeBuilder.notConsumable(this.getCastingMoldByToolStack(itemStack2))).fluidInputs(material.getFluid(144))).outputs((Collection)outputStacks);
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"outputs(...)");
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeBuilderExtKt.EUt(recipeBuilder, GTValues.VA[2])).duration(200)).buildAndRegister();
        }
    }

    private final ItemStack getCastingMoldByToolStack(ItemStack stack) {
        ItemStack itemStack;
        if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SAW().getStackForm())) {
            ItemStack itemStack2 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SAW().getStackForm();
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_HARD_HAMMER().getStackForm())) {
            ItemStack itemStack3 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_HARD_HAMMER().getStackForm();
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SOFT_MALLET().getStackForm())) {
            ItemStack itemStack4 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SOFT_MALLET().getStackForm();
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_WRENCH().getStackForm())) {
            ItemStack itemStack5 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_WRENCH().getStackForm();
            itemStack = itemStack5;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_FILE().getStackForm())) {
            ItemStack itemStack6 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_FILE().getStackForm();
            itemStack = itemStack6;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_CROWBAR().getStackForm())) {
            ItemStack itemStack7 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_CROWBAR().getStackForm();
            itemStack = itemStack7;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_SCREWDRIVER().getStackForm())) {
            ItemStack itemStack8 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_SCREWDRIVER().getStackForm();
            itemStack = itemStack8;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack8, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_MORTAR().getStackForm())) {
            ItemStack itemStack9 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_MORTAR().getStackForm();
            itemStack = itemStack9;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack9, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_WIRE_CUTTER().getStackForm())) {
            ItemStack itemStack10 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_WIRE_CUTTER().getStackForm();
            itemStack = itemStack10;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack10, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_KNIFE().getStackForm())) {
            ItemStack itemStack11 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_KNIFE().getStackForm();
            itemStack = itemStack11;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack11, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_BUTCHERY_KNIFE().getStackForm())) {
            ItemStack itemStack12 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_BUTCHERY_KNIFE().getStackForm();
            itemStack = itemStack12;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack12, (String)"getStackForm(...)");
        } else if (stack.func_77969_a(GTLiteMetaItems.INSTANCE.getDISPOSABLE_ROLLING_PIN().getStackForm())) {
            ItemStack itemStack13 = GTLiteMetaItems.INSTANCE.getCASTING_MOLD_ROLLING_PIN().getStackForm();
            itemStack = itemStack13;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack13, (String)"getStackForm(...)");
        } else {
            throw new IllegalArgumentException("Cannot get Casting Mold ItemStack by a invalid Disposable Tool ItemStack");
        }
        return itemStack;
    }
}

