/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.producer;

import com.google.common.collect.UnmodifiableIterator;
import gregtech.api.GTValues;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.loaders.recipe.CraftingComponent;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.material.info.GTLiteMaterialFlags;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J6\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/producer/AlloyBlastRecipeProducer;", "", "<init>", "()V", "produce", "", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/BlastProperty;", "createBuilder", "Lgregtech/api/recipes/builders/BlastRecipeBuilder;", "addInputs", "", "builder", "Lgregtech/api/recipes/RecipeBuilder;", "buildRecipes", "output", "Lnet/minecraftforge/fluids/Fluid;", "outputAmount", "componentAmount", "getCircuitNumber", "getGasCircuitNumber", "Companion", "gtlitecore"})
public class AlloyBlastRecipeProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AlloyBlastRecipeProducer DEFAULT_PRODUCER = new AlloyBlastRecipeProducer();

    public final void produce(@NotNull Material material, @NotNull BlastProperty property) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (material.hasFlag(GTLiteMaterialFlags.INSTANCE.getNO_ALLOY_BLAST_RECIPES())) {
            return;
        }
        int componentAmount = material.getMaterialComponents().size();
        if (componentAmount < 2) {
            return;
        }
        Fluid output = material.getFluid();
        RecipeBuilder builder = (RecipeBuilder)this.createBuilder(property, material);
        int outputAmount = this.addInputs(material, (RecipeBuilder<BlastRecipeBuilder>)builder);
        if (outputAmount <= 0) {
            return;
        }
        Intrinsics.checkNotNull((Object)output);
        this.buildRecipes(property, output, outputAmount, componentAmount, (RecipeBuilder<BlastRecipeBuilder>)builder);
    }

    @NotNull
    public BlastRecipeBuilder createBuilder(@NotNull BlastProperty property, @NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        BlastRecipeBuilder builder = (BlastRecipeBuilder)GTLiteRecipeMaps.ALLOY_BLAST_RECIPES.recipeBuilder();
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = (int)Math.max(1.0, (double)((int)(material.getMass() * (long)property.getBlastTemperature() / 100L)));
        }
        builder.duration(duration);
        int eUt = property.getEUtOverride();
        if (eUt < 0) {
            eUt = GTValues.VA[2];
        }
        builder.EUt((long)eUt);
        BlastRecipeBuilder blastRecipeBuilder = builder.blastFurnaceTemp(property.getBlastTemperature());
        Intrinsics.checkNotNullExpressionValue((Object)blastRecipeBuilder, (String)"blastFurnaceTemp(...)");
        return blastRecipeBuilder;
    }

    public int addInputs(@NotNull Material material, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        int outputAmount = 0;
        int fluidAmount = 0;
        UnmodifiableIterator unmodifiableIterator = material.getMaterialComponents().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            BlastRecipeBuilder blastRecipeBuilder;
            MaterialStack ms = (MaterialStack)unmodifiableIterator2.next();
            Material msMat = ms.material;
            int msAmount = (int)ms.amount;
            if (msMat.hasProperty(PropertyKey.DUST)) {
                blastRecipeBuilder = (BlastRecipeBuilder)builder.input(OrePrefix.dust, msMat, msAmount);
            } else if (msMat.hasProperty(PropertyKey.FLUID)) {
                if (fluidAmount >= 2) {
                    return -1;
                }
                ++fluidAmount;
                blastRecipeBuilder = (BlastRecipeBuilder)builder.fluidInputs(msMat.getFluid(1000 * msAmount));
            } else {
                return -1;
            }
            outputAmount += msAmount;
        }
        return outputAmount;
    }

    public void buildRecipes(@NotNull BlastProperty property, @NotNull Fluid output, int outputAmount, int componentAmount, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        builder.fluidOutputs(new FluidStack(output, 144 * outputAmount));
        int duration = builder.getDuration() * outputAmount * 3 / 4;
        if (property.getGasTier() != null) {
            RecipeBuilder recipeBuilder = builder.copy();
            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"copy(...)");
            RecipeBuilder builderGas = recipeBuilder;
            FluidStack gas = (FluidStack)CraftingComponent.EBF_GASES.get(property.getGasTier());
            BlastRecipeBuilder blastRecipeBuilder = (BlastRecipeBuilder)builderGas.circuitMeta(this.getGasCircuitNumber(componentAmount));
            Intrinsics.checkNotNull((Object)gas, (String)"null cannot be cast to non-null type net.minecraftforge.fluids.FluidStack");
            ((BlastRecipeBuilder)((BlastRecipeBuilder)blastRecipeBuilder.fluidInputs(new FluidStack(gas, gas.amount * outputAmount))).duration((int)((double)duration * 0.67))).buildAndRegister();
        }
        ((BlastRecipeBuilder)((BlastRecipeBuilder)builder.circuitMeta(this.getCircuitNumber(componentAmount))).duration(duration)).buildAndRegister();
    }

    public int getCircuitNumber(int componentAmount) {
        return componentAmount;
    }

    public int getGasCircuitNumber(int componentAmount) {
        return componentAmount + 10;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/producer/AlloyBlastRecipeProducer$Companion;", "", "<init>", "()V", "DEFAULT_PRODUCER", "Lgregtechlite/gtlitecore/loader/recipe/producer/AlloyBlastRecipeProducer;", "getDEFAULT_PRODUCER", "()Lgregtechlite/gtlitecore/loader/recipe/producer/AlloyBlastRecipeProducer;", "gtlitecore"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AlloyBlastRecipeProducer getDEFAULT_PRODUCER() {
            return DEFAULT_PRODUCER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

