/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import com.google.common.collect.ImmutableMap;
import gregtech.api.GTValues;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002RP\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/WireRecipeHandler;", "", "<init>", "()V", "INSULATION_AMOUNT", "Lcom/google/common/collect/ImmutableMap;", "Lgregtech/api/unification/ore/OrePrefix;", "kotlin.jvm.PlatformType", "", "Lcom/google/common/collect/ImmutableMap;", "init", "", "generateCableCovering", "wirePrefix", "material", "Lgregtech/api/unification/material/Material;", "properties", "Lgregtech/api/unification/material/properties/WireProperties;", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nWireRecipeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireRecipeHandler.kt\ngregtechlite/gtlitecore/loader/recipe/handler/WireRecipeHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class WireRecipeHandler {
    @NotNull
    public static final WireRecipeHandler INSTANCE = new WireRecipeHandler();
    private static final ImmutableMap<OrePrefix, Integer> INSULATION_AMOUNT = ImmutableMap.of((Object)OrePrefix.cableGtSingle, (Object)1, (Object)OrePrefix.cableGtDouble, (Object)1, (Object)OrePrefix.cableGtQuadruple, (Object)2, (Object)OrePrefix.cableGtOctal, (Object)3, (Object)OrePrefix.cableGtHex, (Object)5);

    private WireRecipeHandler() {
    }

    public final void init() {
        OrePrefix.wireGtSingle.addProcessingHandler(PropertyKey.WIRE, this::generateCableCovering);
        OrePrefix.wireGtDouble.addProcessingHandler(PropertyKey.WIRE, this::generateCableCovering);
        OrePrefix.wireGtQuadruple.addProcessingHandler(PropertyKey.WIRE, this::generateCableCovering);
        OrePrefix.wireGtOctal.addProcessingHandler(PropertyKey.WIRE, this::generateCableCovering);
        OrePrefix.wireGtHex.addProcessingHandler(PropertyKey.WIRE, this::generateCableCovering);
    }

    private final void generateCableCovering(OrePrefix wirePrefix, Material material, WireProperties properties) {
        SimpleRecipeBuilder builder;
        Object v0;
        Object object;
        Object object2;
        block20: {
            object2 = KClasses.getDeclaredFunctions((KClass)Reflection.getOrCreateKotlinClass(gregtech.loaders.recipe.handlers.WireRecipeHandler.class));
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                KFunction it = (KFunction)object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"generateManualRecipe")) continue;
                v0 = object;
                break block20;
            }
            v0 = null;
        }
        KFunction kFunction = v0;
        if (kFunction == null) {
            throw new IllegalArgumentException("Method 'generateManualRecipe()' is not found in target class [gregtech.loaders.recipe.handlers.WireRecipeHandler]");
        }
        KFunction targetMethod = kFunction;
        KCallablesJvm.setAccessible((KCallable)((KCallable)targetMethod), (boolean)true);
        if (properties.isSuperconductor()) {
            return;
        }
        int cableAmount = (int)(wirePrefix.getMaterialAmount(material) * (long)2 / 3628800L);
        StringBuilder stringBuilder = new StringBuilder().append("cable");
        String string = wirePrefix.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        object2 = string;
        int n = 4;
        String string2 = ((String)object2).substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        OrePrefix cablePrefix = OrePrefix.getPrefix((String)stringBuilder.append(string2).toString());
        byte voltageTier = GTUtility.getTierByVoltage((long)properties.getVoltage());
        Object object3 = INSULATION_AMOUNT.get((Object)cablePrefix);
        Intrinsics.checkNotNull((Object)object3);
        int insulationAmount = ((Number)object3).intValue();
        if (voltageTier <= 1) {
            object = new Object[]{wirePrefix, material, cablePrefix, cableAmount};
            targetMethod.call(object);
        }
        if (voltageTier <= 4) {
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LAMINATOR_RECIPES.recipeBuilder()).input(wirePrefix, material)).fluidInputs(Materials.Rubber.getFluid(144 * insulationAmount))).output(cablePrefix, material)).EUt((long)GTValues.VA[0])).duration(100);
            if (voltageTier == 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            builder.buildAndRegister();
        }
        if (voltageTier <= 8) {
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LAMINATOR_RECIPES.recipeBuilder()).input(wirePrefix, material)).output(cablePrefix, material)).EUt((long)GTValues.VA[0])).duration(100);
            if (voltageTier >= 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
            }
            ((SimpleRecipeBuilder)builder.fluidInputs(Materials.SiliconeRubber.getFluid(144 * insulationAmount / 2))).buildAndRegister();
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LAMINATOR_RECIPES.recipeBuilder()).input(wirePrefix, material)).output(cablePrefix, material)).EUt((long)GTValues.VA[0])).duration(100);
            if (voltageTier >= 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
            }
            ((SimpleRecipeBuilder)builder.fluidInputs(Materials.StyreneButadieneRubber.getFluid(144 * insulationAmount / 4))).buildAndRegister();
        }
        if (voltageTier <= 13) {
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LAMINATOR_RECIPES.recipeBuilder()).input(wirePrefix, material)).output(cablePrefix, material)).EUt((long)GTValues.VA[0])).duration(100);
            if (voltageTier >= 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
            }
            if (voltageTier >= 8) {
                builder.input(OrePrefix.foil, GTLiteMaterials.INSTANCE.getPolyetheretherketone(), insulationAmount);
            }
            if (voltageTier >= 10) {
                builder.input(OrePrefix.foil, GTLiteMaterials.INSTANCE.getZylon(), insulationAmount);
            }
            ((SimpleRecipeBuilder)builder.fluidInputs(GTLiteMaterials.INSTANCE.getPolytetramethyleneGlycolRubber().getFluid(144 * insulationAmount / 2))).buildAndRegister();
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LAMINATOR_RECIPES.recipeBuilder()).input(wirePrefix, material)).output(cablePrefix, material)).EUt((long)GTValues.VA[0])).duration(100);
            if (voltageTier >= 4) {
                builder.input(OrePrefix.foil, Materials.PolyvinylChloride, insulationAmount);
            }
            if (voltageTier >= 6) {
                builder.input(OrePrefix.foil, Materials.PolyphenyleneSulfide, insulationAmount);
            }
            if (voltageTier >= 8) {
                builder.input(OrePrefix.foil, GTLiteMaterials.INSTANCE.getPolyetheretherketone(), insulationAmount);
            }
            if (voltageTier >= 10) {
                builder.input(OrePrefix.foil, GTLiteMaterials.INSTANCE.getZylon(), insulationAmount);
            }
            ((SimpleRecipeBuilder)builder.fluidInputs(GTLiteMaterials.INSTANCE.getPolyphosphonitrileFluoroRubber().getFluid(144 * insulationAmount / 4))).buildAndRegister();
        }
    }
}

