/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bRP\u0010\t\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/WireCombinationHandler;", "", "<init>", "()V", "WIRE_DOUBLING_ORDER", "", "Lgregtech/api/unification/ore/OrePrefix;", "kotlin.jvm.PlatformType", "[Lgregtech/api/unification/ore/OrePrefix;", "cableToWireMap", "Lcom/google/common/collect/ImmutableMap;", "Lcom/google/common/collect/ImmutableMap;", "init", "", "processWireCompression", "wirePrefix", "material", "Lgregtech/api/unification/material/Material;", "properties", "Lgregtech/api/unification/material/properties/WireProperties;", "generateWireCombiningRecipe", "property", "processCableStripping", "prefix", "gtlitecore"})
public final class WireCombinationHandler {
    @NotNull
    public static final WireCombinationHandler INSTANCE = new WireCombinationHandler();
    @NotNull
    private static final OrePrefix[] WIRE_DOUBLING_ORDER;
    private static final ImmutableMap<OrePrefix, OrePrefix> cableToWireMap;

    private WireCombinationHandler() {
    }

    public final void init() {
        OrePrefix.wireGtSingle.addProcessingHandler(PropertyKey.WIRE, this::processWireCompression);
        for (OrePrefix wirePrefix : WIRE_DOUBLING_ORDER) {
            wirePrefix.addProcessingHandler(PropertyKey.WIRE, this::generateWireCombiningRecipe);
        }
        UnmodifiableIterator unmodifiableIterator = ((ImmutableSet)cableToWireMap.keySet()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            OrePrefix cablePrefix = (OrePrefix)unmodifiableIterator2.next();
            cablePrefix.addProcessingHandler(PropertyKey.WIRE, this::processCableStripping);
        }
    }

    private final void processWireCompression(OrePrefix wirePrefix, Material material, WireProperties properties) {
        for (int startTier = 0; startTier < 4; ++startTier) {
            int n = 5 - startTier;
            for (int i = 1; i < n; ++i) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LOOM_RECIPES.recipeBuilder()).circuitMeta((int)Math.pow(2.0, i))).inputs(OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[startTier], (Material)material, (int)(1 << i)))).outputs(OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[startTier + i], (Material)material, (int)1))).EUt(12L)).duration(10)).buildAndRegister();
            }
        }
        for (int i = 1; i < 5; ++i) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.LOOM_RECIPES.recipeBuilder()).circuitMeta(1)).inputs(OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[i], (Material)material, (int)1))).outputs(OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[0], (Material)material, (int)((int)Math.pow(2.0, i))))).EUt(12L)).duration(10)).buildAndRegister();
        }
    }

    private final void generateWireCombiningRecipe(OrePrefix wirePrefix, Material material, WireProperties property) {
        Object[] objectArray;
        Object[] objectArray2;
        String string;
        int wireIndex = ArrayUtils.indexOf((Object[])WIRE_DOUBLING_ORDER, (Object)wirePrefix);
        if (wireIndex < WIRE_DOUBLING_ORDER.length - 1) {
            string = "%s_wire_%s_doubling";
            objectArray2 = new Object[]{material, wirePrefix};
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            objectArray = new Object[]{new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material)};
            ModHandler.addShapelessRecipe((String)string2, (ItemStack)OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[wireIndex + 1], (Material)material), (Object[])objectArray);
        }
        if (wireIndex > 0) {
            string = "%s_wire_%s_splitting";
            objectArray2 = new Object[]{material, wirePrefix};
            String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            objectArray = new Object[]{new UnificationEntry(wirePrefix, material)};
            ModHandler.addShapelessRecipe((String)string3, (ItemStack)OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[wireIndex - 1], (Material)material, (int)2), (Object[])objectArray);
        }
        if (wireIndex < 3) {
            string = "%s_wire_%s_quadrupling";
            objectArray2 = new Object[]{material, wirePrefix};
            String string4 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            objectArray = new Object[]{new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material), new UnificationEntry(wirePrefix, material)};
            ModHandler.addShapelessRecipe((String)string4, (ItemStack)OreDictUnifier.get((OrePrefix)WIRE_DOUBLING_ORDER[wireIndex + 2], (Material)material), (Object[])objectArray);
        }
    }

    private final void processCableStripping(OrePrefix prefix, Material material, WireProperties property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder()).input(prefix, material)).output((OrePrefix)cableToWireMap.get((Object)prefix), material)).output(OrePrefix.plate, Materials.Rubber, (int)(((MaterialStack)prefix.secondaryMaterials.get((int)0)).amount / 3628800L))).EUt((long)GTValues.VA[0])).duration(100)).buildAndRegister();
    }

    static {
        OrePrefix[] orePrefixArray = new OrePrefix[]{OrePrefix.wireGtSingle, OrePrefix.wireGtDouble, OrePrefix.wireGtQuadruple, OrePrefix.wireGtOctal, OrePrefix.wireGtHex};
        WIRE_DOUBLING_ORDER = orePrefixArray;
        cableToWireMap = ImmutableMap.of((Object)OrePrefix.cableGtSingle, (Object)OrePrefix.wireGtSingle, (Object)OrePrefix.cableGtDouble, (Object)OrePrefix.wireGtDouble, (Object)OrePrefix.cableGtQuadruple, (Object)OrePrefix.wireGtQuadruple, (Object)OrePrefix.cableGtOctal, (Object)OrePrefix.wireGtOctal, (Object)OrePrefix.cableGtHex, (Object)OrePrefix.wireGtHex);
    }
}

