/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.ToolItems;
import gregtechlite.gtlitecore.api.unification.material.properties.GTLiteToolPropertyAdder;
import gregtechlite.gtlitecore.common.item.GTLiteToolItems;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0002J9\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/ToolRecipeHandler;", "", "<init>", "()V", "init", "", "registerCustomToolRecipes", "processTool", "toolPrefix", "Lgregtech/api/unification/ore/OrePrefix;", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/ToolProperty;", "registerSoftToolRecipes", "addToolRecipe", "tool", "Lgregtech/api/items/toolitem/IGTTool;", "mirrored", "", "recipe", "", "(Lgregtech/api/unification/material/Material;Lgregtech/api/items/toolitem/IGTTool;Z[Ljava/lang/Object;)V", "gtlitecore"})
public final class ToolRecipeHandler {
    @NotNull
    public static final ToolRecipeHandler INSTANCE = new ToolRecipeHandler();

    private ToolRecipeHandler() {
    }

    public final void init() {
        OrePrefix.ingot.addProcessingHandler(PropertyKey.TOOL, this::processTool);
    }

    public final void registerCustomToolRecipes() {
        this.registerSoftToolRecipes();
    }

    private final void processTool(OrePrefix toolPrefix, Material material, ToolProperty property) {
        if (material.hasProperty(PropertyKey.INGOT)) {
            Object[] objectArray = new MaterialFlag[]{MaterialFlags.GENERATE_PLATE};
            if (material.hasFlags((MaterialFlag[])objectArray)) {
                objectArray = new Object[]{"PhP", "IPI", "fP ", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material)};
                this.addToolRecipe(material, GTLiteToolItems.INSTANCE.getCOMBINATION_WRENCH(), true, objectArray);
            }
            if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
                objectArray = new Object[]{"  R", " I ", "R f", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material)};
                this.addToolRecipe(material, GTLiteToolItems.INSTANCE.getROLLING_PIN(), true, objectArray);
                objectArray = new Object[]{"hII", "III", "RIf", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material)};
                this.addToolRecipe(material, GTLiteToolItems.INSTANCE.getCLUB(), true, objectArray);
            }
            if (material.hasFlags((MaterialFlag[])(objectArray = new MaterialFlag[]{MaterialFlags.GENERATE_PLATE})) && material.hasFlags((MaterialFlag[])(objectArray = new MaterialFlag[]{MaterialFlags.GENERATE_ROD}))) {
                objectArray = new Object[]{"hPP", "DRP", "RDf", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('D'), new UnificationEntry(OrePrefix.dye, (Material)MarkerMaterials.Color.Blue)};
                this.addToolRecipe(material, GTLiteToolItems.INSTANCE.getUNIVERSAL_SPADE(), true, objectArray);
            }
            if (material.hasFlags((MaterialFlag[])(objectArray = new MaterialFlag[]{MaterialFlags.GENERATE_SPRING_SMALL})) && material.hasFlags((MaterialFlag[])(objectArray = new MaterialFlag[]{MaterialFlags.GENERATE_SMALL_GEAR})) && !Intrinsics.areEqual((Object)material, (Object)Materials.Steel)) {
                objectArray = new Object[]{" G ", " F ", " S ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gearSmall, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.springSmall, material), Character.valueOf('F'), new ItemStack(Items.field_151145_ak)};
                this.addToolRecipe(material, GTLiteToolItems.INSTANCE.getFLINT_AND_STEEL(), false, objectArray);
            }
        }
    }

    private final void registerSoftToolRecipes() {
        List<Pair<Material, Integer>> softMaterials = GTLiteToolPropertyAdder.INSTANCE.getSoftMaterials();
        UnificationEntry stick = new UnificationEntry(OrePrefix.stick, Materials.Wood);
        for (Pair<Material, Integer> mat : softMaterials) {
            Material material = (Material)mat.getFirst();
            IGTTool iGTTool = ToolItems.SOFT_MALLET;
            Intrinsics.checkNotNullExpressionValue((Object)iGTTool, (String)"SOFT_MALLET");
            Object[] objectArray = new Object[]{"II ", "IIS", "II ", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material), Character.valueOf('S'), stick};
            this.addToolRecipe(material, iGTTool, true, objectArray);
            IGTTool iGTTool2 = ToolItems.PLUNGER;
            Intrinsics.checkNotNullExpressionValue((Object)iGTTool2, (String)"PLUNGER");
            objectArray = new Object[]{"xPP", " SP", "S f", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), stick};
            this.addToolRecipe(material, iGTTool2, true, objectArray);
        }
    }

    private final void addToolRecipe(Material material, IGTTool tool, boolean mirrored, Object ... recipe) {
        String toolId = tool.getToolId();
        ItemStack toolMaterial = tool.get(material);
        if (mirrored) {
            String string = "%s_%s";
            Object[] objectArray = new Object[]{toolId, material};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            ModHandler.addMirroredShapedRecipe((String)string2, (ItemStack)toolMaterial, (Object[])Arrays.copyOf(recipe, recipe.length));
        } else {
            String string = "%s_%s";
            Object[] objectArray = new Object[]{toolId, material};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            ModHandler.addShapedRecipe((String)string3, (ItemStack)toolMaterial, (Object[])Arrays.copyOf(recipe, recipe.length));
        }
    }
}

