/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DyeUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteOrePrefix;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001aH\u0002J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001aH\u0002J\u001e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006%"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/PartsRecipeHandler;", "", "<init>", "()V", "init", "", "processStick", "stickPrefix", "Lgregtech/api/unification/ore/OrePrefix;", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/DustProperty;", "processLens", "lensPrefix", "Lgregtech/api/unification/material/properties/GemProperty;", "processStickLong", "stickLongPrefix", "processBolt", "boltPrefix", "processScrew", "screwPrefix", "processRing", "ringPrefix", "processRound", "roundPrefix", "Lgregtech/api/unification/material/properties/IngotProperty;", "processDrillHead", "drillHeadPrefix", "processTurbineBlade", "turbineBladePrefix", "processSheetedFrame", "sheetedFramePrefix", "processWall", "wallGtPrefix", "getVoltageMultiplier", "", "gtlitecore"})
public final class PartsRecipeHandler {
    @NotNull
    public static final PartsRecipeHandler INSTANCE = new PartsRecipeHandler();

    private PartsRecipeHandler() {
    }

    public final void init() {
        OrePrefix.stick.addProcessingHandler(PropertyKey.DUST, this::processStick);
        OrePrefix.lens.addProcessingHandler(PropertyKey.GEM, this::processLens);
        OrePrefix.stickLong.addProcessingHandler(PropertyKey.DUST, this::processStickLong);
        OrePrefix.bolt.addProcessingHandler(PropertyKey.DUST, this::processBolt);
        OrePrefix.screw.addProcessingHandler(PropertyKey.DUST, this::processScrew);
        OrePrefix.ring.addProcessingHandler(PropertyKey.DUST, this::processRing);
        OrePrefix.round.addProcessingHandler(PropertyKey.INGOT, this::processRound);
        OrePrefix.toolHeadDrill.addProcessingHandler(PropertyKey.INGOT, this::processDrillHead);
        OrePrefix.turbineBlade.addProcessingHandler(PropertyKey.INGOT, this::processTurbineBlade);
        GTLiteOrePrefix.sheetedFrame.addProcessingHandler(PropertyKey.DUST, this::processSheetedFrame);
        GTLiteOrePrefix.wallGt.addProcessingHandler(PropertyKey.DUST, this::processWall);
    }

    private final void processStick(OrePrefix stickPrefix, Material material, DustProperty property) {
        SimpleRecipeBuilder builder;
        int workingTier = material.getWorkingTier();
        if (material.hasProperty(PropertyKey.GEM)) {
            builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder()).input(OrePrefix.ingot, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VH[1], (int)workingTier))).duration((int)Math.max(material.getMass() * (long)2, 1L));
            SimpleRecipeBuilder simpleRecipeBuilder = ConfigHolder.recipes.harderRods ? (SimpleRecipeBuilder)((SimpleRecipeBuilder)builder.output(stickPrefix, material)).output(OrePrefix.dustSmall, material, 2) : (SimpleRecipeBuilder)builder.output(OrePrefix.stick, material, 2);
            builder.buildAndRegister();
        }
        if (material.hasProperty(PropertyKey.INGOT)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder()).input(OrePrefix.ingot, material)).duration((int)Math.max(material.getMass() * (long)2, 1L))).EUt(GTUtility.scaleVoltage((long)GTValues.VH[1], (int)workingTier));
                SimpleRecipeBuilder simpleRecipeBuilder = ConfigHolder.recipes.harderRods ? (SimpleRecipeBuilder)((SimpleRecipeBuilder)builder.output(stickPrefix, material)).output(OrePrefix.dustSmall, material, 2) : (SimpleRecipeBuilder)builder.output(stickPrefix, material, 2);
                builder.buildAndRegister();
            } else {
                SimpleRecipeBuilder simpleRecipeBuilder;
                builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.SLICER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSLICER_BLADE_STRIPES())).input(OrePrefix.ingot, material)).duration((int)Math.max(material.getMass() * (long)2, 1L))).EUt((long)GTValues.VH[1]);
                if (ConfigHolder.recipes.harderRods) {
                    builder.output(OrePrefix.stick, material);
                    simpleRecipeBuilder = (SimpleRecipeBuilder)builder.output(OrePrefix.dustSmall, material, 2);
                } else {
                    simpleRecipeBuilder = (SimpleRecipeBuilder)builder.output(OrePrefix.stick, material, 2);
                }
                builder.buildAndRegister();
            }
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = OreDictUnifier.get((OrePrefix)OrePrefix.bolt, (Material)material);
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).input(stickPrefix, material)).outputs(GTUtility.copy((int)4, (ItemStack)boltStack))).duration((int)Math.max(material.getMass() * (long)2, 1L))).EUt(GTUtility.scaleVoltage((long)4L, (int)workingTier))).buildAndRegister();
            } else if (!material.hasProperty(PropertyKey.GEM)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.SLICER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSLICER_BLADE_OCTAGONAL())).input(stickPrefix, material)).outputs(GTUtility.copy((int)4, (ItemStack)boltStack))).duration((int)Math.max(material.getMass() * (long)2, 1L))).EUt(GTUtility.scaleVoltage((long)4L, (int)workingTier))).buildAndRegister();
            }
            if (workingTier <= 3) {
                String string = "bolt_saw_%s";
                Object[] objectArray = new Object[]{material};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                Object[] objectArray2 = new Object[]{"s ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material)};
                ModHandler.addShapedRecipe((String)string2, (ItemStack)GTUtility.copy((int)2, (ItemStack)boltStack), (Object[])objectArray2);
            }
        }
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROD)).fluidInputs(material.getFluid(72))).output(stickPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(145)).buildAndRegister();
        }
    }

    private final void processLens(OrePrefix lensPrefix, Material material, GemProperty property) {
        int workingTier = material.getWorkingTier();
        ItemStack itemStack = OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)material);
        Intrinsics.checkNotNull((Object)itemStack);
        if (!itemStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.POLISHER_RECIPES.recipeBuilder()).input(OrePrefix.plate, material)).output(lensPrefix, material)).output(OrePrefix.dustSmall, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[2], (int)workingTier))).duration(1200)).buildAndRegister();
        }
        ItemStack itemStack2 = OreDictUnifier.get((OrePrefix)OrePrefix.gemExquisite, (Material)material);
        Intrinsics.checkNotNull((Object)itemStack2);
        if (!itemStack2.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.POLISHER_RECIPES.recipeBuilder()).input(OrePrefix.gemExquisite, material)).output(lensPrefix, material)).output(OrePrefix.dust, material, 2)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(2400)).buildAndRegister();
        }
        ItemStack itemStack3 = OreDictUnifier.get((OrePrefix)GTLiteOrePrefix.gemSolitary, (Material)material);
        Intrinsics.checkNotNull((Object)itemStack3);
        if (!itemStack3.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.POLISHER_RECIPES.recipeBuilder()).input(GTLiteOrePrefix.gemSolitary, material)).output(lensPrefix, material, 2)).output(OrePrefix.dust, material, 4)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[2], (int)workingTier))).duration(1200)).buildAndRegister();
        }
        ItemStack lensStack = OreDictUnifier.get((OrePrefix)lensPrefix, (Material)material);
        Material material2 = material;
        if (Intrinsics.areEqual((Object)material2, (Object)Materials.Diamond)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.LightBlue));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Ruby)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Red));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Emerald)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Green));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Glass)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (String)(OrePrefix.craftingLens.name() + material.toCamelCaseString()));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Uvarovite)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Lime));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Malachite)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Green));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Andradite)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Brown));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.GreenSapphire)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Lime));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Pyrope)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Purple));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Rutile)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Pink));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Spessartine)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Red));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Olivine)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Lime));
        } else if (Intrinsics.areEqual((Object)material2, (Object)Materials.Amethyst)) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Purple));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getTanzanite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Purple));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getAlbite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Pink));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getFluorite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Green));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getCelestine())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Cyan));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getBaddeleyite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Cyan));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getNephelite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Red));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getCryolite())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.LightBlue));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getJade())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Green));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getHeterodiamond())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Purple));
        } else if (Intrinsics.areEqual((Object)material2, (Object)GTLiteMaterials.INSTANCE.getHexagonalSiliconNitride())) {
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)MarkerMaterials.Color.Purple));
        } else {
            EnumDyeColor enumDyeColor = DyeUtil.determineDyeColor((int)material.getMaterialRGB());
            Intrinsics.checkNotNullExpressionValue((Object)enumDyeColor, (String)"determineDyeColor(...)");
            EnumDyeColor dyeColor = enumDyeColor;
            MarkerMaterial colorMaterial = (MarkerMaterial)MarkerMaterials.Color.COLORS.get((Object)dyeColor);
            OreDictUnifier.registerOre((ItemStack)lensStack, (OrePrefix)OrePrefix.craftingLens, (Material)((Material)colorMaterial));
        }
    }

    private final void processStickLong(OrePrefix stickLongPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROD_LONG)).fluidInputs(material.getFluid(144))).output(stickLongPrefix, material)).EUt(GTUtility.scaleVoltage((long)Math.max((long)GTValues.VA[2], (long)16 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(300)).buildAndRegister();
        }
    }

    private final void processBolt(OrePrefix boltPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_BOLT)).fluidInputs(material.getFluid(18))).output(boltPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(45)).buildAndRegister();
        }
    }

    private final void processScrew(OrePrefix screwPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_MOLD_SCREW())).fluidInputs(material.getFluid(18))).output(screwPrefix, material)).EUt(GTUtility.scaleVoltage((long)Math.max((long)GTValues.VA[2], (long)4 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(45)).buildAndRegister();
        }
    }

    private final void processRing(OrePrefix ringPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_RING)).fluidInputs(material.getFluid(36))).output(ringPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(100)).buildAndRegister();
        }
    }

    private final void processRound(OrePrefix roundPrefix, Material material, IngotProperty property) {
        ItemStack itemStack;
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROUND)).fluidInputs(material.getFluid(18))).output(roundPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(45)).buildAndRegister();
        }
        Object object = (itemStack = OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)material)) instanceof ItemStack ? itemStack : null;
        Intrinsics.checkNotNull((Object)object);
        if (!object.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_EXTRUDER_ROUND())).input(OrePrefix.ingot, material)).output(roundPrefix, material, 4)).EUt(GTUtility.scaleVoltage((long)Math.max((long)GTValues.VA[2], (long)4 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(40)).buildAndRegister();
        } else {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_EXTRUDER_ROUND())).input(OrePrefix.dust, material)).output(roundPrefix, material, 4)).EUt(GTUtility.scaleVoltage((long)Math.max((long)GTValues.VA[2], (long)4 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(40)).buildAndRegister();
        }
    }

    private final void processDrillHead(OrePrefix drillHeadPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_MOLD_DRILL_HEAD())).fluidInputs(material.getFluid(576))).output(drillHeadPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[2], (int)workingTier))).duration(100)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_EXTRUDER_DRILL_HEAD())).input(OrePrefix.ingot, material, 4)).output(drillHeadPrefix, material, 1)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[2], (int)workingTier))).duration(100)).buildAndRegister();
    }

    private final void processTurbineBlade(OrePrefix turbineBladePrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_MOLD_TURBINE_BLADE())).fluidInputs(material.getFluid(864))).output(turbineBladePrefix, material)).EUt(GTUtility.scaleVoltage((long)Math.max((long)GTValues.VA[2], (long)6 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(400)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSHAPE_EXTRUDER_TURBINE_BLADE())).input(OrePrefix.ingot, material, 6)).output(turbineBladePrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[2], (int)workingTier))).duration(400)).buildAndRegister();
    }

    public final void processSheetedFrame(@NotNull OrePrefix sheetedFramePrefix, @NotNull Material material, @NotNull DustProperty property) {
        Intrinsics.checkNotNullParameter((Object)sheetedFramePrefix, (String)"sheetedFramePrefix");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (!material.hasFlag(MaterialFlags.GENERATE_FRAME)) {
            return;
        }
        String string = "%s_sheeted_frame";
        Object[] objectArray = new Object[]{material};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Object[] objectArray2 = new Object[]{"PFP", "PhP", "PFP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, material)};
        ModHandler.addShapedRecipe((String)string2, (ItemStack)OreDictUnifier.get((OrePrefix)sheetedFramePrefix, (Material)material, (int)12), (Object[])objectArray2);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(10)).input(OrePrefix.plate, material, 3)).input(OrePrefix.frameGt, material, 1)).output(sheetedFramePrefix, material, 6)).EUt((long)GTValues.VA[0])).duration(45)).buildAndRegister();
    }

    public final void processWall(@NotNull OrePrefix wallGtPrefix, @NotNull Material material, @NotNull DustProperty property) {
        Intrinsics.checkNotNullParameter((Object)wallGtPrefix, (String)"wallGtPrefix");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (!material.hasFlag(MaterialFlags.GENERATE_PLATE) || !material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            return;
        }
        String string = "%s_wall_gt";
        Object[] objectArray = new Object[]{material};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Object[] objectArray2 = new Object[]{"hPS", "P P", "SPd", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material)};
        ModHandler.addShapedRecipe((String)string2, (ItemStack)OreDictUnifier.get((OrePrefix)wallGtPrefix, (Material)material, (int)6), (Object[])objectArray2);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(11)).input(OrePrefix.plate, material, 2)).input(OrePrefix.screw, material, 1)).output(wallGtPrefix, material, 3)).EUt((long)GTValues.VA[0])).duration(45)).buildAndRegister();
    }

    private final long getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? (long)GTValues.VA[1] : (long)GTValues.VA[0];
    }
}

