/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtechlite.gtlitecore.api.unification.GTLiteMaterials;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteOrePrefix;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/OreRecipeHandler;", "", "<init>", "()V", "init", "", "processCrushedPurified", "purifiedPrefix", "Lgregtech/api/unification/ore/OrePrefix;", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/OreProperty;", "processCrushedOre", "crushedPrefix", "processMetalSmelting", "doesMaterialUseNormalFurnace", "", "gtlitecore"})
public final class OreRecipeHandler {
    @NotNull
    public static final OreRecipeHandler INSTANCE = new OreRecipeHandler();

    private OreRecipeHandler() {
    }

    public final void init() {
        OrePrefix.crushedPurified.addProcessingHandler(PropertyKey.ORE, this::processCrushedPurified);
        if (ConfigHolder.worldgen.allUniqueStoneTypes) {
            GTLiteOrePrefix.oreLimestone.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreKomatiite.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreGreenSchist.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreBlueSchist.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreKimberlite.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreQuartzite.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreSlate.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
            GTLiteOrePrefix.oreShale.addProcessingHandler(PropertyKey.ORE, gregtech.loaders.recipe.handlers.OreRecipeHandler::processOre);
        }
        OrePrefix.crushed.addProcessingHandler(PropertyKey.ORE, this::processCrushedOre);
    }

    private final void processCrushedPurified(OrePrefix purifiedPrefix, Material material, OreProperty property) {
        ItemStack itemStack = OreDictUnifier.get((OrePrefix)OrePrefix.crushedCentrifuged, (Material)material);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"get(...)");
        ItemStack crushedCentrifugedStack = itemStack;
        ItemStack dustStack = OreDictUnifier.get((OrePrefix)OrePrefix.dustPure, (Material)material);
        Material material2 = property.getOreByProduct(1, material);
        Intrinsics.checkNotNullExpressionValue((Object)material2, (String)"getOreByProduct(...)");
        Material byproductMaterial = material2;
        ItemStack byproductStack = OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)byproductMaterial);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder()).input(purifiedPrefix, material)).outputs(dustStack)).EUt((long)GTValues.VH[1])).duration(10)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).input(purifiedPrefix, material)).outputs(dustStack)).chancedOutput(byproductStack, 1400, 850)).duration(400)).buildAndRegister();
        String string = "purified_ore_to_dust_%s";
        Object[] objectArray = new Object[]{material};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Object[] objectArray2 = new Object[]{Character.valueOf('h'), new UnificationEntry(purifiedPrefix, material)};
        ModHandler.addShapelessRecipe((String)string2, (ItemStack)dustStack, (Object[])objectArray2);
        if (!crushedCentrifugedStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.THERMAL_CENTRIFUGE_RECIPES.recipeBuilder()).input(purifiedPrefix, material)).outputs(crushedCentrifugedStack)).chancedOutput(OrePrefix.dust, byproductMaterial, 3333, 0)).buildAndRegister();
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack solitaryStack = OreDictUnifier.get((OrePrefix)GTLiteOrePrefix.gemSolitary, (Material)material);
            ItemStack exquisiteStack = OreDictUnifier.get((OrePrefix)OrePrefix.gemExquisite, (Material)material);
            ItemStack flawlessStack = OreDictUnifier.get((OrePrefix)OrePrefix.gemFlawless, (Material)material);
            ItemStack gemStack = OreDictUnifier.get((OrePrefix)OrePrefix.gem, (Material)material);
            ItemStack flawedStack = OreDictUnifier.get((OrePrefix)OrePrefix.gemFlawed, (Material)material);
            ItemStack chippedStack = OreDictUnifier.get((OrePrefix)OrePrefix.gemChipped, (Material)material);
            if (material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder()).circuitMeta(1)).input(purifiedPrefix, material)).chancedOutput(solitaryStack, 100, 50)).chancedOutput(exquisiteStack, 500, 150)).chancedOutput(flawlessStack, 1500, 200)).chancedOutput(gemStack, 5000, 1000)).chancedOutput(flawedStack, 2000, 500)).chancedOutput(chippedStack, 3000, 350)).chancedOutput(dustStack, 2500, 500)).EUt((long)GTValues.VH[1])).duration(400)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder()).circuitMeta(2)).input(purifiedPrefix, material)).fluidInputs(GTLiteMaterials.INSTANCE.getZephyreanAerotheum().getFluid(250))).chancedOutput(solitaryStack, 200, 100)).chancedOutput(exquisiteStack, 1000, 300)).chancedOutput(flawlessStack, 3000, 400)).outputs(gemStack)).chancedOutput(flawedStack, 4000, 1000)).chancedOutput(chippedStack, 6000, 700)).chancedOutput(dustStack, 5000, 1000)).EUt((long)GTValues.VH[1])).duration(200)).buildAndRegister();
            } else {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder()).circuitMeta(1)).input(purifiedPrefix, material)).chancedOutput(solitaryStack, 50, 25)).chancedOutput(exquisiteStack, 300, 100)).chancedOutput(flawlessStack, 1000, 150)).chancedOutput(gemStack, 3500, 500)).chancedOutput(flawedStack, 2500, 300)).chancedOutput(chippedStack, 3500, 400)).chancedOutput(dustStack, 5000, 750)).EUt((long)GTValues.VH[1])).duration(400)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SIFTER_RECIPES.recipeBuilder()).circuitMeta(2)).input(purifiedPrefix, material)).fluidInputs(GTLiteMaterials.INSTANCE.getZephyreanAerotheum().getFluid(250))).chancedOutput(solitaryStack, 100, 50)).chancedOutput(exquisiteStack, 600, 200)).chancedOutput(flawlessStack, 2000, 300)).chancedOutput(gemStack, 7000, 1000)).chancedOutput(flawedStack, 5000, 600)).chancedOutput(chippedStack, 7000, 800)).outputs(dustStack)).EUt((long)GTValues.VH[1])).duration(200)).buildAndRegister();
            }
        }
        this.processMetalSmelting(purifiedPrefix, material, property);
    }

    private final void processCrushedOre(OrePrefix crushedPrefix, Material material, OreProperty property) {
        Material material2 = property.getOreByProduct(0, material);
        Intrinsics.checkNotNullExpressionValue((Object)material2, (String)"getOreByProduct(...)");
        Material byproductMaterial = material2;
        ItemStack[] itemStackArray = new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.crushedPurified, (Material)material), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)material)};
        ItemStack itemStack = GTUtility.copyFirst((ItemStack[])itemStackArray);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyFirst(...)");
        ItemStack crushedPurifiedOre = itemStack;
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ORE_WASHER_RECIPES.recipeBuilder()).circuitMeta(3)).input(crushedPrefix, material)).fluidInputs(GTLiteMaterials.INSTANCE.getTectonicPetrotheum().getFluid(100))).outputs(crushedPurifiedOre)).output(OrePrefix.dust, Materials.Stone)).chancedOutput(OrePrefix.dust, byproductMaterial, 6666, 0)).duration(100)).buildAndRegister();
    }

    private final void processMetalSmelting(OrePrefix crushedPrefix, Material material, OreProperty property) {
        Material smeltingResult;
        Material material2 = property.getDirectSmeltResult();
        if (material2 == null) {
            material2 = material;
        }
        if ((smeltingResult = material2).hasProperty(PropertyKey.INGOT)) {
            ItemStack itemStack = OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)smeltingResult);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"get(...)");
            ItemStack ingotStack = itemStack;
            if (!ingotStack.func_190926_b() && this.doesMaterialUseNormalFurnace(smeltingResult)) {
                ModHandler.addSmeltingRecipe((UnificationEntry)new UnificationEntry(crushedPrefix, material), (ItemStack)ingotStack, (float)0.5f);
            }
        }
    }

    private final boolean doesMaterialUseNormalFurnace(Material material) {
        return !material.hasProperty(PropertyKey.BLAST);
    }
}

