/*
 * Decompiled with CFR 0.152.
 */
package gregtechlite.gtlitecore.loader.recipe.handler;

import gregtech.api.GTValues;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtechlite.gtlitecore.api.extension.ItemStackExtKt;
import gregtechlite.gtlitecore.api.extension.RecipeBuilderExtKt;
import gregtechlite.gtlitecore.api.recipe.GTLiteRecipeMaps;
import gregtechlite.gtlitecore.api.unification.material.properties.AlloyBlastProperty;
import gregtechlite.gtlitecore.api.unification.material.properties.GTLitePropertyKey;
import gregtechlite.gtlitecore.api.unification.ore.GTLiteOrePrefix;
import gregtechlite.gtlitecore.common.item.GTLiteMetaItems;
import gregtechlite.gtlitecore.loader.recipe.producer.AlloyBlastRecipeProducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgregtechlite/gtlitecore/loader/recipe/handler/MaterialRecipeHandler;", "", "<init>", "()V", "GEM_ORDER", "", "Lgregtech/api/unification/ore/OrePrefix;", "kotlin.jvm.PlatformType", "init", "", "processIngot", "ingotPrefix", "material", "Lgregtech/api/unification/material/Material;", "property", "Lgregtech/api/unification/material/properties/IngotProperty;", "processBlock", "blockPrefix", "Lgregtech/api/unification/material/properties/DustProperty;", "processGemConversion", "gemPrefix", "prevPrefix", "processDust", "dustPrefix", "generateABSRecipes", "Lgregtechlite/gtlitecore/api/unification/material/properties/AlloyBlastProperty;", "generateMBFRecipes", "getVoltageMultiplier", "", "gtlitecore"})
@SourceDebugExtension(value={"SMAP\nMaterialRecipeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialRecipeHandler.kt\ngregtechlite/gtlitecore/loader/recipe/handler/MaterialRecipeHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,531:1\n37#2:532\n36#2,3:533\n*S KotlinDebug\n*F\n+ 1 MaterialRecipeHandler.kt\ngregtechlite/gtlitecore/loader/recipe/handler/MaterialRecipeHandler\n*L\n319#1:532\n319#1:533,3\n*E\n"})
public final class MaterialRecipeHandler {
    @NotNull
    public static final MaterialRecipeHandler INSTANCE = new MaterialRecipeHandler();
    @NotNull
    private static final List<OrePrefix> GEM_ORDER;

    private MaterialRecipeHandler() {
    }

    public final void init() {
        OrePrefix.ingot.addProcessingHandler(PropertyKey.INGOT, this::processIngot);
        OrePrefix.block.addProcessingHandler(PropertyKey.DUST, this::processBlock);
        int n = ((Collection)GEM_ORDER).size();
        for (int i = 0; i < n; ++i) {
            OrePrefix gemPrefix = GEM_ORDER.get(i);
            OrePrefix prevGemPrefix = i == 0 ? null : GEM_ORDER.get(i - 1);
            gemPrefix.addProcessingHandler(PropertyKey.GEM, (arg_0, arg_1, arg_2) -> MaterialRecipeHandler.init$lambda$0(prevGemPrefix, arg_0, arg_1, arg_2));
        }
        OrePrefix.dust.addProcessingHandler(PropertyKey.DUST, this::processDust);
        OrePrefix.ingot.addProcessingHandler(GTLitePropertyKey.ALLOY_BLAST, this::generateABSRecipes);
        OrePrefix.dust.addProcessingHandler(PropertyKey.DUST, this::generateMBFRecipes);
    }

    private final void processIngot(OrePrefix ingotPrefix, Material material, IngotProperty property) {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        int workingTier = material.getWorkingTier();
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE) && workingTier <= 3) {
            objectArray2 = "mortar_grind_%s";
            object = new Object[]{material};
            String string = String.format((String)objectArray2, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            objectArray = new Object[]{"X", "m", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material)};
            ModHandler.addShapedRecipe((String)string, (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)material), (Object[])objectArray);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (workingTier <= 3) {
                objectArray2 = "stick_%s";
                object = new Object[]{material};
                String string = String.format((String)objectArray2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                objectArray = new Object[]{"f ", " X", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material)};
                ModHandler.addShapedRecipe((String)string, (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)material), (Object[])objectArray);
            }
            if (!material.hasFlag(MaterialFlags.NO_WORKING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD)).input(ingotPrefix, material)).output(OrePrefix.stick, material, 2)).EUt(GTUtility.scaleVoltage((long)((long)6 * this.getVoltageMultiplier(material)), (int)workingTier))).duration((int)(material.getMass() * (long)2))).buildAndRegister();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.SLICER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSLICER_BLADE_STRIPES())).input(ingotPrefix, material)).output(OrePrefix.stick, material, 2)).EUt(GTUtility.scaleVoltage((long)((long)6 * this.getVoltageMultiplier(material)), (int)workingTier))).duration((int)(material.getMass() * (long)2))).buildAndRegister();
                }
            }
        }
        if (material.hasFluid()) {
            Fluid fluid = ((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom();
            Intrinsics.checkNotNull((Object)fluid);
            if (!fluid.equals(null)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom(144))).output(ingotPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[0], (int)workingTier))).duration(20)).buildAndRegister();
            }
        }
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_INGOT)).input(OrePrefix.dust, material)).output(ingotPrefix, material)).EUt(GTUtility.scaleVoltage((long)((long)4 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(10)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_NUGGET)).input(ingotPrefix, material)).output(OrePrefix.nugget, material, 9)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[0], (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
        ItemStack itemStack = OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)material);
        Intrinsics.checkNotNull((Object)itemStack);
        if (!itemStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_INGOT)).input(OrePrefix.block, material)).output(ingotPrefix, material, 9)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[0], (int)workingTier))).duration((int)(material.getMass() * (long)9))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder()).input(ingotPrefix, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).output(OrePrefix.block, material)).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.NO_WORKING)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ItemStack plateStack;
                ItemStack itemStack2 = plateStack = OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)material);
                Intrinsics.checkNotNull((Object)itemStack2);
                if (!itemStack2.func_190926_b()) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder()).circuitMeta(1)).input(ingotPrefix, material)).outputs(plateStack)).EUt(GTUtility.scaleVoltage((long)24L, (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
                    objectArray2 = new ItemStack[]{plateStack};
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder()).input(ingotPrefix, material, 3)).outputs(GTUtility.copyFirst((int)2, (ItemStack[])objectArray2))).EUt(GTUtility.scaleVoltage((long)GTValues.VH[1], (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
                    if (workingTier <= 3) {
                        object = "plate_%s";
                        Object[] objectArray3 = new Object[]{material};
                        String string = String.format((String)object, Arrays.copyOf(objectArray3, objectArray3.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                        objectArray2 = new Object[]{"h", "I", "I", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material)};
                        ModHandler.addShapedRecipe((String)string, (ItemStack)plateStack, (Object[])objectArray2);
                    }
                }
            }
            ItemStack itemStack3 = OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)material);
            Intrinsics.checkNotNull((Object)itemStack3);
            if (!itemStack3.func_190926_b()) {
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.SLICER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSLICER_BLADE_FLAT())).input(ingotPrefix, material)).output(OrePrefix.plate, material)).EUt(GTUtility.scaleVoltage((long)((long)8 * this.getVoltageMultiplier(material)), (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_PLATE)).input(OrePrefix.dust, material)).output(OrePrefix.plate, material)).EUt(GTUtility.scaleVoltage((long)((long)8 * this.getVoltageMultiplier(material)), (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
                } else {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_PLATE)).input(ingotPrefix, material)).output(OrePrefix.plate, material)).EUt(GTUtility.scaleVoltage((long)((long)8 * this.getVoltageMultiplier(material)), (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
                }
            }
        }
    }

    private final void processBlock(OrePrefix blockPrefix, Material material, DustProperty property) {
        ItemStack blockStack = OreDictUnifier.get((OrePrefix)blockPrefix, (Material)material);
        int workingTier = material.getWorkingTier();
        long materialAmount = blockPrefix.getMaterialAmount(material);
        if (material.hasFluid()) {
            Fluid fluid = ((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom();
            Intrinsics.checkNotNull((Object)fluid);
            if (!fluid.equals(null)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom((int)(materialAmount * (long)144 / 3628800L)))).outputs(blockStack)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[0], (int)workingTier))).duration((int)material.getMass())).buildAndRegister();
            }
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            ItemStack plateStack;
            ItemStack itemStack = plateStack = OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)material);
            Intrinsics.checkNotNull((Object)itemStack);
            if (!itemStack.func_190926_b()) {
                ItemStack[] itemStackArray;
                if (material.hasFlag(MaterialFlags.NO_SMASHING) && !material.hasProperty(PropertyKey.GEM)) {
                    itemStackArray = new ItemStack[]{plateStack};
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTLiteRecipeMaps.SLICER_RECIPES.recipeBuilder()).notConsumable(GTLiteMetaItems.INSTANCE.getSLICER_BLADE_OCTAGONAL())).input(blockPrefix, material)).outputs(GTUtility.copyFirst((int)((int)(materialAmount / 3628800L)), (ItemStack[])itemStackArray))).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration((int)(material.getMass() * (long)8))).buildAndRegister();
                } else {
                    itemStackArray = new ItemStack[]{plateStack};
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).input(blockPrefix, material)).outputs(GTUtility.copyFirst((int)((int)(materialAmount / 3628800L)), (ItemStack[])itemStackArray))).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration((int)(material.getMass() * (long)8))).buildAndRegister();
                }
            }
        }
        UnificationEntry blockEntry = null;
        blockEntry = material.hasProperty(PropertyKey.GEM) ? new UnificationEntry(OrePrefix.gem, material) : (material.hasProperty(PropertyKey.INGOT) ? new UnificationEntry(OrePrefix.ingot, material) : new UnificationEntry(OrePrefix.dust, material));
        ArrayList<UnificationEntry> result = new ArrayList<UnificationEntry>();
        long l = materialAmount / 3628800L;
        for (long i = 0L; i < l; ++i) {
            result.add(blockEntry);
        }
        if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES) && !ConfigHolder.recipes.disableManualCompression) {
                String string = "block_compress_%s";
                Object[] objectArray = new Object[]{material};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                Collection $this$toTypedArray$iv = result;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
                ModHandler.addShapelessRecipe((String)string2, (ItemStack)blockStack, (Object[])Arrays.copyOf(objectArray2, objectArray2.length));
                string = "block_decompress_%s";
                Object[] objectArray3 = new Object[]{material};
                String string3 = String.format(string, Arrays.copyOf(objectArray3, objectArray3.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                objectArray2 = new ItemStack[]{OreDictUnifier.get((UnificationEntry)blockEntry)};
                ItemStack itemStack = GTUtility.copyFirst((int)((int)(materialAmount / 3628800L)), (ItemStack[])objectArray2);
                objectArray2 = new Object[]{new UnificationEntry(blockPrefix, material)};
                ModHandler.addShapelessRecipe((String)string3, (ItemStack)itemStack, (Object[])objectArray2);
            }
            if (material.hasProperty(PropertyKey.INGOT)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_EXTRUDER_BLOCK)).input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).outputs(blockStack)).EUt(GTUtility.scaleVoltage((long)((long)8 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(10)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).outputs(blockStack)).EUt(GTUtility.scaleVoltage((long)((long)4 * this.getVoltageMultiplier(material)), (int)workingTier))).duration(5)).buildAndRegister();
            } else if (material.hasProperty(PropertyKey.GEM)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder()).input(OrePrefix.gem, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).outputs(blockStack)).EUt(GTUtility.scaleVoltage((long)2L, (int)workingTier))).duration(300)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder()).input(blockPrefix, material)).output(OrePrefix.gem, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).EUt(GTUtility.scaleVoltage((long)24L, (int)workingTier))).duration(100)).buildAndRegister();
            }
        }
    }

    private final void processGemConversion(OrePrefix gemPrefix, OrePrefix prevPrefix, Material material) {
        ItemStack prevStack;
        Object object;
        Object[] objectArray;
        long materialAmount = gemPrefix.getMaterialAmount(material);
        int workingTier = material.getWorkingTier();
        ItemStack crushedStack = OreDictUnifier.getDust((Material)material, (long)materialAmount);
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE) && workingTier <= 3) {
            objectArray = "gem_to_dust_%s_%s";
            object = new Object[]{material, gemPrefix};
            String string = String.format((String)objectArray, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            Object[] objectArray2 = new Object[]{"X", "m", Character.valueOf('X'), new UnificationEntry(gemPrefix, material)};
            ModHandler.addShapedRecipe((String)string, (ItemStack)crushedStack, (Object[])objectArray2);
        }
        OrePrefix orePrefix = prevPrefix;
        ItemStack itemStack = prevStack = orePrefix == null ? ItemStack.field_190927_a : OreDictUnifier.get((OrePrefix)orePrefix, (Material)material, (int)2);
        if (!prevStack.func_190926_b()) {
            object = "gem_to_gem_%s_%s";
            Object[] objectArray3 = new Object[]{prevPrefix, material};
            String string = String.format((String)object, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            objectArray = new Object[]{"h", new UnificationEntry(gemPrefix, material)};
            ModHandler.addShapelessRecipe((String)string, (ItemStack)prevStack, (Object[])objectArray);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).input(gemPrefix, material)).outputs(prevStack)).EUt((long)GTValues.VH[1])).duration(20)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder()).notConsumable(OrePrefix.craftingLens, (Material)MarkerMaterials.Color.White)).inputs(prevStack)).output(gemPrefix, material)).EUt(GTUtility.scaleVoltage((long)GTValues.VHA[3], (int)workingTier))).duration(300)).buildAndRegister();
        }
    }

    private final void processDust(OrePrefix dustPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        ItemStack dustStack = OreDictUnifier.get((OrePrefix)dustPrefix, (Material)material);
        if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack gemStack = OreDictUnifier.get((OrePrefix)OrePrefix.gem, (Material)material);
            if (!material.hasFlag(MaterialFlags.EXPLOSIVE) && !material.hasFlag(MaterialFlags.FLAMMABLE)) {
                SimpleRecipeBuilder simpleRecipeBuilder = (SimpleRecipeBuilder)GTLiteRecipeMaps.ELECTRIC_IMPLOSION_RECIPES.recipeBuilder();
                Intrinsics.checkNotNull((Object)dustStack);
                SimpleRecipeBuilder simpleRecipeBuilder2 = (SimpleRecipeBuilder)simpleRecipeBuilder.inputs(ItemStackExtKt.copy(dustStack, 4));
                Intrinsics.checkNotNull((Object)gemStack);
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)simpleRecipeBuilder2.outputs(ItemStackExtKt.copy(gemStack, 3))).chancedOutput(OrePrefix.dust, Materials.DarkAsh, 2500, 0)).EUt(GTUtility.scaleVoltage((long)GTValues.VA[1], (int)workingTier))).duration(20)).buildAndRegister();
            }
        }
    }

    private final void generateABSRecipes(OrePrefix ingotPrefix, Material material, AlloyBlastProperty property) {
        if (material.hasProperty(PropertyKey.BLAST)) {
            AlloyBlastRecipeProducer alloyBlastRecipeProducer = property.getRecipeProducer();
            IMaterialProperty iMaterialProperty = material.getProperty(PropertyKey.BLAST);
            Intrinsics.checkNotNullExpressionValue((Object)iMaterialProperty, (String)"getProperty(...)");
            alloyBlastRecipeProducer.produce(material, (BlastProperty)iMaterialProperty);
        }
    }

    private final void generateMBFRecipes(OrePrefix dustPrefix, Material material, DustProperty property) {
        if (material.hasProperty(PropertyKey.INGOT)) {
            MaterialFlag[] materialFlagArray = new MaterialFlag[]{MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING};
            if (!material.hasAnyOfFlags(materialFlagArray)) {
                ItemStack ingotStack = OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)material);
                int blastTemp = material.getBlastTemperature();
                if (!ingotStack.func_190926_b()) {
                    BlastProperty blastProp;
                    if (blastTemp == 0) {
                        blastTemp += 1200;
                    }
                    if ((blastProp = (BlastProperty)material.getProperty(PropertyKey.BLAST)) != null) {
                        int eut;
                        int duration = blastProp.getDurationOverride();
                        if (duration <= 0) {
                            duration = (int)Math.max(1L, material.getMass() * (long)blastTemp / (long)50);
                        }
                        if ((eut = blastProp.getEUtOverride()) <= 0) {
                            eut = GTValues.VA[2];
                        }
                        RecipeBuilder recipeBuilder = ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES.recipeBuilder()).circuitMeta(1)).input(dustPrefix, material)).outputs(ingotStack);
                        Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder, (String)"outputs(...)");
                        Object t = RecipeBuilderExtKt.EUt(recipeBuilder, eut);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"EUt(...)");
                        ((BlastRecipeBuilder)RecipeBuilderExtKt.duration(t, (double)duration * 0.5)).blastFurnaceTemp(blastTemp).buildAndRegister();
                        if (material.hasFluid()) {
                            RecipeBuilder recipeBuilder2 = ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES.recipeBuilder()).circuitMeta(2)).input(dustPrefix, material)).fluidOutputs(material.getFluid(144));
                            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder2, (String)"fluidOutputs(...)");
                            t = RecipeBuilderExtKt.EUt(recipeBuilder2, eut);
                            Intrinsics.checkNotNullExpressionValue(t, (String)"EUt(...)");
                            ((BlastRecipeBuilder)RecipeBuilderExtKt.duration(t, (double)duration * 0.5)).blastFurnaceTemp(blastTemp).buildAndRegister();
                            RecipeBuilder recipeBuilder3 = ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES.recipeBuilder()).circuitMeta(4)).inputs(ingotStack)).fluidOutputs(material.getFluid(144));
                            Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder3, (String)"fluidOutputs(...)");
                            t = RecipeBuilderExtKt.EUt(recipeBuilder3, eut);
                            Intrinsics.checkNotNullExpressionValue(t, (String)"EUt(...)");
                            ((BlastRecipeBuilder)RecipeBuilderExtKt.duration(t, (double)duration * 0.5)).blastFurnaceTemp(blastTemp).buildAndRegister();
                            if (material.getFluid(FluidStorageKeys.PLASMA) != null) {
                                RecipeBuilder recipeBuilder4 = ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES.recipeBuilder()).circuitMeta(3)).input(dustPrefix, material)).fluidOutputs(material.getPlasma(144));
                                Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder4, (String)"fluidOutputs(...)");
                                t = RecipeBuilderExtKt.EUt(recipeBuilder4, eut);
                                Intrinsics.checkNotNullExpressionValue(t, (String)"EUt(...)");
                                ((BlastRecipeBuilder)RecipeBuilderExtKt.duration(t, (double)duration * 0.5)).blastFurnaceTemp(blastTemp).buildAndRegister();
                                RecipeBuilder recipeBuilder5 = ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)GTLiteRecipeMaps.TOPOLOGICAL_ORDER_CHANGING_RECIPES.recipeBuilder()).circuitMeta(5)).inputs(ingotStack)).fluidOutputs(material.getPlasma(144));
                                Intrinsics.checkNotNullExpressionValue((Object)recipeBuilder5, (String)"fluidOutputs(...)");
                                t = RecipeBuilderExtKt.EUt(recipeBuilder5, eut);
                                Intrinsics.checkNotNullExpressionValue(t, (String)"EUt(...)");
                                ((BlastRecipeBuilder)RecipeBuilderExtKt.duration(t, (double)duration * 0.5)).blastFurnaceTemp(blastTemp).buildAndRegister();
                            }
                        }
                    }
                }
            }
        }
    }

    private final long getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? (long)GTValues.VA[1] : (long)GTValues.VA[0];
    }

    private static final void init$lambda$0(OrePrefix $prevGemPrefix, OrePrefix p, Material m, GemProperty gemProperty) {
        Intrinsics.checkNotNull((Object)p);
        Intrinsics.checkNotNull((Object)m);
        INSTANCE.processGemConversion(p, $prevGemPrefix, m);
    }

    static {
        Object[] objectArray = new OrePrefix[]{OrePrefix.gemChipped, OrePrefix.gemFlawed, OrePrefix.gem, OrePrefix.gemFlawless, OrePrefix.gemExquisite, GTLiteOrePrefix.gemSolitary};
        GEM_ORDER = CollectionsKt.listOf((Object[])objectArray);
    }
}

